/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.video;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.JavaFXFrameConverter;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.ApplicationRunner;

public class VideoViewerWithSlider {
    private final ExecutorService videoExecutor = Executors.newSingleThreadExecutor();
    private File videoFile = null;
    private ImageView imageView = null;
    private FFmpegFrameGrabber frameGrabber = null;
    private Slider timeSlider = null;
    private final AtomicInteger currentFrameNumber = new AtomicInteger(-1);

    public VideoViewerWithSlider() {
        avutil.av_log_set_level((int)16);
    }

    public static void main(String[] args) {
        Platform.setImplicitExit((boolean)true);
        ApplicationRunner.runApplication(new Application(){
            final VideoViewerWithSlider demo = new VideoViewerWithSlider();

            public void start(Stage primaryStage) throws Exception {
                this.demo.init(primaryStage);
                this.demo.playVideoUsingSlider();
            }
        });
    }

    public void init(Stage primaryStage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Video Files", new String[]{"*.mp4", "*.avi"})});
        this.videoFile = fileChooser.showOpenDialog((Window)primaryStage);
        this.frameGrabber = new FFmpegFrameGrabber(this.videoFile);
        try {
            this.frameGrabber.start();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            LogTools.error((String)e.getMessage());
        }
        BorderPane root = new BorderPane();
        root.setPrefSize(1200.0, 800.0);
        this.imageView = new ImageView();
        StackPane imageContainer = new StackPane(new Node[]{this.imageView});
        this.imageView.setPreserveRatio(true);
        this.imageView.fitWidthProperty().bind((ObservableValue)imageContainer.widthProperty());
        this.imageView.fitHeightProperty().bind((ObservableValue)imageContainer.heightProperty());
        root.setCenter((Node)imageContainer);
        BorderPane.setAlignment((Node)imageContainer, (Pos)Pos.CENTER);
        HBox mediaBar = new HBox();
        mediaBar.setAlignment(Pos.CENTER);
        mediaBar.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        BorderPane.setAlignment((Node)mediaBar, (Pos)Pos.CENTER);
        this.timeSlider = new Slider();
        HBox.setHgrow((Node)this.timeSlider, (Priority)Priority.NEVER);
        this.timeSlider.setMin(0.0);
        this.timeSlider.setMax((double)this.frameGrabber.getLengthInVideoFrames());
        this.timeSlider.setPrefWidth(600.0);
        mediaBar.getChildren().add((Object)this.timeSlider);
        root.setBottom((Node)mediaBar);
        Scene scene = new Scene((Parent)root);
        primaryStage.setTitle(this.videoFile.getName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(event -> this.stop());
        primaryStage.show();
    }

    public void playVideoUsingSlider() {
        final JavaFXFrameConverter frameConverter = new JavaFXFrameConverter();
        this.timeSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.timeSlider.setValue((double)newValue.intValue());
            this.currentFrameNumber.set(newValue.intValue());
        });
        this.videoExecutor.submit(() -> {
            while (!Thread.interrupted()) {
                if (this.frameGrabber.getFrameNumber() == this.currentFrameNumber.get()) continue;
                try {
                    this.frameGrabber.setVideoFrameNumber(this.currentFrameNumber.get());
                    final Frame frame = this.frameGrabber.grabFrame();
                    if (frame == null || frame.image == null) continue;
                    Platform.runLater((Runnable)new Runnable(){
                        final Image image;
                        {
                            this.image = frameConverter.convert(frame);
                        }

                        @Override
                        public void run() {
                            VideoViewerWithSlider.this.imageView.setImage(this.image);
                        }
                    });
                }
                catch (FrameGrabber.Exception e) {
                    LogTools.error((String)e.getMessage());
                }
            }
        });
    }

    public void stop() throws RuntimeException {
        try {
            this.videoExecutor.shutdownNow();
            this.videoExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            this.frameGrabber.stop();
            this.frameGrabber.release();
        }
        catch (InterruptedException | FFmpegFrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }
}

