/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Box;
import javafx.stage.Stage;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MultiColorTriangleMesh3DBuilder;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorAdaptivePalette;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorPalette;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.ApplicationRunner;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Simple3DViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;

public class MultiColorTriangleMesh3DBuilderVisualizer {
    private static final MeshToDisplay MESH_TO_DISPLAY = MeshToDisplay.BOX;
    private static final boolean USE_RANDOM_COLORS = true;
    private final Random random = new Random(453L);

    public MultiColorTriangleMesh3DBuilderVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        Scene3DBuilder scene3DBuilder = new Scene3DBuilder();
        Scene scene = new Scene((Parent)scene3DBuilder.getRoot(), 600.0, 400.0, true, SceneAntialiasing.BALANCED);
        scene.setFill((Paint)Color.GREY);
        Simple3DViewer.setupCamera(scene, scene3DBuilder.getRoot());
        scene3DBuilder.addCoordinateSystem(0.3);
        ColorDefinition[] colors = new ColorDefinition[0x100000];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ColorDefinition.rgb((int)this.random.nextInt());
        }
        MultiColorTriangleMesh3DBuilder meshBuilder = new MultiColorTriangleMesh3DBuilder((TextureDefinitionColorPalette)new TextureDefinitionColorAdaptivePalette());
        switch (MESH_TO_DISPLAY) {
            case BOX: {
                scene3DBuilder.addNodesToView(this.addRandomBoxes(colors, meshBuilder));
                break;
            }
            case LINE: {
                this.addLine(meshBuilder);
            }
            case MULTI_LINE: {
                this.addMultiLine(meshBuilder);
            }
        }
        scene3DBuilder.addNodeToView(JavaFXVisualTools.toNode((VisualDefinition)meshBuilder.generateVisual(), null));
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private void addMultiLine(MultiColorTriangleMesh3DBuilder meshBuilder) {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        double radius = 0.4;
        Random random = new Random();
        for (double angle = 0.0; angle < Math.PI * 2; angle += 0.12566370614359174) {
            double x = radius * random.nextDouble() * Math.cos(angle);
            double y = radius * Math.sin(angle);
            double z = 0.1 * random.nextDouble();
            points.add(new Point3D(x, y, z));
        }
        meshBuilder.addMultiLine(points, 0.01, true, ColorDefinitions.YellowGreen());
    }

    private void addLine(MultiColorTriangleMesh3DBuilder meshBuilder) {
        Point3D start = new Point3D(0.3, 0.0, -0.0);
        Point3D end = new Point3D(0.0, 0.3, 0.0);
        double lineWidth = 0.01;
        meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, ColorDefinitions.Red());
    }

    public List<Box> addRandomBoxes(ColorDefinition[] colors, MultiColorTriangleMesh3DBuilder meshBuilder) {
        int count = 0;
        Random random = new Random();
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (float x = -1.0f; x <= 1.0f; x += 0.055f) {
            for (float y = -1.0f; y <= 1.0f; y += 0.055f) {
                for (float z = -0.0f; z <= 0.01f; z += 0.055f) {
                    ColorDefinition color = colors[count % colors.length];
                    Vector3D32 pointsOffset = new Vector3D32(x, y, 0.0f * RandomNumbers.nextFloat((Random)random, (float)-5.0f, (float)5.0f));
                    meshBuilder.addBox(0.05, 0.05, 0.05, (Tuple3DReadOnly)pointsOffset, color);
                    ++count;
                }
            }
        }
        System.out.println("Number of boxes: " + count);
        return boxes;
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(MultiColorTriangleMesh3DBuilderVisualizer::new);
    }

    private static enum MeshToDisplay {
        BOX,
        LINE,
        MULTI_LINE;

    }
}

