/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TriangleMesh3DBuilder;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Simple3DViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;

public class TriangleMesh3DBuilderJFXVisualizer {
    private static final MeshToDisplay MESH_TO_DISPLAY = MeshToDisplay.BOX;

    public TriangleMesh3DBuilderJFXVisualizer() {
        TriangleMesh3DBuilder meshBuilder = new TriangleMesh3DBuilder();
        switch (MESH_TO_DISPLAY) {
            case BOX: {
                this.addRandomBoxes(meshBuilder);
                break;
            }
            case LINE: {
                this.addLines(meshBuilder);
                break;
            }
            case CYLINDER: {
                this.addCylinders(meshBuilder);
                break;
            }
            case CONE: {
                this.addCones(meshBuilder);
                break;
            }
        }
        MaterialDefinition materialDefinition = new MaterialDefinition(ColorDefinitions.Cyan());
        materialDefinition.setSpecularColor(ColorDefinitions.Cyan().brighter());
        materialDefinition.setShininess(3.0);
        Simple3DViewer.view3DObjects(JavaFXVisualTools.toNode((VisualDefinition)new VisualDefinition((GeometryDefinition)meshBuilder.generateTriangleMesh3D(), materialDefinition), null));
    }

    public void addRandomBoxes(TriangleMesh3DBuilder meshBuilder) {
        int count = 0;
        for (float x = -5.0f; x <= 5.0f; x += 0.055f) {
            for (float y = -2.0f; y <= 2.0f; y += 0.055f) {
                meshBuilder.addBox((double)0.05f, (double)0.05f, (double)0.05f, (Tuple3DReadOnly)new Vector3D32(x, y, RandomNumbers.nextFloat((Random)new Random(), (float)-2.0f, (float)2.0f)));
                ++count;
            }
        }
        System.out.println("Number of boxes: " + count);
    }

    private void addLines(TriangleMesh3DBuilder meshBuilder) {
        Point3D start = new Point3D(0.3, 0.0, -0.0);
        Point3D end = new Point3D(0.0, 0.3, 0.0);
        double lineWidth = 0.01;
        meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
    }

    private void addCylinders(TriangleMesh3DBuilder meshBuilder) {
        Point3D cylinderPosition = new Point3D(1.0, 0.0, 0.0);
        double height = 0.3;
        double radius = 0.1;
        meshBuilder.addCylinder(height, radius, (Tuple3DReadOnly)cylinderPosition);
        meshBuilder.addTriangleMesh3D(TriangleMesh3DFactories.Cylinder((double)radius, (double)height, (int)64, (boolean)true));
    }

    private void addCones(TriangleMesh3DBuilder meshBuilder) {
        Point3D conePosition = new Point3D(0.4, 0.0, 0.0);
        double height = 0.3;
        double radius = 0.1;
        meshBuilder.addCone(height, radius, (Tuple3DReadOnly)conePosition);
        meshBuilder.addTriangleMesh3D(TriangleMesh3DFactories.Cone((double)height, (double)radius, (int)64));
    }

    public static void main(String[] args) {
        new TriangleMesh3DBuilderJFXVisualizer();
    }

    private static enum MeshToDisplay {
        BOX,
        LINE,
        CYLINDER,
        CONE;

    }
}

