/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;

public class BoxTeeteringEdgeToEdgeExperimentalSimulation {
    public BoxTeeteringEdgeToEdgeExperimentalSimulation() {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setErrorReductionParameter(0.001);
        double boxXLength = 0.2;
        double boxYWidth = 0.12;
        double boxZHeight = 0.4;
        double boxMass = 1.0;
        double boxRadiusOfGyrationPercent = 0.8;
        double initialBoxRoll = -0.04908738521234052;
        double initialVelocity = 0.0;
        double groundWidth = 1.0;
        double groundLength = 1.0;
        RobotDefinition boxRobot = ExampleExperimentalSimulationTools.newBoxRobot("box", boxXLength, boxYWidth, boxZHeight, boxMass, boxRadiusOfGyrationPercent, ColorDefinitions.DarkCyan());
        boxRobot.getRigidBodyDefinition("boxRigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxXLength, boxYWidth, boxZHeight)));
        SixDoFJointState initialJointState = new SixDoFJointState((Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, initialBoxRoll), (Tuple3DReadOnly)new Point3D(0.0, groundWidth / 2.0 - 0.002, boxZHeight / 2.0 * 1.05 + boxYWidth / 2.0 * Math.sin(Math.abs(initialBoxRoll))));
        initialJointState.setVelocity(null, (Vector3DReadOnly)new Vector3D(initialVelocity, 0.0, 0.0));
        ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialJointState);
        Box3DDefinition terrainGeometry = new Box3DDefinition(groundLength, groundWidth, 0.1);
        RigidBodyTransform terrainPose = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.05));
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        SimulationSession simulationSession = new SimulationSession(PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory((ContactParametersReadOnly)contactParameters));
        simulationSession.addRobot(boxRobot);
        simulationSession.addTerrainObject(terrain);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new BoxTeeteringEdgeToEdgeExperimentalSimulation();
    }
}

