/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import javafx.scene.Node;
import javafx.scene.control.Button;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.examples.simulations.BallRobotDefinition;
import us.ihmc.scs2.examples.simulations.SlopeGroundDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.simulation.SimulationSession;

public class FallingBallSimulation {
    private final SessionVisualizerControls controls;
    private final BallRobotDefinition robotDefinition = new BallRobotDefinition();
    private YoDoubleProperty q_z;
    private Button moveUpButton;

    public FallingBallSimulation() {
        SixDoFJointState initialJointState = new SixDoFJointState();
        initialJointState.setConfiguration((Pose3DReadOnly)new Pose3D(0.0, 0.0, 1.0, 0.0, 0.0, 0.0));
        initialJointState.setVelocity((Vector3DReadOnly)new Vector3D(10.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(-1.0, 0.0, 0.0));
        ((JointDefinition)this.robotDefinition.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)initialJointState);
        SimulationSession simulationSession = new SimulationSession();
        simulationSession.addRobot((RobotDefinition)this.robotDefinition);
        simulationSession.addTerrainObject((TerrainObjectDefinition)new SlopeGroundDefinition(Math.toRadians(15.0)));
        this.controls = SessionVisualizer.startSessionVisualizer((Session)simulationSession);
        this.controls.addSessionChangedListener((oldSession, newSession) -> {
            if (newSession != null && newSession instanceof SimulationSession) {
                this.initializeCustomGUIControls();
            } else {
                this.disposeCustomGUIControls();
            }
        });
    }

    public void initializeCustomGUIControls() {
        if (this.controls.isVisualizerShutdown()) {
            return;
        }
        if (this.q_z != null) {
            return;
        }
        this.q_z = this.controls.newYoDoubleProperty("q_" + ((JointDefinition)this.robotDefinition.getRootJointDefinitions().get(0)).getName() + "_z");
        this.moveUpButton = new Button("Move Up");
        this.moveUpButton.setOnAction(e -> this.q_z.set(this.q_z.get() + 0.1));
        this.controls.addCustomGUIControl((Node)this.moveUpButton);
    }

    public void disposeCustomGUIControls() {
        if (this.controls.isVisualizerShutdown()) {
            return;
        }
        if (this.moveUpButton != null) {
            this.controls.removeCustomGUIControl((Node)this.moveUpButton);
            this.moveUpButton = null;
        }
        if (this.q_z != null) {
            this.q_z.dispose();
            this.q_z = null;
        }
    }

    public static void main(String[] args) {
        new FallingBallSimulation();
    }
}

