/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.shapes.JavaFXCoordinateSystem;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Simple3DViewer;
import us.ihmc.scs2.sessionVisualizer.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;

public class TriangleMesh3DFactoriesVisualizer {
    private static final boolean USE_TEXTURE = false;
    private final View3DFactory view3dFactory;
    private final PhongMaterial defaultMaterial;
    private final int gridWidth = 2;
    private int currentX = 0;
    private int currentY = 0;
    private final double cellSize = 0.5;

    public TriangleMesh3DFactoriesVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        this.view3dFactory = new View3DFactory(600.0, 400.0);
        FocusBasedCameraMouseEventHandler cameraController = this.view3dFactory.addCameraController(true);
        cameraController.changeCameraPosition(-1.0, -1.0, 1.0);
        this.view3dFactory.addWorldCoordinateSystem(0.25);
        this.view3dFactory.addNodeToView(Simple3DViewer.createAxisLabels());
        this.defaultMaterial = new PhongMaterial(Color.CYAN);
        List<? extends Point2DReadOnly> polygonVertices = this.createPolygon();
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.ArcTorus((double)0.0, (double)Math.PI, (double)0.15, (double)0.05, (int)64));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Cylinder((double)0.1, (double)0.3, (int)64, (boolean)true));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.FlatRectangle((double)0.2, (double)0.3, (double)0.0));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Cone((double)0.3, (double)0.1, (int)64));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Ramp((double)0.3, (double)0.2, (double)0.2));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Ellipsoid((double)0.15, (double)0.05, (double)0.2, (int)64, (int)64));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.ExtrudedPolygon(polygonVertices, (double)0.1));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Line((double)-0.05, (double)-0.15, (double)0.2, (double)0.25, (double)0.2, (double)-0.1, (double)0.01));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.PyramidBox((double)0.1, (double)0.2, (double)0.1, (double)0.25));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Capsule((double)0.2, (double)0.025, (double)0.05, (double)0.07, (int)16, (int)16));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.TruncatedCone((double)0.25, (double)0.2, (double)0.07, (double)0.05, (double)0.1, (int)64, (boolean)false));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.HemiEllipsoid((double)0.1, (double)0.2, (double)0.2, (int)64, (int)64));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Tetrahedron((double)0.3));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.PolygonCounterClockwise(null, polygonVertices));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.ConvexPolytope((ConvexPolytope3DReadOnly)EuclidPolytopeFactories.newIcosahedron((double)0.2)));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Box((double)0.1, (double)0.2, (double)0.3, (boolean)true));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.PolygonCounterClockwise(polygonVertices.stream().map(p2D -> {
            Point3D p3D = new Point3D((Tuple2DReadOnly)p2D);
            p3D.setZ(0.1 * (Math.random() - 0.5));
            return p3D;
        }).collect(Collectors.toList())));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)64));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.toSTPBox3DMesh(null, (double)0.3, (double)0.2, (double)0.1, (double)0.01, (double)2.5, (boolean)true));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.toSTPCylinder3DMesh(null, (double)0.05, (double)0.3, (double)0.005, (double)1.135, (boolean)true));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.toSTPCapsule3DMesh(null, (double)0.05, (double)0.3, (double)0.055, (double)0.8125, (boolean)true));
        this.addTriangleMesh3DDefinitionToScene(TriangleMesh3DFactories.toSTPRamp3DMesh(null, (double)0.3, (double)0.2, (double)0.1, (double)0.01, (double)2.5, (boolean)true));
        primaryStage.setMaximized(true);
        primaryStage.setScene(this.view3dFactory.getScene());
        primaryStage.show();
    }

    private List<? extends Point2DReadOnly> createPolygon() {
        ConvexPolygon2D polygon = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)new Random(), (double)0.3, (int)10);
        List vertices = polygon.getPolygonVerticesView().stream().map(Point2D::new).collect(Collectors.toList());
        Collections.reverse(vertices);
        return vertices;
    }

    private void addTriangleMesh3DDefinitionToScene(TriangleMesh3DDefinition definition) {
        this.addShape3DToScene((Shape3D)new MeshView((Mesh)JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((TriangleMesh3DDefinition)definition, (boolean)false)));
    }

    private void addShape3DToScene(Shape3D node) {
        Translate translate = this.nextNodePosition();
        node.setMaterial((Material)this.defaultMaterial);
        JavaFXCoordinateSystem coordinateSystem = new JavaFXCoordinateSystem(0.2);
        coordinateSystem.setMouseTransparent(true);
        if (translate != null) {
            node.getTransforms().add((Object)translate);
            coordinateSystem.getTransforms().add((Object)translate);
            this.view3dFactory.addNodeToView((Node)coordinateSystem);
        }
        this.view3dFactory.addNodeToView((Node)node);
    }

    private Translate nextNodePosition() {
        Translate next = this.currentX == 0 && this.currentY == 0 ? null : new Translate((double)this.currentX * 0.5, (double)this.currentY * 0.5);
        this.currentY = TriangleMesh3DFactoriesVisualizer.nextIndex(this.currentY);
        if (this.currentY > 2) {
            this.currentY = 0;
            this.currentX = TriangleMesh3DFactoriesVisualizer.nextIndex(this.currentX);
        }
        return next;
    }

    private static int nextIndex(int index) {
        if (index == 0) {
            return 1;
        }
        if (index > 0) {
            return -index;
        }
        return -index + 1;
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(TriangleMesh3DFactoriesVisualizer::new);
    }
}

