/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleFunction;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.geometry.ArcTorus3DDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrudedPolygon2DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.Polygon2DDefinition;
import us.ihmc.scs2.definition.geometry.Polygon3DDefinition;
import us.ihmc.scs2.definition.geometry.PyramidBox3DDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Tetrahedron3DDefinition;
import us.ihmc.scs2.definition.geometry.Torus3DDefinition;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.visual.SegmentedLine3DTriangleMeshFactory;

public class TriangleMesh3DFactories {
    private static final float TwoPi = (float)Math.PI * 2;
    private static final float HalfPi = 1.5707964f;
    private static final float SQRT3 = (float)Math.sqrt(3.0);
    private static final float SQRT6 = (float)Math.sqrt(6.0);
    private static final float HALF_SQRT3 = SQRT3 / 2.0f;
    private static final float THIRD_SQRT3 = SQRT3 / 3.0f;
    private static final float SIXTH_SQRT3 = SQRT3 / 6.0f;
    private static final float THIRD_SQRT6 = SQRT6 / 3.0f;
    private static final float FOURTH_SQRT6 = SQRT6 / 4.0f;
    private static final float ONE_THIRD = 0.33333334f;
    private static final float TETRAHEDRON_FACE_EDGE_FACE_ANGLE = (float)Math.acos(0.3333333432674408);
    private static final float TETRAHEDRON_SINE_FACE_EDGE_FACE_ANGLE = (float)Math.sin(TETRAHEDRON_FACE_EDGE_FACE_ANGLE);

    private TriangleMesh3DFactories() {
    }

    public static TriangleMesh3DDefinition TriangleMesh(GeometryDefinition description) {
        if (description == null) {
            return null;
        }
        TriangleMesh3DDefinition mesh = null;
        if (description instanceof TriangleMesh3DDefinition) {
            return (TriangleMesh3DDefinition)description;
        }
        if (description instanceof ArcTorus3DDefinition) {
            mesh = TriangleMesh3DFactories.ArcTorus((ArcTorus3DDefinition)description);
        } else if (description instanceof Box3DDefinition) {
            mesh = TriangleMesh3DFactories.Box((Box3DDefinition)description);
        } else if (description instanceof Capsule3DDefinition) {
            mesh = TriangleMesh3DFactories.Capsule((Capsule3DDefinition)description);
        } else if (description instanceof Cone3DDefinition) {
            mesh = TriangleMesh3DFactories.Cone((Cone3DDefinition)description);
        } else if (description instanceof ConvexPolytope3DDefinition) {
            mesh = TriangleMesh3DFactories.ConvexPolytope((ConvexPolytope3DDefinition)description);
        } else if (description instanceof Cylinder3DDefinition) {
            mesh = TriangleMesh3DFactories.Cylinder((Cylinder3DDefinition)description);
        } else if (description instanceof Ellipsoid3DDefinition) {
            mesh = TriangleMesh3DFactories.Ellipsoid((Ellipsoid3DDefinition)description);
        } else if (description instanceof ExtrudedPolygon2DDefinition) {
            mesh = TriangleMesh3DFactories.ExtrudedPolygon((ExtrudedPolygon2DDefinition)description);
        } else if (description instanceof HemiEllipsoid3DDefinition) {
            mesh = TriangleMesh3DFactories.HemiEllipsoid((HemiEllipsoid3DDefinition)description);
        } else if (description instanceof Polygon2DDefinition) {
            mesh = TriangleMesh3DFactories.Polygon((Polygon2DDefinition)description);
        } else if (description instanceof Polygon3DDefinition) {
            mesh = TriangleMesh3DFactories.Polygon((Polygon3DDefinition)description);
        } else if (description instanceof PyramidBox3DDefinition) {
            mesh = TriangleMesh3DFactories.PyramidBox((PyramidBox3DDefinition)description);
        } else if (description instanceof Sphere3DDefinition) {
            mesh = TriangleMesh3DFactories.Sphere((Sphere3DDefinition)description);
        } else if (description instanceof Tetrahedron3DDefinition) {
            mesh = TriangleMesh3DFactories.Tetrahedron((Tetrahedron3DDefinition)description);
        } else if (description instanceof Torus3DDefinition) {
            mesh = TriangleMesh3DFactories.Torus((Torus3DDefinition)description);
        } else if (description instanceof TruncatedCone3DDefinition) {
            mesh = TriangleMesh3DFactories.TruncatedCone((TruncatedCone3DDefinition)description);
        } else if (description instanceof Ramp3DDefinition) {
            mesh = TriangleMesh3DFactories.Ramp((Ramp3DDefinition)description);
        }
        if (mesh == null) {
            LogTools.error((String)("Unrecognized " + GeometryDefinition.class.getSimpleName() + ": " + description.getClass().getSimpleName()));
            return null;
        }
        if (description.getName() != null) {
            mesh.setName(description.getName());
        }
        return mesh;
    }

    public static TriangleMesh3DDefinition Sphere(Sphere3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Sphere(description.getRadius(), description.getResolution(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Sphere(double radius, int latitudeResolution, int longitudeResolution) {
        return TriangleMesh3DFactories.Sphere((float)radius, latitudeResolution, longitudeResolution);
    }

    public static TriangleMesh3DDefinition Sphere(float radius, int latitudeResolution, int longitudeResolution) {
        return TriangleMesh3DFactories.Ellipsoid(radius, radius, radius, latitudeResolution, longitudeResolution);
    }

    public static TriangleMesh3DDefinition Ellipsoid(Ellipsoid3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Ellipsoid(description.getRadiusX(), description.getRadiusY(), description.getRadiusZ(), description.getResolution(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Ellipsoid(double radiusX, double radiusY, double radiusZ, int latitudeResolution, int longitudeResolution) {
        return TriangleMesh3DFactories.Ellipsoid((float)radiusX, (float)radiusY, (float)radiusZ, latitudeResolution, longitudeResolution);
    }

    public static TriangleMesh3DDefinition Ellipsoid(float radiusX, float radiusY, float radiusZ, int latitudeResolution, int longitudeResolution) {
        int longitudeIndex;
        if (longitudeResolution % 2 == 1) {
            ++longitudeResolution;
        }
        int nPointsLongitude = longitudeResolution + 1;
        int nPointsLatitude = latitudeResolution + 1;
        Point3D32[] points = new Point3D32[nPointsLatitude * nPointsLongitude];
        Vector3D32[] normals = new Vector3D32[nPointsLatitude * nPointsLongitude];
        Point2D32[] textPoints = new Point2D32[nPointsLatitude * nPointsLongitude];
        for (int longitudeIndex2 = 0; longitudeIndex2 < nPointsLongitude; ++longitudeIndex2) {
            float longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)(nPointsLongitude - 1));
            float cosLongitude = (float)Math.cos(longitudeAngle);
            float sinLongitude = (float)Math.sin(longitudeAngle);
            float textureX = (float)longitudeIndex2 / (float)(nPointsLongitude - 1);
            for (int latitudeIndex = 1; latitudeIndex < nPointsLatitude - 1; ++latitudeIndex) {
                float latitudeAngle = (float)(-1.5707963705062866 + Math.PI * (double)((float)latitudeIndex / ((float)nPointsLatitude - 1.0f)));
                float cosLatitude = (float)Math.cos(latitudeAngle);
                float sinLatitude = (float)Math.sin(latitudeAngle);
                int currentIndex = latitudeIndex * nPointsLongitude + longitudeIndex2;
                float normalX = cosLongitude * cosLatitude;
                float normalY = sinLongitude * cosLatitude;
                float normalZ = sinLatitude;
                float vertexX = radiusX * normalX;
                float vertexY = radiusY * normalY;
                float vertexZ = radiusZ * normalZ;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                float textureY = 0.5f * (1.0f - sinLatitude);
                textPoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            int southPoleIndex = longitudeIndex2;
            points[southPoleIndex] = new Point3D32(0.0f, 0.0f, -radiusZ);
            normals[southPoleIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[southPoleIndex] = new Point2D32(textureX += 0.5f / ((float)nPointsLongitude - 1.0f), 0.99609375f);
            int northPoleIndex = (nPointsLatitude - 1) * nPointsLongitude + longitudeIndex2;
            points[northPoleIndex] = new Point3D32(0.0f, 0.0f, radiusZ);
            normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[northPoleIndex] = new Point2D32(textureX, 0.00390625f);
        }
        int numberOfTriangles = 2 * ((nPointsLatitude - 2) * nPointsLongitude - 1);
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int latitudeIndex = 1; latitudeIndex < nPointsLatitude - 2; ++latitudeIndex) {
            for (int longitudeIndex3 = 0; longitudeIndex3 < nPointsLongitude - 1; ++longitudeIndex3) {
                int nextLongitudeIndex = (longitudeIndex3 + 1) % nPointsLongitude;
                int nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + longitudeIndex3;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < nPointsLongitude - 1; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % nPointsLongitude;
            triangleIndices[index++] = longitudeIndex;
            triangleIndices[index++] = nPointsLongitude + nextLongitudeIndex;
            triangleIndices[index++] = nPointsLongitude + longitudeIndex;
        }
        for (longitudeIndex = 0; longitudeIndex < nPointsLongitude - 1; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % nPointsLongitude;
            triangleIndices[index++] = (nPointsLatitude - 1) * nPointsLongitude + longitudeIndex;
            triangleIndices[index++] = (nPointsLatitude - 2) * nPointsLongitude + longitudeIndex;
            triangleIndices[index++] = (nPointsLatitude - 2) * nPointsLongitude + nextLongitudeIndex;
        }
        return new TriangleMesh3DDefinition("Ellipsoid Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Polygon(Polygon2DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Polygon(null, description.getPolygonVertices(), description.isCounterClockwiseOrdered());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Polygon(ConvexPolygon2DReadOnly convexPolygon) {
        return TriangleMesh3DFactories.Polygon(null, convexPolygon);
    }

    public static TriangleMesh3DDefinition Polygon(RigidBodyTransformReadOnly polygonPose, ConvexPolygon2DReadOnly convexPolygon) {
        if (convexPolygon == null) {
            return null;
        }
        return TriangleMesh3DFactories.Polygon(polygonPose, convexPolygon.getPolygonVerticesView(), !convexPolygon.isClockwiseOrdered());
    }

    public static TriangleMesh3DDefinition PolygonClockwise(RigidBodyTransformReadOnly polygonPose, List<? extends Point2DReadOnly> cwOrderedPolygonVertices) {
        return TriangleMesh3DFactories.Polygon(polygonPose, cwOrderedPolygonVertices, false);
    }

    public static TriangleMesh3DDefinition PolygonCounterClockwise(RigidBodyTransformReadOnly polygonPose, List<? extends Point2DReadOnly> ccwOrderedPolygonVertices) {
        return TriangleMesh3DFactories.Polygon(polygonPose, ccwOrderedPolygonVertices, true);
    }

    public static TriangleMesh3DDefinition Polygon(RigidBodyTransformReadOnly polygonPose, List<? extends Point2DReadOnly> polygonVertices, boolean counterClockwiseOrdered) {
        Point2DReadOnly vertex2D;
        int i;
        if (polygonVertices == null) {
            return null;
        }
        int numberOfVertices = polygonVertices.size();
        if (numberOfVertices < 3) {
            return null;
        }
        Object[] vertices = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        Object[] texturePoints = new Point2D32[numberOfVertices];
        normals[0] = new Vector3D32((Tuple3DReadOnly)Axis3D.Z);
        if (polygonPose != null) {
            polygonPose.transform((Vector3DBasics)normals[0]);
        }
        for (int i2 = 1; i2 < numberOfVertices; ++i2) {
            normals[i2] = new Vector3D32((Tuple3DReadOnly)normals[0]);
        }
        float minX = polygonVertices.get(0).getX32();
        float minY = polygonVertices.get(0).getY32();
        float maxX = polygonVertices.get(0).getX32();
        float maxY = polygonVertices.get(0).getY32();
        for (i = 1; i < numberOfVertices; ++i) {
            vertex2D = counterClockwiseOrdered ? polygonVertices.get(i) : polygonVertices.get(numberOfVertices - 1 - i);
            if (vertex2D.getX32() > maxX) {
                maxX = vertex2D.getX32();
            } else if (vertex2D.getX32() < minX) {
                minX = vertex2D.getX32();
            }
            if (vertex2D.getY32() > maxY) {
                maxY = vertex2D.getY32();
                continue;
            }
            if (!(vertex2D.getY32() < minY)) continue;
            minY = vertex2D.getY32();
        }
        for (i = 0; i < numberOfVertices; ++i) {
            vertex2D = polygonVertices.get(i);
            Point3D32 vertex3D = new Point3D32();
            vertex3D.set((Tuple2DReadOnly)vertex2D);
            if (polygonPose != null) {
                polygonPose.transform((Point3DBasics)vertex3D);
            }
            vertices[i] = vertex3D;
            float textureX = 1.0f - (vertex2D.getY32() - minY) / (maxY - minY);
            float textureY = 1.0f - (vertex2D.getX32() - minX) / (maxX - minX);
            texturePoints[i] = new Point2D32(textureX, textureY);
        }
        if (!counterClockwiseOrdered) {
            TriangleMesh3DFactories.reverse(vertices);
            TriangleMesh3DFactories.reverse(texturePoints);
        }
        int numberOfTriangles = numberOfVertices - 2;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        int j = 2;
        while (j < vertices.length) {
            triangleIndices[index++] = 0;
            triangleIndices[index++] = j - 1;
            triangleIndices[index++] = j++;
        }
        return new TriangleMesh3DDefinition("Polygon Factory", (Point3D32[])vertices, (Point2D32[])texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Polygon(Polygon3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Polygon(description.getPolygonVertices(), description.isCounterClockwiseOrdered());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition PolygonClockwise(List<? extends Point3DReadOnly> cwOrderedPolygonVertices) {
        return TriangleMesh3DFactories.Polygon(cwOrderedPolygonVertices, false);
    }

    public static TriangleMesh3DDefinition PolygonCounterClockwise(List<? extends Point3DReadOnly> ccwOrderedPolygonVertices) {
        return TriangleMesh3DFactories.Polygon(ccwOrderedPolygonVertices, true);
    }

    public static TriangleMesh3DDefinition Polygon(List<? extends Point3DReadOnly> convexPolygonVertices, boolean counterClockwiseOrdered) {
        int i;
        if (convexPolygonVertices == null) {
            return null;
        }
        int numberOfVertices = convexPolygonVertices.size();
        if (numberOfVertices < 3) {
            return null;
        }
        int numberOfTriangles = numberOfVertices - 2;
        Vector3D32[] triangleNormals = new Vector3D32[numberOfTriangles];
        for (int i2 = 0; i2 < numberOfTriangles; ++i2) {
            Vector3D32 triangleNormal = new Vector3D32();
            EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)convexPolygonVertices.get(0), (Point3DReadOnly)convexPolygonVertices.get(i2 + 1), (Point3DReadOnly)convexPolygonVertices.get(i2 + 2), (Vector3DBasics)triangleNormal);
            triangleNormals[i2] = triangleNormal;
        }
        boolean areAllNormalsEqual = true;
        Vector3D32 polygonNormal = new Vector3D32();
        for (int i3 = 1; i3 < numberOfTriangles; ++i3) {
            if (areAllNormalsEqual && !triangleNormals[i3 - 1].epsilonEquals((EuclidGeometry)triangleNormals[i3], 1.0E-7)) {
                areAllNormalsEqual = false;
            }
            polygonNormal.add((Tuple3DReadOnly)triangleNormals[i3]);
        }
        polygonNormal.normalize();
        RotationMatrix polygonOrientation = new RotationMatrix();
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)polygonNormal, (Orientation3DBasics)polygonOrientation);
        Point2D32[] texturePoints = new Point2D32[numberOfVertices];
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        Point3D32 point = new Point3D32();
        for (i = 0; i < numberOfVertices; ++i) {
            polygonOrientation.inverseTransform((Tuple3DReadOnly)convexPolygonVertices.get(i), (Tuple3DBasics)point);
            Point2D32 texturePoint = new Point2D32();
            texturePoint.set(-point.getY(), -point.getX());
            texturePoints[i] = texturePoint;
            minX = Math.min(minX, texturePoint.getX32());
            minY = Math.min(minY, texturePoint.getY32());
            maxX = Math.max(maxX, texturePoint.getX32());
            maxY = Math.max(maxY, texturePoint.getY32());
        }
        for (i = 0; i < numberOfVertices; ++i) {
            texturePoints[i].sub((double)minX, (double)minY);
            texturePoints[i].scale(1.0 / (double)(maxX - minX), 1.0 / (double)(maxY - minY));
        }
        Point3D32[] vertices = (Point3D32[])convexPolygonVertices.stream().map(Point3D32::new).toArray(Point3D32[]::new);
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        int[] triangleIndices = new int[3 * numberOfTriangles];
        if (areAllNormalsEqual) {
            for (int i4 = 0; i4 < numberOfVertices; ++i4) {
                normals[i4] = i4 < numberOfTriangles ? triangleNormals[i4] : new Vector3D32((Tuple3DReadOnly)triangleNormals[0]);
            }
        } else {
            normals[0] = polygonNormal;
            normals[1] = triangleNormals[0];
            for (int i5 = 1; i5 < numberOfVertices - 2; ++i5) {
                Vector3D32 normal = new Vector3D32();
                normal.interpolate((Tuple3DReadOnly)triangleNormals[i5 - 1], (Tuple3DReadOnly)triangleNormals[i5], 0.5);
                normal.normalize();
                normals[i5] = normal;
            }
            Vector3D32 normal = new Vector3D32();
            normal.interpolate((Tuple3DReadOnly)triangleNormals[numberOfTriangles - 2], (Tuple3DReadOnly)triangleNormals[numberOfTriangles - 1], 0.5);
            normal.normalize();
            normals[numberOfVertices - 2] = triangleNormals[numberOfTriangles - 1];
            normals[numberOfVertices - 1] = triangleNormals[numberOfTriangles - 1];
        }
        int index = 0;
        int j = 2;
        while (j < numberOfVertices) {
            triangleIndices[index++] = 0;
            triangleIndices[index++] = j - 1;
            triangleIndices[index++] = j++;
        }
        return new TriangleMesh3DDefinition("Polygon Factory", vertices, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition ExtrudedPolygon(ExtrudedPolygon2DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.ExtrudedPolygon(description.getPolygonVertices(), description.isCounterClockwiseOrdered(), description.getTopZ(), description.getBottomZ());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition ExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon, double extrusionHeight) {
        if (convexPolygon == null) {
            return null;
        }
        return TriangleMesh3DFactories.ExtrudedPolygon(convexPolygon.getPolygonVerticesView(), false, extrusionHeight, 0.0);
    }

    public static TriangleMesh3DDefinition ExtrudedPolygon(List<? extends Point2DReadOnly> ccwOrderedPolygonVertices, double extrusionHeight) {
        return TriangleMesh3DFactories.ExtrudedPolygonCounterClockwise(ccwOrderedPolygonVertices, extrusionHeight, 0.0);
    }

    public static TriangleMesh3DDefinition ExtrudedPolygonCounterClockwise(List<? extends Point2DReadOnly> ccwOrderedPolygonVertices, double topZ, double bottomZ) {
        return TriangleMesh3DFactories.ExtrudedPolygon(ccwOrderedPolygonVertices, true, topZ, bottomZ);
    }

    public static TriangleMesh3DDefinition ExtrudedPolygon(List<? extends Point2DReadOnly> polygonVertices, boolean counterClockwiseOrdered, double topZ, double bottomZ) {
        int i;
        Point2DReadOnly vertex;
        int i2;
        if (polygonVertices == null || polygonVertices.size() < 3) {
            return null;
        }
        int numberOfVertices = polygonVertices.size();
        Point3D32[] vertices = new Point3D32[6 * numberOfVertices + 4];
        Vector3D32[] normals = new Vector3D32[6 * numberOfVertices + 4];
        Point2D32[] texturePoints = new Point2D32[6 * numberOfVertices + 4];
        float minX = polygonVertices.get(0).getX32();
        float minY = polygonVertices.get(0).getY32();
        float maxX = polygonVertices.get(0).getX32();
        float maxY = polygonVertices.get(0).getY32();
        for (i2 = 1; i2 < numberOfVertices; ++i2) {
            vertex = polygonVertices.get(i2);
            if (vertex.getX32() > maxX) {
                maxX = vertex.getX32();
            } else if (vertex.getX32() < minX) {
                minX = vertex.getX32();
            }
            if (vertex.getY32() > maxY) {
                maxY = vertex.getY32();
                continue;
            }
            if (!(vertex.getY32() < minY)) continue;
            minY = vertex.getY32();
        }
        for (i2 = 0; i2 < numberOfVertices; ++i2) {
            vertex = counterClockwiseOrdered ? polygonVertices.get(i2) : polygonVertices.get(numberOfVertices - 1 - i2);
            float vertexX = vertex.getX32();
            float vertexY = vertex.getY32();
            vertices[i2] = new Point3D32(vertexX, vertexY, (float)bottomZ);
            normals[i2] = new Vector3D32(0.0f, 0.0f, -1.0f);
            texturePoints[i2] = new Point2D32(0.5f - 0.5f * (vertexY - minY) / (maxY - minY) + 0.5f, 0.5f - 0.5f * (vertexX - minX) / (maxX - minX));
            vertices[i2 + numberOfVertices] = new Point3D32(vertexX, vertexY, (float)topZ);
            normals[i2 + numberOfVertices] = new Vector3D32(0.0f, 0.0f, 1.0f);
            texturePoints[i2 + numberOfVertices] = new Point2D32(0.5f - 0.5f * (vertexY - minY) / (maxY - minY), 0.5f - 0.5f * (vertexX - minX) / (maxX - minX));
        }
        double perimeter = 0.0;
        for (int i3 = 0; i3 < polygonVertices.size(); ++i3) {
            Point2DReadOnly vertex2 = polygonVertices.get(i3);
            Point2DReadOnly nextVertex = polygonVertices.get((i3 + 1) % numberOfVertices);
            perimeter += vertex2.distance(nextVertex);
        }
        double distanceAlongPerimeter = 0.0;
        double nextDistanceAlongPerimeter = 0.0;
        int nextIndex = counterClockwiseOrdered ? 0 : numberOfVertices - 1;
        Point2DReadOnly nextVertex = polygonVertices.get(nextIndex);
        for (int i4 = 0; i4 < numberOfVertices + 1; ++i4) {
            Point2DReadOnly vertex3 = nextVertex;
            if (counterClockwiseOrdered) {
                ++nextIndex;
                nextIndex %= numberOfVertices;
            } else if (--nextIndex < 0) {
                nextIndex = numberOfVertices - 1;
            }
            nextVertex = polygonVertices.get(nextIndex);
            nextDistanceAlongPerimeter += nextVertex.distance(vertex3);
            float vertexX = vertex3.getX32();
            float vertexY = vertex3.getY32();
            Point3D32 vertexBottom = new Point3D32(vertexX, vertexY, (float)bottomZ);
            Point3D32 vertexTop = new Point3D32(vertexX, vertexY, (float)topZ);
            Point3D32 nextVertexBottom = new Point3D32(nextVertex.getX32(), nextVertex.getY32(), (float)bottomZ);
            Point3D32 nextVertexTop = new Point3D32(nextVertex.getX32(), nextVertex.getY32(), (float)topZ);
            Vector3D normal = new Vector3D();
            normal.sub((Tuple3DReadOnly)nextVertexTop, (Tuple3DReadOnly)vertexTop);
            normal.cross((Tuple3DReadOnly)Axis3D.Z, (Tuple3DReadOnly)normal);
            normal.negate();
            normal.normalize();
            int vertexBottomIndex = 2 * i4 + 2 * numberOfVertices;
            int nextVertexBottomIndex = vertexBottomIndex + 1;
            int vertexTopIndex = vertexBottomIndex + 2 * (numberOfVertices + 1);
            int nextVertexTopIndex = vertexTopIndex + 1;
            vertices[vertexBottomIndex] = vertexBottom;
            normals[vertexBottomIndex] = new Vector3D32((Tuple3DReadOnly)normal);
            texturePoints[vertexBottomIndex] = new Point2D32((float)(distanceAlongPerimeter / perimeter), 1.0f);
            vertices[nextVertexBottomIndex] = nextVertexBottom;
            normals[nextVertexBottomIndex] = new Vector3D32((Tuple3DReadOnly)normal);
            texturePoints[nextVertexBottomIndex] = new Point2D32((float)(nextDistanceAlongPerimeter / perimeter), 1.0f);
            vertices[vertexTopIndex] = vertexTop;
            normals[vertexTopIndex] = new Vector3D32((Tuple3DReadOnly)normal);
            texturePoints[vertexTopIndex] = new Point2D32((float)(distanceAlongPerimeter / perimeter), 0.5f);
            vertices[nextVertexTopIndex] = nextVertexTop;
            normals[nextVertexTopIndex] = new Vector3D32((Tuple3DReadOnly)normal);
            texturePoints[nextVertexTopIndex] = new Point2D32((float)(nextDistanceAlongPerimeter / perimeter), 0.5f);
            distanceAlongPerimeter = nextDistanceAlongPerimeter;
        }
        int numberOfTriangles = 4 * numberOfVertices;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (i = 1; i < numberOfVertices; ++i) {
            triangleIndices[index++] = (i + 1) % numberOfVertices;
            triangleIndices[index++] = i;
            triangleIndices[index++] = 0;
            triangleIndices[index++] = numberOfVertices;
            triangleIndices[index++] = i + numberOfVertices;
            triangleIndices[index++] = (i + 1) % numberOfVertices + numberOfVertices;
        }
        for (i = 0; i < numberOfVertices + 1; ++i) {
            triangleIndices[index++] = 2 * i + 2 * numberOfVertices;
            triangleIndices[index++] = (2 * i + 1) % (2 * numberOfVertices + 2) + 2 * numberOfVertices;
            triangleIndices[index++] = 2 * i + 4 * numberOfVertices + 2;
            triangleIndices[index++] = (2 * i + 1) % (2 * numberOfVertices + 2) + 2 * numberOfVertices;
            triangleIndices[index++] = (2 * i + 1) % (2 * numberOfVertices + 2) + 4 * numberOfVertices + 2;
            triangleIndices[index++] = 2 * i + 4 * numberOfVertices + 2;
        }
        return new TriangleMesh3DDefinition("ExtrudedPolygon Factory", vertices, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition HemiEllipsoid(HemiEllipsoid3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.HemiEllipsoid(description.getRadiusX(), description.getRadiusY(), description.getRadiusZ(), description.getResolution(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition HemiEllipsoid(double radiusX, double radiusY, double radiusZ, int latitudeResolution, int longitudeResolution) {
        return TriangleMesh3DFactories.HemiEllipsoid((float)radiusX, (float)radiusY, (float)radiusZ, latitudeResolution, longitudeResolution);
    }

    public static TriangleMesh3DDefinition HemiEllipsoid(float radiusX, float radiusY, float radiusZ, int latitudeResolution, int longitudeResolution) {
        int longitudeIndex;
        if (longitudeResolution % 2 == 1) {
            ++longitudeResolution;
        }
        int nPointsLongitude = longitudeResolution + 1;
        int nPointsLatitude = latitudeResolution + 1;
        Point3D32[] points = new Point3D32[(nPointsLatitude + 1) * nPointsLongitude];
        Vector3D32[] normals = new Vector3D32[(nPointsLatitude + 1) * nPointsLongitude];
        Point2D32[] textPoints = new Point2D32[(nPointsLatitude + 1) * nPointsLongitude];
        for (int longitudeIndex2 = 0; longitudeIndex2 < nPointsLongitude; ++longitudeIndex2) {
            float longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)(nPointsLongitude - 1));
            float cosLongitude = (float)Math.cos(longitudeAngle);
            float sinLongitude = (float)Math.sin(longitudeAngle);
            float textureX = (float)longitudeIndex2 / (float)(nPointsLongitude - 1);
            for (int latitudeIndex = 1; latitudeIndex < nPointsLatitude - 1; ++latitudeIndex) {
                float latitudeAngle = 1.5707964f * ((float)(latitudeIndex - 1) / (float)(nPointsLatitude - 2));
                float cosLatitude = (float)Math.cos(latitudeAngle);
                float sinLatitude = (float)Math.sin(latitudeAngle);
                int currentIndex = (latitudeIndex + 1) * nPointsLongitude + longitudeIndex2;
                float normalX = cosLongitude * cosLatitude;
                float normalY = sinLongitude * cosLatitude;
                float normalZ = sinLatitude;
                float vertexX = radiusX * normalX;
                float vertexY = radiusY * normalY;
                float vertexZ = radiusZ * normalZ;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                float textureY = 0.5f * (1.0f - sinLatitude);
                textPoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            int currentIndex = nPointsLongitude + longitudeIndex2;
            float vertexX = (float)((double)radiusX * Math.cos(longitudeAngle));
            float vertexY = (float)((double)radiusY * Math.sin(longitudeAngle));
            float vertexZ = 0.0f;
            points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
            normals[currentIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[currentIndex] = new Point2D32(textureX, 0.5f);
            int southPoleIndex = longitudeIndex2;
            points[southPoleIndex] = new Point3D32(0.0f, 0.0f, 0.0f);
            normals[southPoleIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[southPoleIndex] = new Point2D32(textureX += 0.5f / (float)(nPointsLongitude - 1), 0.99609375f);
            int northPoleIndex = nPointsLatitude * nPointsLongitude + longitudeIndex2;
            points[northPoleIndex] = new Point3D32(0.0f, 0.0f, radiusZ);
            normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[northPoleIndex] = new Point2D32(textureX, 0.00390625f);
        }
        int numberOfTriangles = 2 * (nPointsLatitude - 1) * (nPointsLongitude - 1);
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int latitudeIndex = 1; latitudeIndex < nPointsLatitude - 1; ++latitudeIndex) {
            for (int longitudeIndex3 = 0; longitudeIndex3 < nPointsLongitude - 1; ++longitudeIndex3) {
                int nextLongitudeIndex = (longitudeIndex3 + 1) % nPointsLongitude;
                int nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * nPointsLongitude + longitudeIndex3;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < nPointsLongitude - 1; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % nPointsLongitude;
            triangleIndices[index++] = longitudeIndex;
            triangleIndices[index++] = nPointsLongitude + nextLongitudeIndex;
            triangleIndices[index++] = nPointsLongitude + longitudeIndex;
        }
        for (longitudeIndex = 0; longitudeIndex < nPointsLongitude - 1; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % nPointsLongitude;
            triangleIndices[index++] = (nPointsLatitude - 0) * nPointsLongitude + longitudeIndex;
            triangleIndices[index++] = (nPointsLatitude - 1) * nPointsLongitude + longitudeIndex;
            triangleIndices[index++] = (nPointsLatitude - 1) * nPointsLongitude + nextLongitudeIndex;
        }
        return new TriangleMesh3DDefinition("HemiEllipsoid Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Cylinder(Cylinder3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Cylinder(description.getRadius(), description.getLength(), description.getResolution(), description.isCentered());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Cylinder(double radius, double height, int resolution, boolean centered) {
        return TriangleMesh3DFactories.Cylinder((float)radius, (float)height, resolution, centered);
    }

    public static TriangleMesh3DDefinition Cylinder(float radius, float height, int resolution, boolean centered) {
        Point3D32[] points = new Point3D32[4 * resolution + 2];
        Vector3D32[] normals = new Vector3D32[4 * resolution + 2];
        Point2D32[] texturePoints = new Point2D32[4 * resolution + 2];
        float zTop = centered ? 0.5f * height : height;
        float zBottom = centered ? -0.5f * height : 0.0f;
        for (int i = 0; i < resolution; ++i) {
            double angle = (double)((float)i * ((float)Math.PI * 2)) / ((double)resolution - 1.0);
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float vertexX = radius * cosAngle;
            float vertexY = radius * sinAngle;
            points[i] = new Point3D32(vertexX, vertexY, zBottom);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            texturePoints[i] = new Point2D32(0.25f * (1.0f + sinAngle) + 0.5f, 0.25f * (1.0f - cosAngle));
            points[i + resolution] = new Point3D32(vertexX, vertexY, zTop);
            normals[i + resolution] = new Vector3D32(0.0f, 0.0f, 1.0f);
            texturePoints[i + resolution] = new Point2D32(0.25f * (1.0f - sinAngle), 0.25f * (1.0f - cosAngle));
            points[i + 2 * resolution] = new Point3D32(vertexX, vertexY, zBottom);
            normals[i + 2 * resolution] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            texturePoints[i + 2 * resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 1.0f);
            points[i + 3 * resolution] = new Point3D32(vertexX, vertexY, zTop);
            normals[i + 3 * resolution] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            texturePoints[i + 3 * resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 0.5f);
        }
        points[4 * resolution] = new Point3D32(0.0f, 0.0f, zBottom);
        normals[4 * resolution] = new Vector3D32(0.0f, 0.0f, -1.0f);
        texturePoints[4 * resolution] = new Point2D32(0.75f, 0.25f);
        points[4 * resolution + 1] = new Point3D32(0.0f, 0.0f, zTop);
        normals[4 * resolution + 1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        texturePoints[4 * resolution + 1] = new Point2D32(0.25f, 0.25f);
        int numberOfTriangles = 4 * resolution;
        int[] triangleIndices = new int[6 * numberOfTriangles];
        int index = 0;
        int i = 0;
        while (i < resolution) {
            triangleIndices[index++] = (i + 1) % resolution;
            triangleIndices[index++] = i++;
            triangleIndices[index++] = 4 * resolution;
        }
        for (i = 0; i < resolution; ++i) {
            triangleIndices[index++] = 4 * resolution + 1;
            triangleIndices[index++] = i + resolution;
            triangleIndices[index++] = (i + 1) % resolution + resolution;
        }
        for (i = 0; i < resolution; ++i) {
            triangleIndices[index++] = i + 2 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 2 * resolution;
            triangleIndices[index++] = i + 3 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 2 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 3 * resolution;
            triangleIndices[index++] = i + 3 * resolution;
        }
        return new TriangleMesh3DDefinition("Cylinder Factory", points, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Cone(Cone3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Cone(description.getHeight(), description.getRadius(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Cone(double height, double radius, int resolution) {
        return TriangleMesh3DFactories.Cone((float)height, (float)radius, resolution);
    }

    public static TriangleMesh3DDefinition Cone(float height, float radius, int resolution) {
        Point3D32[] vertices = new Point3D32[3 * resolution + 1];
        Vector3D32[] normals = new Vector3D32[3 * resolution + 1];
        Point2D32[] texturePoints = new Point2D32[3 * resolution + 1];
        float slopeAngle = (float)Math.atan2(radius, height);
        float cosSlopeAngle = (float)Math.cos(slopeAngle);
        float sinSlopeAngle = (float)Math.sin(slopeAngle);
        for (int i = 0; i < resolution; ++i) {
            double angle = (float)i * ((float)Math.PI * 2) / (float)(resolution - 1);
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float vertexX = radius * cosAngle;
            float vertexY = radius * sinAngle;
            vertices[i] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            texturePoints[i] = new Point2D32(0.25f * (1.0f + sinAngle), 0.25f * (1.0f - cosAngle));
            vertices[i + resolution] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i + resolution] = new Vector3D32(cosSlopeAngle * cosAngle, cosSlopeAngle * sinAngle, sinSlopeAngle);
            texturePoints[i + resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 1.0f);
            vertices[i + 2 * resolution] = new Point3D32(0.0f, 0.0f, height);
            normals[i + 2 * resolution] = new Vector3D32(cosSlopeAngle * cosAngle, cosSlopeAngle * sinAngle, sinSlopeAngle);
            texturePoints[i + 2 * resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 0.5f);
        }
        int bottomCenterIndex = 3 * resolution;
        vertices[bottomCenterIndex] = new Point3D32(0.0f, 0.0f, 0.0f);
        normals[bottomCenterIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
        texturePoints[bottomCenterIndex] = new Point2D32(0.25f, 0.25f);
        int numberOfTriangles = 2 * resolution;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int i = 0; i < resolution; ++i) {
            triangleIndices[index++] = bottomCenterIndex;
            triangleIndices[index++] = (i + 1) % resolution;
            triangleIndices[index++] = i;
            triangleIndices[index++] = i + resolution;
            triangleIndices[index++] = (i + 1) % resolution + resolution;
            triangleIndices[index++] = i + 2 * resolution;
        }
        return new TriangleMesh3DDefinition("Cone Factory", vertices, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition TruncatedCone(TruncatedCone3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.TruncatedCone(description.getHeight(), description.getBaseRadiusX(), description.getBaseRadiusY(), description.getTopRadiusX(), description.getTopRadiusY(), description.getResolution(), description.getCentered());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition TruncatedCone(double height, double baseRadiusX, double baseRadiusY, double topRadiusX, double topRadiusY, int resolution, boolean centered) {
        return TriangleMesh3DFactories.TruncatedCone((float)height, (float)baseRadiusX, (float)baseRadiusY, (float)topRadiusX, (float)topRadiusY, resolution, centered);
    }

    public static TriangleMesh3DDefinition TruncatedCone(float height, float baseRadiusX, float baseRadiusY, float topRadiusX, float topRadiusY, int resolution, boolean centered) {
        Point3D32[] points = new Point3D32[4 * resolution + 2];
        Vector3D32[] normals = new Vector3D32[4 * resolution + 2];
        Point2D32[] textPoints = new Point2D32[4 * resolution + 2];
        float topZ = centered ? 0.5f * height : height;
        float bottomZ = centered ? -0.5f * height : 0.0f;
        for (int i = 0; i < resolution; ++i) {
            double angle = (float)i * ((float)Math.PI * 2) / (float)(resolution - 1);
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float baseX = baseRadiusX * cosAngle;
            float baseY = baseRadiusY * sinAngle;
            float topX = topRadiusX * cosAngle;
            float topY = topRadiusY * sinAngle;
            points[i] = new Point3D32(baseX, baseY, bottomZ);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[i] = new Point2D32(0.25f * (1.0f + sinAngle) + 0.5f, 0.25f * (1.0f - cosAngle));
            points[i + resolution] = new Point3D32(topX, topY, topZ);
            normals[i + resolution] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[i + resolution] = new Point2D32(0.25f * (1.0f - sinAngle), 0.25f * (1.0f - cosAngle));
            float currentBaseRadius = (float)Math.sqrt(baseX * baseX + baseY * baseY);
            float currentTopRadius = (float)Math.sqrt(topX * topX + topY * topY);
            float openingAngle = (float)Math.atan((currentBaseRadius - currentTopRadius) / height);
            float baseAngle = (float)Math.atan2(baseY, baseX);
            float topAngle = (float)Math.atan2(topY, topX);
            points[i + 2 * resolution] = new Point3D32(baseX, baseY, bottomZ);
            normals[i + 2 * resolution] = new Vector3D32((float)(Math.cos(baseAngle) * Math.cos(openingAngle)), (float)(Math.sin(baseAngle) * Math.cos(openingAngle)), (float)Math.sin(openingAngle));
            textPoints[i + 2 * resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 1.0f);
            points[i + 3 * resolution] = new Point3D32(topX, topY, topZ);
            normals[i + 3 * resolution] = new Vector3D32((float)(Math.cos(topAngle) * Math.cos(openingAngle)), (float)(Math.sin(topAngle) * Math.cos(openingAngle)), (float)Math.sin(openingAngle));
            textPoints[i + 3 * resolution] = new Point2D32((float)i / ((float)resolution - 1.0f), 0.5f);
        }
        points[4 * resolution] = new Point3D32(0.0f, 0.0f, bottomZ);
        normals[4 * resolution] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[4 * resolution] = new Point2D32(0.75f, 0.25f);
        points[4 * resolution + 1] = new Point3D32(0.0f, 0.0f, topZ);
        normals[4 * resolution + 1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[4 * resolution + 1] = new Point2D32(0.25f, 0.25f);
        int numberOfTriangles = 4 * resolution;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int i = 0; i < resolution; ++i) {
            triangleIndices[index++] = 4 * resolution;
            triangleIndices[index++] = (i + 1) % resolution;
            triangleIndices[index++] = i;
            triangleIndices[index++] = 4 * resolution + 1;
            triangleIndices[index++] = i + resolution;
            triangleIndices[index++] = (i + 1) % resolution + resolution;
            triangleIndices[index++] = i + 2 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 2 * resolution;
            triangleIndices[index++] = i + 3 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 2 * resolution;
            triangleIndices[index++] = (i + 1) % resolution + 3 * resolution;
            triangleIndices[index++] = i + 3 * resolution;
        }
        return new TriangleMesh3DDefinition("TruncatedCone Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Torus(Torus3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Torus(description.getMajorRadius(), description.getMinorRadius(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Torus(double majorRadius, double minorRadius, int resolution) {
        return TriangleMesh3DFactories.Torus((float)majorRadius, (float)minorRadius, resolution);
    }

    public static TriangleMesh3DDefinition Torus(float majorRadius, float minorRadius, int resolution) {
        return TriangleMesh3DFactories.ArcTorus(0.0f, (float)Math.PI * 2, majorRadius, minorRadius, resolution);
    }

    public static TriangleMesh3DDefinition ArcTorus(ArcTorus3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.ArcTorus(description.getStartAngle(), description.getEndAngle(), description.getMajorRadius(), description.getMinorRadius(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition ArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, int resolution) {
        return TriangleMesh3DFactories.ArcTorus((float)startAngle, (float)endAngle, (float)majorRadius, (float)minorRadius, resolution);
    }

    public static TriangleMesh3DDefinition ArcTorus(float startAngle, float endAngle, float majorRadius, float minorRadius, int resolution) {
        float textureX;
        float pZ;
        float pY;
        float pX;
        float textureY;
        float centerY;
        float centerX;
        startAngle = (float)EuclidCoreTools.shiftAngleInRange((double)startAngle, (double)0.0);
        if (EuclidCoreTools.epsilonEquals((double)(endAngle = (float)EuclidCoreTools.shiftAngleInRange((double)endAngle, (double)0.0)), (double)0.0, (double)1.0E-6)) {
            endAngle = (float)Math.PI * 2;
        }
        float torusSpanAngle = endAngle - startAngle;
        boolean isClosed = MathTools.epsilonEquals((double)torusSpanAngle, (double)6.2831854820251465, (double)0.001);
        int majorN = resolution;
        int minorN = resolution;
        float stepAngle = (endAngle - startAngle) / (float)(majorN - 1);
        int numberOfVertices = isClosed ? majorN * minorN : majorN * minorN + 2 * (resolution + 1);
        Point3D32[] points = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        Point2D32[] texturePoints = new Point2D32[numberOfVertices];
        for (int majorIndex = 0; majorIndex < majorN; ++majorIndex) {
            float majorAngle = startAngle + (float)majorIndex * stepAngle;
            float cosMajorAngle = (float)Math.cos(majorAngle);
            float sinMajorAngle = (float)Math.sin(majorAngle);
            centerX = majorRadius * cosMajorAngle;
            centerY = majorRadius * sinMajorAngle;
            textureY = (float)majorIndex / (float)(majorN - 1);
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = majorIndex * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / ((float)minorN - 1.0f);
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosMajorAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinMajorAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(cosMajorAngle * cosMinorAngle, sinMajorAngle * cosMinorAngle, sinMinorAngle);
                textureX = (float)minorIndex / (float)(minorN - 1);
                if (!isClosed) {
                    textureX *= 0.5f;
                }
                texturePoints[currentIndex] = new Point2D32(textureX, textureY);
            }
        }
        int lastMajorIndex = isClosed ? majorN : majorN - 1;
        int numberOfTriangles = 2 * lastMajorIndex * minorN;
        if (!isClosed) {
            numberOfTriangles += 2 * minorN;
        }
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int majorIndex = 0; majorIndex < lastMajorIndex; ++majorIndex) {
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int nextMajorIndex = (majorIndex + 1) % majorN;
                int nextMinorIndex = (minorIndex + 1) % minorN;
                triangleIndices[index++] = nextMajorIndex * minorN + minorIndex;
                triangleIndices[index++] = nextMajorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = majorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = nextMajorIndex * minorN + minorIndex;
                triangleIndices[index++] = majorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = majorIndex * minorN + minorIndex;
            }
        }
        if (!isClosed) {
            float cosStartAngle = (float)Math.cos(startAngle);
            float sinStartAngle = (float)Math.sin(startAngle);
            centerX = majorRadius * cosStartAngle;
            centerY = majorRadius * sinStartAngle;
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = majorN * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / (float)minorN;
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosStartAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinStartAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(sinStartAngle, -cosStartAngle, 0.0f);
                textureX = 0.75f + 0.25f * cosMinorAngle;
                textureY = 0.25f - 0.25f * sinMinorAngle;
                texturePoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            int firstEndCenterIndex = numberOfVertices - 2;
            points[firstEndCenterIndex] = new Point3D32(centerX, centerY, 0.0f);
            normals[firstEndCenterIndex] = new Vector3D32(sinStartAngle, -cosStartAngle, 0.0f);
            texturePoints[firstEndCenterIndex] = new Point2D32(0.75f, 0.25f);
            float cosEndAngle = (float)Math.cos(endAngle);
            float sinEndAngle = (float)Math.sin(endAngle);
            centerX = majorRadius * cosEndAngle;
            centerY = majorRadius * sinEndAngle;
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = (majorN + 1) * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / (float)minorN;
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosEndAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinEndAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(-sinEndAngle, cosEndAngle, 0.0f);
                textureX = 0.75f - 0.25f * cosMinorAngle;
                textureY = 0.75f - 0.25f * sinMinorAngle;
                texturePoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            int secondEndCenterIndex = numberOfVertices - 1;
            points[secondEndCenterIndex] = new Point3D32(centerX, centerY, 0.0f);
            normals[secondEndCenterIndex] = new Vector3D32(-sinEndAngle, cosEndAngle, 0.0f);
            texturePoints[secondEndCenterIndex] = new Point2D32(0.75f, 0.75f);
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int nextMinorIndex = (minorIndex + 1) % minorN;
                triangleIndices[index++] = firstEndCenterIndex;
                triangleIndices[index++] = majorN * minorN + minorIndex;
                triangleIndices[index++] = majorN * minorN + nextMinorIndex;
                triangleIndices[index++] = secondEndCenterIndex;
                triangleIndices[index++] = (majorN + 1) * minorN + nextMinorIndex;
                triangleIndices[index++] = (majorN + 1) * minorN + minorIndex;
            }
        }
        return new TriangleMesh3DDefinition("ArcTorus Factory", points, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Box(Box3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Box(description.getSizeX(), description.getSizeY(), description.getSizeZ(), description.isCentered());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Box(double sizeX, double sizeY, double sizeZ, boolean centered) {
        return TriangleMesh3DFactories.Box((float)sizeX, (float)sizeY, (float)sizeZ, centered);
    }

    public static TriangleMesh3DDefinition Box(float sizeX, float sizeY, float sizeZ, boolean centered) {
        Point3D32[] points = new Point3D32[24];
        Vector3D32[] normals = new Vector3D32[24];
        Point2D32[] textPoints = new Point2D32[24];
        float zBottom = centered ? -sizeZ / 2.0f : 0.0f;
        float zTop = centered ? sizeZ / 2.0f : sizeZ;
        points[0] = new Point3D32(-sizeX / 2.0f, -sizeY / 2.0f, zBottom);
        normals[0] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[0] = new Point2D32(0.5f, 0.5f);
        points[1] = new Point3D32(sizeX / 2.0f, -sizeY / 2.0f, zBottom);
        normals[1] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[1] = new Point2D32(0.25f, 0.5f);
        points[2] = new Point3D32(sizeX / 2.0f, sizeY / 2.0f, zBottom);
        normals[2] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[2] = new Point2D32(0.25f, 0.25f);
        points[3] = new Point3D32(-sizeX / 2.0f, sizeY / 2.0f, zBottom);
        normals[3] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[3] = new Point2D32(0.5f, 0.25f);
        points[4] = new Point3D32(-sizeX / 2.0f, -sizeY / 2.0f, zTop);
        normals[4] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[4] = new Point2D32(0.75f, 0.5f);
        points[5] = new Point3D32(sizeX / 2.0f, -sizeY / 2.0f, zTop);
        normals[5] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[5] = new Point2D32(1.0f, 0.5f);
        points[6] = new Point3D32(sizeX / 2.0f, sizeY / 2.0f, zTop);
        normals[6] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[6] = new Point2D32(1.0f, 0.25f);
        points[7] = new Point3D32(-sizeX / 2.0f, sizeY / 2.0f, zTop);
        normals[7] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[7] = new Point2D32(0.75f, 0.25f);
        points[8] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[8] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[8] = new Point2D32(0.25f, 0.25f);
        points[9] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[9] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[9] = new Point2D32(0.5f, 0.25f);
        points[10] = new Point3D32((Tuple3DReadOnly)points[6]);
        normals[10] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[10] = new Point2D32(0.25f, 0.0f);
        points[11] = new Point3D32((Tuple3DReadOnly)points[7]);
        normals[11] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[11] = new Point2D32(0.5f, 0.0f);
        points[12] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new Point2D32(0.5f, 0.5f);
        points[13] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new Point2D32(0.25f, 0.5f);
        points[14] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new Point2D32(0.5f, 0.75f);
        points[15] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[15] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[15] = new Point2D32(0.25f, 0.75f);
        points[16] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[16] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[16] = new Point2D32(0.5f, 0.5f);
        points[17] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[17] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[17] = new Point2D32(0.5f, 0.25f);
        points[18] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[18] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[18] = new Point2D32(0.75f, 0.5f);
        points[19] = new Point3D32((Tuple3DReadOnly)points[7]);
        normals[19] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[19] = new Point2D32(0.75f, 0.25f);
        points[20] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[20] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[20] = new Point2D32(0.25f, 0.5f);
        points[21] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[21] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[21] = new Point2D32(0.25f, 0.25f);
        points[22] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[22] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[22] = new Point2D32(0.0f, 0.5f);
        points[23] = new Point3D32((Tuple3DReadOnly)points[6]);
        normals[23] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[23] = new Point2D32(0.0f, 0.25f);
        int numberOfTriangles = 12;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 15;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 12;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 19;
        triangleIndices[index++] = 17;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 18;
        triangleIndices[index++] = 19;
        triangleIndices[index++] = 20;
        triangleIndices[index++] = 23;
        triangleIndices[index++] = 22;
        triangleIndices[index++] = 20;
        triangleIndices[index++] = 21;
        triangleIndices[index++] = 23;
        return new TriangleMesh3DDefinition("Box Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition FlatRectangle(double sizeX, double sizeY, double z) {
        return TriangleMesh3DFactories.FlatRectangle((float)sizeX, (float)sizeY, (float)z);
    }

    public static TriangleMesh3DDefinition FlatRectangle(float sizeX, float sizeY, float z) {
        return TriangleMesh3DFactories.FlatRectangle(-0.5f * sizeX, -0.5f * sizeY, 0.5f * sizeX, 0.5f * sizeY, z);
    }

    public static TriangleMesh3DDefinition FlatRectangle(double minX, double minY, double maxX, double maxY, double z) {
        return TriangleMesh3DFactories.FlatRectangle((float)minX, (float)minY, (float)maxX, (float)maxY, (float)z);
    }

    public static TriangleMesh3DDefinition FlatRectangle(float minX, float minY, float maxX, float maxY, float z) {
        Point3D32[] points = new Point3D32[4];
        Vector3D32[] normals = new Vector3D32[4];
        Point2D32[] textPoints = new Point2D32[4];
        points[0] = new Point3D32(minX, minY, z);
        points[1] = new Point3D32(maxX, minY, z);
        points[2] = new Point3D32(maxX, maxY, z);
        points[3] = new Point3D32(minX, maxY, z);
        textPoints[0] = new Point2D32(1.0f, 1.0f);
        textPoints[1] = new Point2D32(1.0f, 0.0f);
        textPoints[2] = new Point2D32(0.0f, 0.0f);
        textPoints[3] = new Point2D32(0.0f, 1.0f);
        normals[0] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[2] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[3] = new Vector3D32(0.0f, 0.0f, 1.0f);
        int[] triangleIndices = new int[6];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 3;
        return new TriangleMesh3DDefinition("FlatRectangle Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Ramp(Ramp3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Ramp(description.getSizeX(), description.getSizeY(), description.getSizeZ());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Ramp(double sizeX, double sizeY, double sizeZ) {
        return TriangleMesh3DFactories.Ramp((float)sizeX, (float)sizeY, (float)sizeZ);
    }

    public static TriangleMesh3DDefinition Ramp(float sizeX, float sizeY, float sizeZ) {
        Point3D32[] points = new Point3D32[18];
        Vector3D32[] normals = new Vector3D32[18];
        Point2D32[] textPoints = new Point2D32[18];
        float tex0 = 0.0f;
        float tex1 = 0.33333334f;
        float tex2 = 0.6666667f;
        float tex3 = 1.0f;
        points[0] = new Point3D32(-sizeX / 2.0f, -sizeY / 2.0f, 0.0f);
        normals[0] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[0] = new Point2D32(tex2, tex2);
        points[1] = new Point3D32(sizeX / 2.0f, -sizeY / 2.0f, 0.0f);
        normals[1] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[1] = new Point2D32(tex1, tex2);
        points[2] = new Point3D32(sizeX / 2.0f, sizeY / 2.0f, 0.0f);
        normals[2] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[2] = new Point2D32(tex1, tex1);
        points[3] = new Point3D32(-sizeX / 2.0f, sizeY / 2.0f, 0.0f);
        normals[3] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[3] = new Point2D32(tex2, tex1);
        points[4] = new Point3D32(sizeX / 2.0f, -sizeY / 2.0f, sizeZ);
        normals[4] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[4] = new Point2D32(tex0, tex2);
        points[5] = new Point3D32(sizeX / 2.0f, sizeY / 2.0f, sizeZ);
        normals[5] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[5] = new Point2D32(tex0, tex1);
        points[6] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[6] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[6] = new Point2D32(tex1, tex1);
        points[7] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[7] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[7] = new Point2D32(tex1, tex2);
        float rampAngle = (float)Math.atan2(sizeZ, sizeX);
        points[8] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[8] = new Vector3D32(-((float)Math.sin(rampAngle)), 0.0f, (float)Math.cos(rampAngle));
        textPoints[8] = new Point2D32(tex2, tex2);
        points[9] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[9] = new Vector3D32(-((float)Math.sin(rampAngle)), 0.0f, (float)Math.cos(rampAngle));
        textPoints[9] = new Point2D32(tex3, tex2);
        points[10] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[10] = new Vector3D32(-((float)Math.sin(rampAngle)), 0.0f, (float)Math.cos(rampAngle));
        textPoints[10] = new Point2D32(tex3, tex1);
        points[11] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[11] = new Vector3D32(-((float)Math.sin(rampAngle)), 0.0f, (float)Math.cos(rampAngle));
        textPoints[11] = new Point2D32(tex2, tex1);
        points[12] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new Point2D32(tex2, tex2);
        points[13] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new Point2D32(tex1, tex2);
        points[14] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new Point2D32(tex1, tex3);
        points[15] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[15] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[15] = new Point2D32(tex1, tex1);
        points[16] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[16] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[16] = new Point2D32(tex2, tex1);
        points[17] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[17] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[17] = new Point2D32(tex1, tex0);
        int numberOfTriangles = 8;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 12;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 15;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 17;
        return new TriangleMesh3DDefinition("Ramp Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition PyramidBox(PyramidBox3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.PyramidBox(description.getBoxSizeX(), description.getBoxSizeY(), description.getBoxSizeZ(), description.getPyramidHeight());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition PyramidBox(double boxSizeX, double boxSizeY, double boxSizeZ, double pyramidHeight) {
        return TriangleMesh3DFactories.PyramidBox((float)boxSizeX, (float)boxSizeY, (float)boxSizeZ, (float)pyramidHeight);
    }

    public static TriangleMesh3DDefinition PyramidBox(float boxSizeX, float boxSizeY, float boxSizeZ, float pyramidHeight) {
        Point3D32[] points = new Point3D32[40];
        Vector3D32[] normals = new Vector3D32[40];
        Point2D32[] textPoints = new Point2D32[40];
        float totalHeight = 2.0f * pyramidHeight + boxSizeZ;
        points[0] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[0] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[0] = new Point2D32(0.75f, 1.0f - pyramidHeight / totalHeight);
        points[1] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[1] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[1] = new Point2D32(0.75f, pyramidHeight / totalHeight);
        points[2] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[2] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[2] = new Point2D32(0.5f, pyramidHeight / totalHeight);
        points[3] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[3] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[3] = new Point2D32(0.5f, 1.0f - pyramidHeight / totalHeight);
        points[4] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[4] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[4] = new Point2D32(0.0f, 1.0f - pyramidHeight / totalHeight);
        points[5] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[5] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[5] = new Point2D32(0.0f, pyramidHeight / totalHeight);
        points[6] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[6] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[6] = new Point2D32(0.25f, pyramidHeight / totalHeight);
        points[7] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[7] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[7] = new Point2D32(0.25f, 1.0f - pyramidHeight / totalHeight);
        points[8] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[8] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[8] = new Point2D32(0.5f, 1.0f - pyramidHeight / totalHeight);
        points[9] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[9] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[9] = new Point2D32(0.5f, pyramidHeight / totalHeight);
        points[10] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[10] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[10] = new Point2D32(0.25f, pyramidHeight / totalHeight);
        points[11] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[11] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[11] = new Point2D32(0.25f, 1.0f - pyramidHeight / totalHeight);
        points[12] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new Point2D32(0.75f, 1.0f - pyramidHeight / totalHeight);
        points[13] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new Point2D32(0.75f, pyramidHeight / totalHeight);
        points[14] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new Point2D32(1.0f, pyramidHeight / totalHeight);
        points[15] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[15] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[15] = new Point2D32(1.0f, 1.0f - pyramidHeight / totalHeight);
        float frontBackAngle = (float)Math.atan2((double)boxSizeX / 2.0, pyramidHeight);
        float leftRightAngle = (float)Math.atan2((double)boxSizeY / 2.0, pyramidHeight);
        points[16] = new Point3D32(0.0f, 0.0f, 0.5f * boxSizeZ + pyramidHeight);
        normals[16] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[16] = new Point2D32(0.625f, 0.0f);
        points[17] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[17] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[17] = new Point2D32(0.75f, pyramidHeight / totalHeight);
        points[18] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[18] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[18] = new Point2D32(0.5f, pyramidHeight / totalHeight);
        points[19] = new Point3D32(0.0f, 0.0f, 0.5f * boxSizeZ + pyramidHeight);
        normals[19] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[19] = new Point2D32(0.125f, 0.0f);
        points[20] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[20] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[20] = new Point2D32(0.0f, pyramidHeight / totalHeight);
        points[21] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[21] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[21] = new Point2D32(0.25f, pyramidHeight / totalHeight);
        points[22] = new Point3D32(0.0f, 0.0f, 0.5f * boxSizeZ + pyramidHeight);
        normals[22] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[22] = new Point2D32(0.375f, 0.0f);
        points[23] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[23] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[23] = new Point2D32(0.5f, pyramidHeight / totalHeight);
        points[24] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[24] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[24] = new Point2D32(0.25f, pyramidHeight / totalHeight);
        points[25] = new Point3D32(0.0f, 0.0f, 0.5f * boxSizeZ + pyramidHeight);
        normals[25] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[25] = new Point2D32(0.875f, 0.0f);
        points[26] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[26] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[26] = new Point2D32(0.75f, pyramidHeight / totalHeight);
        points[27] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, 0.5f * boxSizeZ);
        normals[27] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[27] = new Point2D32(1.0f, pyramidHeight / totalHeight);
        points[28] = new Point3D32(0.0f, 0.0f, -pyramidHeight - 0.5f * boxSizeZ);
        normals[28] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[28] = new Point2D32(0.625f, 1.0f);
        points[29] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[29] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[29] = new Point2D32(0.75f, 1.0f - pyramidHeight / totalHeight);
        points[30] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[30] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[30] = new Point2D32(0.5f, 1.0f - pyramidHeight / totalHeight);
        points[31] = new Point3D32(0.0f, 0.0f, -pyramidHeight - 0.5f * boxSizeZ);
        normals[31] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[31] = new Point2D32(0.125f, 1.0f);
        points[32] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[32] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[32] = new Point2D32(0.0f, 1.0f - pyramidHeight / totalHeight);
        points[33] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[33] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[33] = new Point2D32(0.25f, 1.0f - pyramidHeight / totalHeight);
        points[34] = new Point3D32(0.0f, 0.0f, -pyramidHeight - 0.5f * boxSizeZ);
        normals[34] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[34] = new Point2D32(0.375f, 1.0f);
        points[35] = new Point3D32(-boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[35] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[35] = new Point2D32(0.5f, 1.0f - pyramidHeight / totalHeight);
        points[36] = new Point3D32(boxSizeX / 2.0f, boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[36] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[36] = new Point2D32(0.25f, 1.0f - pyramidHeight / totalHeight);
        points[37] = new Point3D32(0.0f, 0.0f, -pyramidHeight - 0.5f * boxSizeZ);
        normals[37] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[37] = new Point2D32(0.875f, 1.0f);
        points[38] = new Point3D32(-boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[38] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[38] = new Point2D32(0.75f, 1.0f - pyramidHeight / totalHeight);
        points[39] = new Point3D32(boxSizeX / 2.0f, -boxSizeY / 2.0f, -0.5f * boxSizeZ);
        normals[39] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[39] = new Point2D32(1.0f, 1.0f - pyramidHeight / totalHeight);
        int numberOfTriangles = 16;
        int[] polygonIndices = new int[3 * numberOfTriangles];
        int index = 0;
        polygonIndices[index++] = 0;
        polygonIndices[index++] = 1;
        polygonIndices[index++] = 2;
        polygonIndices[index++] = 0;
        polygonIndices[index++] = 2;
        polygonIndices[index++] = 3;
        polygonIndices[index++] = 4;
        polygonIndices[index++] = 6;
        polygonIndices[index++] = 5;
        polygonIndices[index++] = 4;
        polygonIndices[index++] = 7;
        polygonIndices[index++] = 6;
        polygonIndices[index++] = 8;
        polygonIndices[index++] = 9;
        polygonIndices[index++] = 10;
        polygonIndices[index++] = 8;
        polygonIndices[index++] = 10;
        polygonIndices[index++] = 11;
        polygonIndices[index++] = 12;
        polygonIndices[index++] = 14;
        polygonIndices[index++] = 13;
        polygonIndices[index++] = 12;
        polygonIndices[index++] = 15;
        polygonIndices[index++] = 14;
        polygonIndices[index++] = 16;
        polygonIndices[index++] = 18;
        polygonIndices[index++] = 17;
        polygonIndices[index++] = 19;
        polygonIndices[index++] = 20;
        polygonIndices[index++] = 21;
        polygonIndices[index++] = 22;
        polygonIndices[index++] = 24;
        polygonIndices[index++] = 23;
        polygonIndices[index++] = 25;
        polygonIndices[index++] = 26;
        polygonIndices[index++] = 27;
        polygonIndices[index++] = 28;
        polygonIndices[index++] = 29;
        polygonIndices[index++] = 30;
        polygonIndices[index++] = 31;
        polygonIndices[index++] = 33;
        polygonIndices[index++] = 32;
        polygonIndices[index++] = 36;
        polygonIndices[index++] = 34;
        polygonIndices[index++] = 35;
        polygonIndices[index++] = 37;
        polygonIndices[index++] = 39;
        polygonIndices[index++] = 38;
        return new TriangleMesh3DDefinition("PyramidBox Factory", points, textPoints, normals, polygonIndices);
    }

    public static TriangleMesh3DDefinition Line(LineSegment3DReadOnly lineSegment, double width) {
        return TriangleMesh3DFactories.Line(lineSegment.getFirstEndpoint(), lineSegment.getSecondEndpoint(), width);
    }

    public static TriangleMesh3DDefinition Line(Point3DReadOnly point0, Point3DReadOnly point1, double width) {
        return TriangleMesh3DFactories.Line(point0.getX(), point0.getY(), point0.getZ(), point1.getX(), point1.getY(), point1.getZ(), width);
    }

    public static TriangleMesh3DDefinition Line(double x0, double y0, double z0, double x1, double y1, double z1, double width) {
        return TriangleMesh3DFactories.Line((float)x0, (float)y0, (float)z0, (float)x1, (float)y1, (float)z1, (float)width);
    }

    public static TriangleMesh3DDefinition Line(float x0, float y0, float z0, float x1, float y1, float z1, float width) {
        float vz;
        float vy;
        float vx;
        int i;
        float pitch;
        float yaw;
        Vector3D32 lineDirection = new Vector3D32(x1 - x0, y1 - y0, z1 - z0);
        float lineLength = (float)lineDirection.length();
        lineDirection.scale((double)(1.0f / lineLength));
        TriangleMesh3DDefinition line = TriangleMesh3DFactories.Box(width, width, lineLength, false);
        line.setName("Line Factory");
        Point3D32[] vertices = line.getVertices();
        Vector3D32[] normals = line.getNormals();
        if (Math.abs(lineDirection.getZ()) < 0.9999999) {
            yaw = (float)Math.atan2(lineDirection.getY(), lineDirection.getX());
            double xyLength = Math.sqrt(lineDirection.getX() * lineDirection.getX() + lineDirection.getY() * lineDirection.getY());
            pitch = (float)Math.atan2(xyLength, lineDirection.getZ());
        } else {
            yaw = 0.0f;
            pitch = lineDirection.getZ() >= 0.0 ? 0.0f : (float)Math.PI;
        }
        float cYaw = (float)Math.cos(yaw);
        float sYaw = (float)Math.sin(yaw);
        float cPitch = (float)Math.cos(pitch);
        float sPitch = (float)Math.sin(pitch);
        float rxx = cYaw * cPitch;
        float rxy = -sYaw;
        float rxz = cYaw * sPitch;
        float ryx = sYaw * cPitch;
        float ryy = cYaw;
        float ryz = sYaw * sPitch;
        float rzx = -sPitch;
        float rzz = cPitch;
        for (i = 0; i < vertices.length; ++i) {
            Point3D32 vertex = vertices[i];
            vx = vertex.getX32();
            vy = vertex.getY32();
            vz = vertex.getZ32();
            vertex.setX(x0 + rxx * vx + rxy * vy + rxz * vz);
            vertex.setY(y0 + ryx * vx + ryy * vy + ryz * vz);
            vertex.setZ(z0 + rzx * vx + rzz * vz);
        }
        for (i = 0; i < normals.length; ++i) {
            Vector3D32 normal = normals[i];
            vx = normal.getX32();
            vy = normal.getY32();
            vz = normal.getZ32();
            normal.setX(rxx * vx + rxy * vy + rxz * vz);
            normal.setY(ryx * vx + ryy * vy + ryz * vz);
            normal.setZ(rzx * vx + rzz * vz);
        }
        return line;
    }

    public static TriangleMesh3DDefinition Capsule(Capsule3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Capsule(description.getLength(), description.getRadiusX(), description.getRadiusY(), description.getRadiusZ(), description.getResolution(), description.getResolution());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Capsule(double height, double radiusX, double radiusY, double radiusZ, int latitudeResolution, int longitudeResolution) {
        return TriangleMesh3DFactories.Capsule((float)height, (float)radiusX, (float)radiusY, (float)radiusZ, latitudeResolution, longitudeResolution);
    }

    public static TriangleMesh3DDefinition Capsule(float height, float radiusX, float radiusY, float radiusZ, int latitudeResolution, int longitudeResolution) {
        int nextLongitudeIndex;
        int longitudeIndex;
        int latitudeIndex;
        if (latitudeResolution % 2 != 0) {
            ++latitudeResolution;
        }
        if (longitudeResolution % 2 != 1) {
            ++longitudeResolution;
        }
        int numberOfVertices = latitudeResolution * longitudeResolution;
        Point3D32[] points = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        Point2D32[] textPoints = new Point2D32[numberOfVertices];
        float texRatio = radiusZ / (2.0f * radiusZ + height);
        float halfHeight = 0.5f * height;
        for (int longitudeIndex2 = 0; longitudeIndex2 < longitudeResolution; ++longitudeIndex2) {
            float textureY;
            float vertexZ;
            float vertexY;
            float vertexX;
            float normalZ;
            float normalY;
            float normalX;
            int currentIndex;
            float sinLatitude;
            float cosLatitude;
            float sinLongitude;
            float cosLongitude;
            float latitudeAngle;
            float longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / ((float)longitudeResolution - 1.0f));
            float textureX = (float)longitudeIndex2 / (float)(longitudeResolution - 1);
            for (latitudeIndex = 1; latitudeIndex < latitudeResolution / 2; ++latitudeIndex) {
                latitudeAngle = (float)(-1.5707963705062866 + Math.PI * (double)((float)latitudeIndex / ((float)latitudeResolution - 1.0f)));
                cosLongitude = (float)Math.cos(longitudeAngle);
                sinLongitude = (float)Math.sin(longitudeAngle);
                cosLatitude = (float)Math.cos(latitudeAngle);
                sinLatitude = (float)Math.sin(latitudeAngle);
                currentIndex = latitudeIndex * longitudeResolution + longitudeIndex2;
                normalX = cosLongitude * cosLatitude;
                normalY = sinLongitude * cosLatitude;
                normalZ = sinLatitude;
                vertexX = radiusX * normalX;
                vertexY = radiusY * normalY;
                vertexZ = radiusZ * normalZ - halfHeight;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                textureY = 1.0f - (1.0f + sinLatitude) * texRatio;
                textPoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            for (latitudeIndex = 0; latitudeIndex < latitudeResolution / 2 - 1; ++latitudeIndex) {
                latitudeAngle = (float)(Math.PI * (double)((float)latitudeIndex / ((float)latitudeResolution - 1.0f)));
                cosLongitude = (float)Math.cos(longitudeAngle);
                sinLongitude = (float)Math.sin(longitudeAngle);
                cosLatitude = (float)Math.cos(latitudeAngle);
                sinLatitude = (float)Math.sin(latitudeAngle);
                currentIndex = (latitudeResolution / 2 + latitudeIndex) * longitudeResolution + longitudeIndex2;
                normalX = cosLongitude * cosLatitude;
                normalY = sinLongitude * cosLatitude;
                normalZ = sinLatitude;
                vertexX = radiusX * normalX;
                vertexY = radiusY * normalY;
                vertexZ = radiusZ * normalZ + halfHeight;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                textureY = (1.0f - sinLatitude) * texRatio;
                textPoints[currentIndex] = new Point2D32(textureX, textureY);
            }
            int southPoleIndex = longitudeIndex2;
            points[southPoleIndex] = new Point3D32(0.0f, 0.0f, -radiusZ - halfHeight);
            normals[southPoleIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[southPoleIndex] = new Point2D32(textureX += 0.5f / ((float)longitudeResolution - 1.0f), 0.99609375f);
            int northPoleIndex = (latitudeResolution - 1) * longitudeResolution + longitudeIndex2;
            points[northPoleIndex] = new Point3D32(0.0f, 0.0f, radiusZ + halfHeight);
            normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[northPoleIndex] = new Point2D32(textureX, 0.00390625f);
        }
        int numberOfTriangles = 2 * latitudeResolution * longitudeResolution + 1 * longitudeResolution;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (latitudeIndex = 1; latitudeIndex < latitudeResolution - 1; ++latitudeIndex) {
            for (int longitudeIndex3 = 0; longitudeIndex3 < longitudeResolution; ++longitudeIndex3) {
                int nextLongitudeIndex2 = (longitudeIndex3 + 1) % longitudeResolution;
                int nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * longitudeResolution + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeResolution + nextLongitudeIndex2;
                triangleIndices[index++] = nextLatitudeIndex * longitudeResolution + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeResolution + nextLongitudeIndex2;
                triangleIndices[index++] = nextLatitudeIndex * longitudeResolution + nextLongitudeIndex2;
                triangleIndices[index++] = nextLatitudeIndex * longitudeResolution + longitudeIndex3;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeResolution - 1; ++longitudeIndex) {
            nextLongitudeIndex = (longitudeIndex + 1) % longitudeResolution;
            triangleIndices[index++] = longitudeIndex;
            triangleIndices[index++] = longitudeResolution + nextLongitudeIndex;
            triangleIndices[index++] = longitudeResolution + longitudeIndex;
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeResolution - 1; ++longitudeIndex) {
            nextLongitudeIndex = (longitudeIndex + 1) % longitudeResolution;
            triangleIndices[index++] = (latitudeResolution - 1) * longitudeResolution + longitudeIndex;
            triangleIndices[index++] = (latitudeResolution - 2) * longitudeResolution + longitudeIndex;
            triangleIndices[index++] = (latitudeResolution - 2) * longitudeResolution + nextLongitudeIndex;
        }
        return new TriangleMesh3DDefinition("Capsule Factory", points, textPoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition Tetrahedron(Tetrahedron3DDefinition description) {
        TriangleMesh3DDefinition meshDataHolder = TriangleMesh3DFactories.Tetrahedron(description.getEdgeLength());
        if (meshDataHolder != null) {
            meshDataHolder.setName(description.getName());
        }
        return meshDataHolder;
    }

    public static TriangleMesh3DDefinition Tetrahedron(double edgeLength) {
        return TriangleMesh3DFactories.Tetrahedron((float)edgeLength);
    }

    public static TriangleMesh3DDefinition Tetrahedron(float edgeLength) {
        float height = THIRD_SQRT6 * edgeLength;
        float topHeight = FOURTH_SQRT6 * edgeLength;
        float baseHeight = topHeight - height;
        float halfEdgeLength = 0.5f * edgeLength;
        float cosFaceEdgeFace = 0.33333334f;
        float sinFaceEdgeFace = TETRAHEDRON_SINE_FACE_EDGE_FACE_ANGLE;
        float cosEdgeVertexEdge = 0.5f;
        float sinEdgeVertexEdge = HALF_SQRT3;
        Point3D32 topVertex = new Point3D32(0.0f, 0.0f, topHeight);
        Point3D32 baseVertex0 = new Point3D32(edgeLength * THIRD_SQRT3, 0.0f, baseHeight);
        Point3D32 baseVertex1 = new Point3D32(-edgeLength * SIXTH_SQRT3, halfEdgeLength, baseHeight);
        Point3D32 baseVertex2 = new Point3D32(-edgeLength * SIXTH_SQRT3, -halfEdgeLength, baseHeight);
        Vector3D32 frontNormal = new Vector3D32(-sinFaceEdgeFace, 0.0f, cosFaceEdgeFace);
        Vector3D32 rightNormal = new Vector3D32(sinFaceEdgeFace * sinEdgeVertexEdge, sinFaceEdgeFace * cosEdgeVertexEdge, cosFaceEdgeFace);
        Vector3D32 leftNormal = new Vector3D32(sinFaceEdgeFace * sinEdgeVertexEdge, -sinFaceEdgeFace * cosEdgeVertexEdge, cosFaceEdgeFace);
        Vector3D32 baseNormal = new Vector3D32(0.0f, 0.0f, -1.0f);
        int numberOfVertices = 12;
        Point3D32[] vertices = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        Point2D32[] texturePoints = new Point2D32[numberOfVertices];
        vertices[0] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        normals[0] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        texturePoints[0] = new Point2D32(0.25f, 0.5f);
        vertices[1] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        normals[1] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        texturePoints[1] = new Point2D32(0.75f, 0.5f);
        vertices[2] = new Point3D32((Tuple3DReadOnly)topVertex);
        normals[2] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        texturePoints[2] = new Point2D32(0.5f, 1.0f);
        vertices[3] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        normals[3] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        texturePoints[3] = new Point2D32(0.75f, 0.5f);
        vertices[4] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        normals[4] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        texturePoints[4] = new Point2D32(0.5f, 0.0f);
        vertices[5] = new Point3D32((Tuple3DReadOnly)topVertex);
        normals[5] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        texturePoints[5] = new Point2D32(1.0f, 0.0f);
        vertices[6] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        normals[6] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        texturePoints[6] = new Point2D32(0.5f, 0.0f);
        vertices[7] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        normals[7] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        texturePoints[7] = new Point2D32(0.25f, 0.5f);
        vertices[8] = new Point3D32((Tuple3DReadOnly)topVertex);
        normals[8] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        texturePoints[8] = new Point2D32(0.0f, 0.0f);
        vertices[9] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        normals[9] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        texturePoints[9] = new Point2D32(0.5f, 0.0f);
        vertices[10] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        normals[10] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        texturePoints[10] = new Point2D32(0.75f, 0.5f);
        vertices[11] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        normals[11] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        texturePoints[11] = new Point2D32(0.25f, 0.5f);
        int numberOfTriangles = 4;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 10;
        return new TriangleMesh3DDefinition("Tetrahedron Factory", vertices, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition ConvexPolytope(ConvexPolytope3DDefinition description) {
        return TriangleMesh3DFactories.ConvexPolytope(description.getConvexPolytope());
    }

    public static TriangleMesh3DDefinition ConvexPolytope(ConvexPolytope3DReadOnly convexPolytope) {
        if (convexPolytope == null) {
            return null;
        }
        int numberOfVertices = convexPolytope.getFaces().stream().mapToInt(Face3DReadOnly::getNumberOfEdges).sum();
        Point3D32[] vertices = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        Point2D32[] texturePoints = new Point2D32[numberOfVertices];
        int numberOfTriangles = numberOfVertices - 2 * convexPolytope.getNumberOfFaces();
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int vertexOffset = 0;
        int triangleOffset = 0;
        Vector3D direction = new Vector3D();
        for (int faceIndex = 0; faceIndex < convexPolytope.getNumberOfFaces(); ++faceIndex) {
            int vertexIndex;
            Face3DReadOnly face = convexPolytope.getFace(faceIndex);
            double minLongitude = Double.POSITIVE_INFINITY;
            double[] longitudes = new double[face.getNumberOfEdges()];
            for (vertexIndex = 0; vertexIndex < face.getNumberOfEdges(); ++vertexIndex) {
                double longitude;
                Vertex3DReadOnly vertex = face.getVertex(vertexIndex);
                vertices[vertexOffset + vertexIndex] = new Point3D32((Tuple3DReadOnly)vertex);
                normals[vertexOffset + vertexIndex] = new Vector3D32((Tuple3DReadOnly)face.getNormal());
                direction.sub((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)convexPolytope.getCentroid());
                direction.normalize();
                longitudes[vertexIndex] = longitude = Math.atan2(direction.getY(), direction.getX());
                minLongitude = Math.min(longitude, minLongitude);
                float textureY = 0.5f * (1.0f - direction.getZ32());
                texturePoints[vertexOffset + vertexIndex] = new Point2D32(0.0f, textureY);
            }
            for (vertexIndex = 0; vertexIndex < face.getNumberOfEdges(); ++vertexIndex) {
                double longitude = minLongitude + EuclidCoreTools.angleDifferenceMinusPiToPi((double)longitudes[vertexIndex], (double)minLongitude);
                float textureX = (float)(0.5 * (longitude / Math.PI + 1.0));
                texturePoints[vertexOffset + vertexIndex].setX(textureX);
            }
            for (int i = 2; i < face.getNumberOfEdges(); ++i) {
                triangleIndices[triangleOffset++] = vertexOffset;
                triangleIndices[triangleOffset++] = vertexOffset + i;
                triangleIndices[triangleOffset++] = vertexOffset + i - 1;
            }
            vertexOffset += face.getNumberOfEdges();
        }
        return new TriangleMesh3DDefinition("ConvexPolytope Factory", vertices, texturePoints, normals, triangleIndices);
    }

    public static TriangleMesh3DDefinition toSTPBox3DMesh(RigidBodyTransformReadOnly pose, Tuple3DReadOnly size, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.toSTPBox3DMesh(pose, size.getX(), size.getY(), size.getZ(), smallRadius, largeRadius, highlightLimits);
    }

    public static TriangleMesh3DDefinition toSTPBox3DMesh(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.combine(true, false, TriangleMesh3DFactories.toSTPBox3DMeshes(pose, sizeX, sizeY, sizeZ, smallRadius, largeRadius, highlightLimits));
    }

    public static TriangleMesh3DDefinition[] toSTPBox3DMeshes(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ, double smallRadius, double largeRadius, boolean highlightLimits) {
        Box3D stpBox3D = new Box3D(sizeX, sizeY, sizeZ);
        if (pose != null) {
            stpBox3D.getPose().set(pose);
        }
        BoxPolytope3DView boxPolytope = stpBox3D.asConvexPolytope();
        return TriangleMesh3DFactories.toSTPConvexPolytope3DMeshes((ConvexPolytope3DReadOnly)boxPolytope, smallRadius, largeRadius, highlightLimits);
    }

    public static TriangleMesh3DDefinition toSTPCapsule3DMesh(RigidBodyTransformReadOnly pose, double radius, double length, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.combine(true, false, TriangleMesh3DFactories.toSTPCapsule3DMeshes(pose, radius, length, smallRadius, largeRadius, highlightLimits));
    }

    public static TriangleMesh3DDefinition[] toSTPCapsule3DMeshes(RigidBodyTransformReadOnly pose, double radius, double length, double smallRadius, double largeRadius, boolean highlightLimits) {
        ArrayList<TriangleMesh3DDefinition> faceMeshes = new ArrayList<TriangleMesh3DDefinition>();
        UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);
        Point3D position = new Point3D();
        if (pose != null) {
            pose.transform((Vector3DBasics)axis);
            position.set(pose.getTranslation());
        }
        Point3D topCenter = new Point3D();
        topCenter.scaleAdd(0.5 * length, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)position);
        Point3D bottomCenter = new Point3D();
        bottomCenter.scaleAdd(-0.5 * length, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)position);
        Vector3D axisOrthogonal = TriangleMesh3DFactories.newOrthogonalVector((Vector3DReadOnly)axis);
        double sphereOffset = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)length);
        Point3D sphereCenter = new Point3D();
        sphereCenter.scaleAdd(-sphereOffset, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)position);
        UnitVector3D startDirection = new UnitVector3D();
        UnitVector3D endDirection = new UnitVector3D();
        startDirection.sub((Tuple3DReadOnly)bottomCenter, (Tuple3DReadOnly)sphereCenter);
        endDirection.sub((Tuple3DReadOnly)topCenter, (Tuple3DReadOnly)sphereCenter);
        TriangleMesh3DDefinition arc = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)sphereCenter, largeRadius, (Vector3DReadOnly)startDirection, (Vector3DReadOnly)endDirection, 64);
        faceMeshes.add(TriangleMesh3DFactories.applyRevolution(arc, (Point3DReadOnly)position, (Vector3DReadOnly)axis, 0.0, 6.2831854820251465, 64, false));
        if (highlightLimits) {
            double limitPositionOnAxis = 0.5 * length * largeRadius / (largeRadius - smallRadius);
            double limitRadius = sphereOffset * smallRadius / (largeRadius - smallRadius);
            TriangleMesh3DDefinition sideLimitMesh = TriangleMesh3DFactories.ArcTorus(0.0, 6.2831854820251465, limitRadius, 0.001, 64);
            sideLimitMesh = TriangleMesh3DFactories.rotate(sideLimitMesh, (Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axis));
            sideLimitMesh = TriangleMesh3DFactories.translate(sideLimitMesh, (Tuple3DReadOnly)position);
            Arrays.asList(sideLimitMesh.getVertices()).forEach(v -> v.scaleAdd(limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(sideLimitMesh.copy());
            Arrays.asList(sideLimitMesh.getVertices()).forEach(v -> v.scaleAdd(-2.0 * limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(sideLimitMesh);
        }
        startDirection.set(axis);
        arc = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)topCenter, smallRadius, (Vector3DReadOnly)endDirection, (Vector3DReadOnly)startDirection, 64);
        TriangleMesh3DDefinition capMesh = TriangleMesh3DFactories.applyRevolution(arc, (Point3DReadOnly)position, (Vector3DReadOnly)axis, 0.0, 6.2831854820251465, 64, false);
        faceMeshes.add(capMesh.copy());
        RotationMatrix flipRotation = new RotationMatrix();
        flipRotation.setAxisAngle(axisOrthogonal.getX(), axisOrthogonal.getY(), axisOrthogonal.getZ(), Math.PI);
        Arrays.asList(capMesh.getVertices()).forEach(v -> {
            v.sub((Tuple3DReadOnly)position);
            flipRotation.transform((Tuple3DBasics)v);
            v.add((Tuple3DReadOnly)position);
        });
        Arrays.asList(capMesh.getNormals()).forEach(n -> flipRotation.transform((Tuple3DBasics)n));
        faceMeshes.add(capMesh);
        return new TriangleMesh3DDefinition[]{TriangleMesh3DFactories.combine(true, false, faceMeshes)};
    }

    public static TriangleMesh3DDefinition toSTPCylinder3DMesh(RigidBodyTransformReadOnly pose, double radius, double length, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.combine(true, false, TriangleMesh3DFactories.toSTPCylinder3DMeshes(pose, radius, length, smallRadius, largeRadius, highlightLimits));
    }

    public static TriangleMesh3DDefinition[] toSTPCylinder3DMeshes(RigidBodyTransformReadOnly pose, double radius, double length, double smallRadius, double largeRadius, boolean highlightLimits) {
        ArrayList<TriangleMesh3DDefinition> faceMeshes = new ArrayList<TriangleMesh3DDefinition>();
        ArrayList<TriangleMesh3DDefinition> edgeMeshes = new ArrayList<TriangleMesh3DDefinition>();
        UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);
        Point3D position = new Point3D();
        if (pose != null) {
            axis.applyTransform((Transform)pose);
            position.set(pose.getTranslation());
        }
        Point3D topCenter = new Point3D();
        topCenter.scaleAdd(0.5 * length, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)position);
        Point3D bottomCenter = new Point3D();
        bottomCenter.scaleAdd(-0.5 * length, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)position);
        Vector3D axisOrthogonal = TriangleMesh3DFactories.newOrthogonalVector((Vector3DReadOnly)axis);
        double sphereOffset = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)length);
        Point3D sphereCenter = new Point3D();
        sphereCenter.scaleAdd(-sphereOffset + radius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)position);
        UnitVector3D startDirection = new UnitVector3D();
        UnitVector3D endDirection = new UnitVector3D();
        startDirection.scaleAdd(radius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)bottomCenter);
        startDirection.sub((Tuple3DReadOnly)sphereCenter);
        endDirection.scaleAdd(radius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)topCenter);
        endDirection.sub((Tuple3DReadOnly)sphereCenter);
        TriangleMesh3DDefinition arc = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)sphereCenter, largeRadius, (Vector3DReadOnly)startDirection, (Vector3DReadOnly)endDirection, 64);
        faceMeshes.add(TriangleMesh3DFactories.applyRevolution(arc, (Point3DReadOnly)position, (Vector3DReadOnly)axis, 0.0, 6.2831854820251465, 64, false));
        if (highlightLimits) {
            double limitPositionOnAxis = 0.5 * length * largeRadius / (largeRadius - smallRadius);
            double limitRadius = radius + sphereOffset * smallRadius / (largeRadius - smallRadius);
            TriangleMesh3DDefinition sideLimitMesh = TriangleMesh3DFactories.ArcTorus(0.0, 6.2831854820251465, limitRadius, 0.001, 64);
            sideLimitMesh = TriangleMesh3DFactories.rotate(sideLimitMesh, (Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axis));
            sideLimitMesh = TriangleMesh3DFactories.translate(sideLimitMesh, (Tuple3DReadOnly)position);
            Arrays.asList(sideLimitMesh.getVertices()).forEach(v -> v.scaleAdd(limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(sideLimitMesh.copy());
            Arrays.asList(sideLimitMesh.getVertices()).forEach(v -> v.scaleAdd(-2.0 * limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(sideLimitMesh);
        }
        double sphereOffset2 = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)(2.0 * radius));
        Point3D sphereCenter2 = new Point3D();
        sphereCenter2.scaleAdd(-sphereOffset2, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)topCenter);
        Vector3D axisOrthogonal2 = TriangleMesh3DFactories.newOrthogonalVector((Vector3DReadOnly)axis);
        UnitVector3D boundaryDirection = new UnitVector3D();
        boundaryDirection.scaleAdd(radius, (Tuple3DReadOnly)axisOrthogonal2, (Tuple3DReadOnly)topCenter);
        boundaryDirection.sub((Tuple3DReadOnly)sphereCenter2);
        TriangleMesh3DDefinition arc2 = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)sphereCenter2, largeRadius, (Vector3DReadOnly)boundaryDirection, (Vector3DReadOnly)axis, 64);
        TriangleMesh3DDefinition capMesh = TriangleMesh3DFactories.applyRevolution(arc2, (Point3DReadOnly)position, (Vector3DReadOnly)axis, 0.0, 6.2831854820251465, 64, false);
        faceMeshes.add(capMesh.copy());
        RotationMatrix flipRotation = new RotationMatrix();
        flipRotation.setAxisAngle(axisOrthogonal2.getX(), axisOrthogonal2.getY(), axisOrthogonal2.getZ(), Math.PI);
        Arrays.asList(capMesh.getVertices()).forEach(v -> {
            v.sub((Tuple3DReadOnly)position);
            flipRotation.transform((Tuple3DBasics)v);
            v.add((Tuple3DReadOnly)position);
        });
        Arrays.asList(capMesh.getNormals()).forEach(n -> flipRotation.transform((Tuple3DBasics)n));
        faceMeshes.add(capMesh);
        if (highlightLimits) {
            double limitPositionOnAxis = 0.5 * length + sphereOffset2 * smallRadius / (largeRadius - smallRadius);
            double limitRadius = radius * largeRadius / (largeRadius - smallRadius);
            TriangleMesh3DDefinition capLimitMesh = TriangleMesh3DFactories.ArcTorus(0.0, 6.2831854820251465, limitRadius, 0.001, 64);
            capLimitMesh = TriangleMesh3DFactories.rotate(capLimitMesh, (Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)axis));
            capLimitMesh = TriangleMesh3DFactories.translate(capLimitMesh, (Tuple3DReadOnly)position);
            Arrays.asList(capLimitMesh.getVertices()).forEach(v -> v.scaleAdd(limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(capLimitMesh.copy());
            Arrays.asList(capLimitMesh.getVertices()).forEach(v -> v.scaleAdd(-2.0 * limitPositionOnAxis, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)v));
            faceMeshes.add(capLimitMesh);
        }
        axisOrthogonal = TriangleMesh3DFactories.newOrthogonalVector((Vector3DReadOnly)axis);
        Point3D arcCenter = new Point3D();
        arcCenter.scaleAdd(radius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)topCenter);
        double capSphereOffset = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)(2.0 * radius));
        Point3D capSphereCenter = new Point3D();
        capSphereCenter.scaleAdd(-capSphereOffset, (Tuple3DReadOnly)axis, (Tuple3DReadOnly)topCenter);
        double sideSphereOffset = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)length);
        Point3D sideSphereCenter = new Point3D();
        sideSphereCenter.scaleAdd(-sideSphereOffset + radius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)position);
        UnitVector3D startDirection2 = new UnitVector3D();
        UnitVector3D endDirection2 = new UnitVector3D();
        startDirection2.sub((Tuple3DReadOnly)arcCenter, (Tuple3DReadOnly)sideSphereCenter);
        endDirection2.sub((Tuple3DReadOnly)arcCenter, (Tuple3DReadOnly)capSphereCenter);
        TriangleMesh3DDefinition arc3 = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)arcCenter, smallRadius, (Vector3DReadOnly)startDirection2, (Vector3DReadOnly)endDirection2, 32);
        TriangleMesh3DDefinition edgeMesh = TriangleMesh3DFactories.applyRevolution(arc3, (Point3DReadOnly)position, (Vector3DReadOnly)axis, 0.0, 6.2831854820251465, 64, false);
        faceMeshes.add(edgeMesh.copy());
        RotationMatrix flipRotation2 = new RotationMatrix();
        flipRotation2.setAxisAngle(axisOrthogonal.getX(), axisOrthogonal.getY(), axisOrthogonal.getZ(), Math.PI);
        Arrays.asList(edgeMesh.getVertices()).forEach(v -> {
            v.sub((Tuple3DReadOnly)position);
            flipRotation2.transform((Tuple3DBasics)v);
            v.add((Tuple3DReadOnly)position);
        });
        Arrays.asList(edgeMesh.getNormals()).forEach(n -> flipRotation2.transform((Tuple3DBasics)n));
        faceMeshes.add(edgeMesh);
        return new TriangleMesh3DDefinition[]{TriangleMesh3DFactories.combine(true, false, faceMeshes), TriangleMesh3DFactories.combine(true, false, edgeMeshes)};
    }

    public static TriangleMesh3DDefinition toSTPRamp3DMesh(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.combine(true, false, TriangleMesh3DFactories.toSTPRamp3DMeshes(pose, sizeX, sizeY, sizeZ, smallRadius, largeRadius, highlightLimits));
    }

    public static TriangleMesh3DDefinition[] toSTPRamp3DMeshes(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ, double smallRadius, double largeRadius, boolean highlightLimits) {
        Ramp3D stpRamp3D = new Ramp3D(sizeX, sizeY, sizeZ);
        if (pose != null) {
            stpRamp3D.getPose().set(pose);
        }
        return TriangleMesh3DFactories.toSTPConvexPolytope3DMeshes((ConvexPolytope3DReadOnly)stpRamp3D.asConvexPolytope(), smallRadius, largeRadius, highlightLimits);
    }

    public static TriangleMesh3DDefinition toSTPConvexPolytope3DMesh(ConvexPolytope3DReadOnly convexPolytope, double smallRadius, double largeRadius, boolean highlightLimits) {
        return TriangleMesh3DFactories.combine(true, false, TriangleMesh3DFactories.toSTPConvexPolytope3DMeshes(convexPolytope, smallRadius, largeRadius, highlightLimits));
    }

    public static TriangleMesh3DDefinition[] toSTPConvexPolytope3DMeshes(ConvexPolytope3DReadOnly convexPolytope, double smallRadius, double largeRadius, boolean highlightLimits) {
        ArrayList<TriangleMesh3DDefinition> faceMeshes = new ArrayList<TriangleMesh3DDefinition>();
        ArrayList<TriangleMesh3DDefinition> edgeMeshes = new ArrayList<TriangleMesh3DDefinition>();
        ArrayList<TriangleMesh3DDefinition> vertexMeshes = new ArrayList<TriangleMesh3DDefinition>();
        for (int faceIndex = 0; faceIndex < convexPolytope.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = convexPolytope.getFace(faceIndex);
            faceMeshes.addAll(TriangleMesh3DFactories.toFaceSpheres(face, largeRadius, smallRadius, highlightLimits));
            edgeMeshes.addAll(TriangleMesh3DFactories.toFaceInnerTori(face, largeRadius, smallRadius));
        }
        HashSet<HalfEdge3DReadOnly> processedHalfEdgeSet = new HashSet<HalfEdge3DReadOnly>();
        for (int edgeIndex = 0; edgeIndex < convexPolytope.getNumberOfHalfEdges(); ++edgeIndex) {
            HalfEdge3DReadOnly halfEdge = convexPolytope.getHalfEdge(edgeIndex);
            if (processedHalfEdgeSet.contains(halfEdge.getTwin())) continue;
            processedHalfEdgeSet.add(halfEdge);
            edgeMeshes.add(TriangleMesh3DFactories.toHalfEdgeTorus(halfEdge, largeRadius, smallRadius));
        }
        for (int vertexIndex = 0; vertexIndex < convexPolytope.getNumberOfVertices(); ++vertexIndex) {
            Vertex3DReadOnly vertex = convexPolytope.getVertex(vertexIndex);
            vertexMeshes.addAll(TriangleMesh3DFactories.toVertexSphere(vertex, largeRadius, smallRadius, false));
        }
        return new TriangleMesh3DDefinition[]{TriangleMesh3DFactories.combine(true, false, faceMeshes), TriangleMesh3DFactories.combine(true, false, edgeMeshes), TriangleMesh3DFactories.combine(true, false, vertexMeshes)};
    }

    public static List<TriangleMesh3DDefinition> toFaceSpheres(Face3DReadOnly face, double largeRadius, double smallRadius, boolean highlightLimits) {
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        boolean isFaceCyclicPolygon = TriangleMesh3DFactories.isFaceCyclicPolygon(face, largeRadius, smallRadius);
        int startIndex = TriangleMesh3DFactories.computeFaceStartIndex(face);
        Vertex3DReadOnly v0 = face.getVertex(startIndex);
        for (int indexOffset = 1; indexOffset < face.getNumberOfEdges() - 1; ++indexOffset) {
            Vertex3DReadOnly v1 = face.getVertex((startIndex + indexOffset) % face.getNumberOfEdges());
            Vertex3DReadOnly v2 = face.getVertex((startIndex + indexOffset + 1) % face.getNumberOfEdges());
            meshes.addAll(TriangleMesh3DFactories.toFaceSubSphere(face, v0, v1, v2, largeRadius, smallRadius, highlightLimits && !isFaceCyclicPolygon));
        }
        if (highlightLimits && isFaceCyclicPolygon) {
            meshes.addAll(TriangleMesh3DFactories.toCyclicFaceSphereLimits(face, largeRadius, smallRadius, 0.001));
        }
        return meshes;
    }

    private static int computeFaceStartIndex(Face3DReadOnly face) {
        int startIndex = 0;
        double maxDistanceSquared = 0.0;
        for (int i = 0; i < face.getNumberOfEdges(); ++i) {
            Vertex3DReadOnly v0 = face.getVertex(i);
            for (int j = 0; j < face.getNumberOfEdges(); ++j) {
                Vertex3DReadOnly v1 = face.getVertex(j);
                double distanceSquared = v0.distanceSquared((Point3DReadOnly)v1);
                if (!(distanceSquared > maxDistanceSquared)) continue;
                startIndex = i;
                maxDistanceSquared = distanceSquared;
            }
        }
        return startIndex;
    }

    private static boolean isFaceCyclicPolygon(Face3DReadOnly face, double largeRadius, double smallRadius) {
        if (face.getNumberOfEdges() <= 3) {
            return true;
        }
        Point3D sphereCenter = new Point3D();
        Vertex3DReadOnly v0 = face.getVertex(0);
        Vertex3DReadOnly v1 = face.getVertex(1);
        Vertex3DReadOnly v2 = face.getVertex(2);
        double radius = largeRadius - smallRadius;
        EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1, (Point3DReadOnly)v2, (double)radius, (Point3DBasics)sphereCenter);
        double radiusSquared = EuclidCoreTools.square((double)radius);
        for (int vertexIndex = 3; vertexIndex < face.getNumberOfEdges(); ++vertexIndex) {
            double distanceSquared = face.getVertex(vertexIndex).distanceSquared((Point3DReadOnly)sphereCenter);
            if (EuclidCoreTools.epsilonEquals((double)radiusSquared, (double)distanceSquared, (double)1.0E-12)) continue;
            return false;
        }
        return true;
    }

    public static List<TriangleMesh3DDefinition> toFaceSubSphere(Face3DReadOnly owner, Vertex3DReadOnly v0, Vertex3DReadOnly v1, Vertex3DReadOnly v2, double largeRadius, double smallRadius, boolean highlightLimits) {
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        Point3D sphereCenter = new Point3D();
        Vector3D limitA = new Vector3D();
        Vector3D limitB = new Vector3D();
        Vector3D limitC = new Vector3D();
        EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1, (Point3DReadOnly)v2, (double)(largeRadius - smallRadius), (Point3DBasics)sphereCenter);
        limitA.sub((Tuple3DReadOnly)v0, (Tuple3DReadOnly)sphereCenter);
        limitB.sub((Tuple3DReadOnly)v1, (Tuple3DReadOnly)sphereCenter);
        limitC.sub((Tuple3DReadOnly)v2, (Tuple3DReadOnly)sphereCenter);
        meshes.add(TriangleMesh3DFactories.toPartialSphereMesh((Point3DReadOnly)sphereCenter, (Tuple3DReadOnly)limitA, (Tuple3DReadOnly)limitB, (Tuple3DReadOnly)limitC, largeRadius, 32));
        if (highlightLimits) {
            meshes.addAll(TriangleMesh3DFactories.toFaceSubSphereLimits(owner, v0, v1, v2, largeRadius, smallRadius, 0.001));
        }
        return meshes;
    }

    public static List<TriangleMesh3DDefinition> toCyclicFaceSphereLimits(Face3DReadOnly face, double largeRadius, double smallRadius, double lineThickness) {
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        Point3D arcCenter = new Point3D();
        Vector3D arcNormal = new Vector3D();
        Vector3D startDirection = new Vector3D();
        Vector3D endDirection = new Vector3D();
        Point3D endpoint = new Point3D();
        Vertex3DReadOnly v0 = face.getVertex(0);
        Vertex3DReadOnly v1 = face.getVertex(1);
        Vertex3DReadOnly v2 = face.getVertex(2);
        double radius = largeRadius - smallRadius;
        EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1, (Point3DReadOnly)v2, (double)radius, (Point3DBasics)arcCenter);
        for (int edgeIndex = 0; edgeIndex < face.getNumberOfEdges(); ++edgeIndex) {
            HalfEdge3DReadOnly edge = face.getEdge(edgeIndex);
            EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)arcCenter, (Point3DReadOnly)edge.getFirstEndpoint(), (Point3DReadOnly)edge.getSecondEndpoint(), (Vector3DBasics)arcNormal);
            startDirection.sub((Tuple3DReadOnly)edge.getFirstEndpoint(), (Tuple3DReadOnly)arcCenter);
            endDirection.sub((Tuple3DReadOnly)edge.getSecondEndpoint(), (Tuple3DReadOnly)arcCenter);
            meshes.addAll(TriangleMesh3DFactories.toSegmentedLine3DMesh((Point3DReadOnly)arcCenter, (Vector3DReadOnly)arcNormal, largeRadius, lineThickness, (Vector3DReadOnly)startDirection, startDirection.angle((Vector3DReadOnly)endDirection), 32, 8));
            endpoint.scaleAdd(largeRadius / startDirection.length(), (Tuple3DReadOnly)startDirection, (Tuple3DReadOnly)arcCenter);
            meshes.add(TriangleMesh3DFactories.translate(TriangleMesh3DFactories.Sphere(lineThickness, 8, 8), (Tuple3DReadOnly)endpoint));
        }
        return meshes;
    }

    private static List<TriangleMesh3DDefinition> toFaceSubSphereLimits(Face3DReadOnly owner, Vertex3DReadOnly v0, Vertex3DReadOnly v1, Vertex3DReadOnly v2, double largeRadius, double smallRadius, double lineThickness) {
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        Point3D arcCenter = new Point3D();
        Vector3D arcNormal = new Vector3D();
        Vector3D startDirection = new Vector3D();
        Vector3D endDirection = new Vector3D();
        Point3D endpoint = new Point3D();
        EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1, (Point3DReadOnly)v2, (double)(largeRadius - smallRadius), (Point3DBasics)arcCenter);
        Vertex3DReadOnly[] vertices = new Vertex3DReadOnly[]{v0, v1, v2};
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            Vertex3DReadOnly start = vertices[vertexIndex];
            Vertex3DReadOnly end = vertices[(vertexIndex + 1) % 3];
            EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)arcCenter, (Point3DReadOnly)start, (Point3DReadOnly)end, (Vector3DBasics)arcNormal);
            startDirection.sub((Tuple3DReadOnly)start, (Tuple3DReadOnly)arcCenter);
            endDirection.sub((Tuple3DReadOnly)end, (Tuple3DReadOnly)arcCenter);
            meshes.addAll(TriangleMesh3DFactories.toSegmentedLine3DMesh((Point3DReadOnly)arcCenter, (Vector3DReadOnly)arcNormal, largeRadius, lineThickness, (Vector3DReadOnly)startDirection, startDirection.angle((Vector3DReadOnly)endDirection), 32, 8));
            endpoint.scaleAdd(largeRadius / startDirection.length(), (Tuple3DReadOnly)startDirection, (Tuple3DReadOnly)arcCenter);
            meshes.add(TriangleMesh3DFactories.translate(TriangleMesh3DFactories.Sphere(lineThickness, 8, 8), (Tuple3DReadOnly)endpoint));
        }
        return meshes;
    }

    public static List<TriangleMesh3DDefinition> toFaceInnerTori(Face3DReadOnly face, double largeRadius, double smallRadius) {
        if (TriangleMesh3DFactories.isFaceCyclicPolygon(face, largeRadius, smallRadius)) {
            return Collections.emptyList();
        }
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        Point3D prevTriangleSphere = new Point3D();
        Point3D nextTriangleSphere = new Point3D();
        Vector3D prevSphereToEdge = new Vector3D();
        Vector3D nextSphereToEdge = new Vector3D();
        Point3D edgeCenter = new Point3D();
        UnitVector3D edgeAxis = new UnitVector3D();
        Vector3D startDirection = new Vector3D();
        Vector3D endDirection = new Vector3D();
        int startIndex = TriangleMesh3DFactories.computeFaceStartIndex(face);
        Vertex3DReadOnly v0 = face.getVertex(startIndex);
        for (int indexOffset = 2; indexOffset < face.getNumberOfEdges() - 1; ++indexOffset) {
            Vertex3DReadOnly v2Prev;
            Vertex3DReadOnly v1Prev = face.getVertex((startIndex + indexOffset - 1) % face.getNumberOfEdges());
            Vertex3DReadOnly v1Next = v2Prev = face.getVertex((startIndex + indexOffset) % face.getNumberOfEdges());
            Vertex3DReadOnly v2Next = face.getVertex((startIndex + indexOffset + 1) % face.getNumberOfEdges());
            EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1Prev, (Point3DReadOnly)v2Prev, (double)(largeRadius - smallRadius), (Point3DBasics)prevTriangleSphere);
            EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1Next, (Point3DReadOnly)v2Next, (double)(largeRadius - smallRadius), (Point3DBasics)nextTriangleSphere);
            edgeCenter.add((Tuple3DReadOnly)v0, (Tuple3DReadOnly)v2Prev);
            edgeCenter.scale(0.5);
            prevSphereToEdge.sub((Tuple3DReadOnly)edgeCenter, (Tuple3DReadOnly)prevTriangleSphere);
            nextSphereToEdge.sub((Tuple3DReadOnly)edgeCenter, (Tuple3DReadOnly)nextTriangleSphere);
            edgeAxis.sub((Tuple3DReadOnly)v2Prev, (Tuple3DReadOnly)v0);
            edgeAxis.negate();
            double endRevolutionAngle = prevSphereToEdge.angle((Vector3DReadOnly)nextSphereToEdge);
            startDirection.sub((Tuple3DReadOnly)v2Prev, (Tuple3DReadOnly)nextTriangleSphere);
            endDirection.sub((Tuple3DReadOnly)v0, (Tuple3DReadOnly)nextTriangleSphere);
            TriangleMesh3DDefinition arcData = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)nextTriangleSphere, largeRadius, (Vector3DReadOnly)startDirection, (Vector3DReadOnly)endDirection, 32);
            meshes.add(TriangleMesh3DFactories.applyRevolution(arcData, (Point3DReadOnly)edgeCenter, (Vector3DReadOnly)edgeAxis, 0.0, endRevolutionAngle, 16, false));
        }
        return meshes;
    }

    public static TriangleMesh3DDefinition toHalfEdgeTorus(HalfEdge3DReadOnly halfEdge, double largeRadius, double smallRadius) {
        Vector3D startDirection = new Vector3D();
        Vector3D endDirection = new Vector3D();
        Vector3D sphereToEdgeA = new Vector3D();
        Vector3D sphereToEdgeB = new Vector3D();
        Point3D neighborSphereCenterA = TriangleMesh3DFactories.computeNeighborFaceSubSphereCenter(halfEdge, largeRadius, smallRadius);
        Point3D neighborSphereCenterB = TriangleMesh3DFactories.computeNeighborFaceSubSphereCenter(halfEdge.getTwin(), largeRadius, smallRadius);
        sphereToEdgeA.sub((Tuple3DReadOnly)halfEdge.midpoint(), (Tuple3DReadOnly)neighborSphereCenterA);
        sphereToEdgeB.sub((Tuple3DReadOnly)halfEdge.midpoint(), (Tuple3DReadOnly)neighborSphereCenterB);
        Vector3DBasics revolutionAxis = halfEdge.getDirection(true);
        revolutionAxis.negate();
        double endRevolutionAngle = sphereToEdgeA.angle((Vector3DReadOnly)sphereToEdgeB);
        startDirection.sub((Tuple3DReadOnly)halfEdge.getDestination(), (Tuple3DReadOnly)neighborSphereCenterA);
        endDirection.sub((Tuple3DReadOnly)halfEdge.getOrigin(), (Tuple3DReadOnly)neighborSphereCenterA);
        TriangleMesh3DDefinition arcData = TriangleMesh3DFactories.toArcPointsAndNormals((Point3DReadOnly)neighborSphereCenterA, largeRadius, (Vector3DReadOnly)startDirection, (Vector3DReadOnly)endDirection, 32);
        return TriangleMesh3DFactories.applyRevolution(arcData, (Point3DReadOnly)halfEdge.midpoint(), (Vector3DReadOnly)revolutionAxis, 0.0, endRevolutionAngle, 16, false);
    }

    private static Point3D computeNeighborFaceSubSphereCenter(HalfEdge3DReadOnly edge, double largeRadius, double smallRadius) {
        Vertex3DReadOnly v2;
        Vertex3DReadOnly v1;
        Point3D neighorSubSphereCenter = new Point3D();
        Face3DReadOnly neighbor = edge.getFace();
        int edgeIndex = neighbor.getEdges().indexOf(edge);
        int neighborStartIndex = TriangleMesh3DFactories.computeFaceStartIndex(neighbor);
        Vertex3DReadOnly v0 = neighbor.getVertex(neighborStartIndex);
        if (edgeIndex == neighborStartIndex) {
            v1 = neighbor.getVertex((neighborStartIndex + 1) % neighbor.getNumberOfEdges());
            v2 = neighbor.getVertex((neighborStartIndex + 2) % neighbor.getNumberOfEdges());
        } else {
            int neighborLastIndex = neighborStartIndex - 1;
            if (neighborLastIndex < 0) {
                neighborLastIndex += neighbor.getNumberOfEdges();
            }
            if (edgeIndex == neighborLastIndex) {
                int neighborSecondToLastIndex = neighborStartIndex - 2;
                if (neighborSecondToLastIndex < 0) {
                    neighborSecondToLastIndex += neighbor.getNumberOfEdges();
                }
                v1 = neighbor.getVertex(neighborSecondToLastIndex);
                v2 = neighbor.getVertex(neighborLastIndex);
            } else {
                v1 = edge.getOrigin();
                v2 = edge.getDestination();
            }
        }
        EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1, (Point3DReadOnly)v2, (double)(largeRadius - smallRadius), (Point3DBasics)neighorSubSphereCenter);
        return neighorSubSphereCenter;
    }

    public static List<TriangleMesh3DDefinition> toVertexSphere(Vertex3DReadOnly vertex, double largeRadius, double smallRadius, boolean addVerticesMesh) {
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        for (int edgeIndex = 0; edgeIndex < vertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
            meshes.add(TriangleMesh3DFactories.toVertexPartialSphere(vertex, vertex.getAssociatedEdge(edgeIndex), largeRadius, smallRadius, addVerticesMesh));
            meshes.addAll(TriangleMesh3DFactories.toVertexPartialSpheres(vertex, vertex.getAssociatedEdge(edgeIndex).getFace(), largeRadius, smallRadius, addVerticesMesh));
        }
        return meshes;
    }

    public static TriangleMesh3DDefinition toVertexPartialSphere(Vertex3DReadOnly vertex, HalfEdge3DReadOnly associatedEdge, double largeRadius, double smallRadius, boolean addVerticesMesh) {
        Vector3D limitC = new Vector3D();
        for (int faceIndex = 0; faceIndex < vertex.getNumberOfAssociatedEdges(); ++faceIndex) {
            limitC.add((Tuple3DReadOnly)TriangleMesh3DFactories.directionNeighborSubSphereToVertex(vertex, vertex.getAssociatedEdge(faceIndex).getFace(), largeRadius, smallRadius));
        }
        limitC.normalize();
        return TriangleMesh3DFactories.toVertexPartialSphere(vertex, (Vector3DReadOnly)limitC, (Point3DReadOnly)associatedEdge.midpoint(), associatedEdge.length(), (Point3DReadOnly)TriangleMesh3DFactories.computeNeighborFaceSubSphereCenter(associatedEdge.getTwin(), largeRadius, smallRadius), (Point3DReadOnly)TriangleMesh3DFactories.computeNeighborFaceSubSphereCenter(associatedEdge, largeRadius, smallRadius), largeRadius, smallRadius, addVerticesMesh);
    }

    public static List<TriangleMesh3DDefinition> toVertexPartialSpheres(Vertex3DReadOnly vertex, Face3DReadOnly neighbor, double largeRadius, double smallRadius, boolean addVerticesMesh) {
        if (TriangleMesh3DFactories.isFaceCyclicPolygon(neighbor, largeRadius, smallRadius)) {
            return Collections.emptyList();
        }
        Vector3D limitC = new Vector3D();
        for (int faceIndex = 0; faceIndex < vertex.getNumberOfAssociatedEdges(); ++faceIndex) {
            limitC.add((Tuple3DReadOnly)TriangleMesh3DFactories.directionNeighborSubSphereToVertex(vertex, vertex.getAssociatedEdge(faceIndex).getFace(), largeRadius, smallRadius));
        }
        limitC.normalize();
        ArrayList<TriangleMesh3DDefinition> meshes = new ArrayList<TriangleMesh3DDefinition>();
        Point3D prevTriangleSphere = new Point3D();
        Point3D nextTriangleSphere = new Point3D();
        Point3D edgeCenter = new Point3D();
        int startIndex = TriangleMesh3DFactories.computeFaceStartIndex(neighbor);
        Vertex3DReadOnly v0 = neighbor.getVertex(startIndex);
        for (int indexOffset = 2; indexOffset < neighbor.getNumberOfEdges() - 1; ++indexOffset) {
            Vertex3DReadOnly v2Prev;
            Vertex3DReadOnly v1Prev = neighbor.getVertex((startIndex + indexOffset - 1) % neighbor.getNumberOfEdges());
            Vertex3DReadOnly v1Next = v2Prev = neighbor.getVertex((startIndex + indexOffset) % neighbor.getNumberOfEdges());
            Vertex3DReadOnly v2Next = neighbor.getVertex((startIndex + indexOffset + 1) % neighbor.getNumberOfEdges());
            EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1Prev, (Point3DReadOnly)v2Prev, (double)(largeRadius - smallRadius), (Point3DBasics)prevTriangleSphere);
            EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)v0, (Point3DReadOnly)v1Next, (Point3DReadOnly)v2Next, (double)(largeRadius - smallRadius), (Point3DBasics)nextTriangleSphere);
            edgeCenter.add((Tuple3DReadOnly)v0, (Tuple3DReadOnly)v2Prev);
            edgeCenter.scale(0.5);
            meshes.add(TriangleMesh3DFactories.toVertexPartialSphere(vertex, (Vector3DReadOnly)limitC, (Point3DReadOnly)edgeCenter, v0.distance((Point3DReadOnly)v2Prev), (Point3DReadOnly)prevTriangleSphere, (Point3DReadOnly)nextTriangleSphere, largeRadius, smallRadius, addVerticesMesh));
        }
        return meshes;
    }

    public static TriangleMesh3DDefinition toVertexPartialSphere(Vertex3DReadOnly vertex, Vector3DReadOnly limitC, Point3DReadOnly commonEdgeCenter, double commonEdgeLength, Point3DReadOnly sphereA, Point3DReadOnly sphereB, double largeRadius, double smallRadius, boolean addVerticesMesh) {
        Vector3D sphereAToEdge = new Vector3D();
        sphereAToEdge.sub((Tuple3DReadOnly)commonEdgeCenter, (Tuple3DReadOnly)sphereA);
        sphereAToEdge.normalize();
        Vector3D sphereBToEdge = new Vector3D();
        sphereBToEdge.sub((Tuple3DReadOnly)commonEdgeCenter, (Tuple3DReadOnly)sphereB);
        sphereBToEdge.normalize();
        Vector3D testWinding = new Vector3D();
        testWinding.cross((Tuple3DReadOnly)sphereAToEdge, (Tuple3DReadOnly)sphereBToEdge);
        boolean flip = testWinding.dot((Tuple3DReadOnly)limitC) > 0.0;
        double radius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)commonEdgeLength);
        Vector3D sphereToEdge = new Vector3D();
        Point3D sphereCenter = new Point3D();
        Vector3D limitAB = new Vector3D();
        DoubleFunction<Vector3D> limitABFunction = alpha -> {
            if (flip) {
                alpha = 1.0 - alpha;
            }
            sphereToEdge.interpolate((Tuple3DReadOnly)sphereAToEdge, (Tuple3DReadOnly)sphereBToEdge, alpha);
            sphereToEdge.scale(radius / sphereToEdge.length());
            sphereCenter.sub((Tuple3DReadOnly)commonEdgeCenter, (Tuple3DReadOnly)sphereToEdge);
            limitAB.sub((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)sphereCenter);
            limitAB.normalize();
            return limitAB;
        };
        return TriangleMesh3DFactories.toPartialSphereMesh((Point3DReadOnly)vertex, limitABFunction, (Tuple3DReadOnly)limitC, smallRadius, 16, false);
    }

    private static Vector3DReadOnly directionNeighborSubSphereToVertex(Vertex3DReadOnly vertex, Face3DReadOnly neighbor, double largeRadius, double smallRadius) {
        int edgeIndex = neighbor.getVertices().indexOf(vertex);
        Vector3D direction = new Vector3D();
        direction.sub((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)TriangleMesh3DFactories.computeNeighborFaceSubSphereCenter(neighbor.getEdge(edgeIndex), largeRadius, smallRadius));
        return direction;
    }

    public static List<TriangleMesh3DDefinition> toSegmentedLine3DMesh(Point3DReadOnly arcCenter, Vector3DReadOnly arcNormal, double arcRadius, double thickness, Vector3DReadOnly startDirection, double angleSpan, int resolution, int radialResolution) {
        SegmentedLine3DTriangleMeshFactory generator = new SegmentedLine3DTriangleMeshFactory(resolution, radialResolution);
        AxisAngle axisAngle = new AxisAngle(arcNormal, 0.0);
        Vector3D direction = new Vector3D();
        Point3D[] points = new Point3D[resolution];
        for (int i = 0; i < resolution; ++i) {
            axisAngle.setAngle(angleSpan * (double)i / ((double)resolution - 1.0));
            axisAngle.transform((Tuple3DReadOnly)startDirection, (Tuple3DBasics)direction);
            direction.normalize();
            Point3D point = new Point3D();
            point.scaleAdd(arcRadius, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)arcCenter);
            points[i] = point;
        }
        generator.setLineRadius(thickness);
        generator.compute((Point3DReadOnly[])points);
        return Arrays.asList(generator.getTriangleMesh3DDefinitions());
    }

    public static TriangleMesh3DDefinition toPartialSphereMesh(Point3DReadOnly sphereCenter, Tuple3DReadOnly limitA, Tuple3DReadOnly limitB, Tuple3DReadOnly limitC, double sphereRadius, int resolution) {
        return TriangleMesh3DFactories.toPartialSphereMesh(sphereCenter, limitA, limitB, limitC, sphereRadius, resolution, false);
    }

    public static TriangleMesh3DDefinition toPartialSphereMesh(Point3DReadOnly sphereCenter, Tuple3DReadOnly limitA, Tuple3DReadOnly limitB, Tuple3DReadOnly limitC, double sphereRadius, int resolution, boolean addVerticesMesh) {
        return TriangleMesh3DFactories.toPartialSphereMesh(sphereCenter, (double alpha) -> TriangleMesh3DFactories.interpolateVector3D(limitA, limitB, alpha), (double alpha) -> TriangleMesh3DFactories.interpolateVector3D(limitB, limitC, alpha), (double alpha) -> TriangleMesh3DFactories.interpolateVector3D(limitC, limitA, alpha), sphereRadius, resolution, addVerticesMesh);
    }

    public static TriangleMesh3DDefinition toPartialSphereMesh(Point3DReadOnly sphereCenter, DoubleFunction<? extends Tuple3DReadOnly> limitABFunction, Tuple3DReadOnly limitC, double sphereRadius, int resolution, boolean addVerticesMesh) {
        Vector3D limitA = new Vector3D(limitABFunction.apply(0.0));
        Vector3D limitB = new Vector3D(limitABFunction.apply(1.0));
        limitA.normalize();
        limitB.normalize();
        return TriangleMesh3DFactories.toPartialSphereMesh(sphereCenter, limitABFunction, (double alpha) -> TriangleMesh3DFactories.interpolateVector3D((Tuple3DReadOnly)limitB, limitC, alpha), (double alpha) -> TriangleMesh3DFactories.interpolateVector3D(limitC, (Tuple3DReadOnly)limitA, alpha), sphereRadius, resolution, addVerticesMesh);
    }

    public static TriangleMesh3DDefinition toPartialSphereMesh(Point3DReadOnly sphereCenter, DoubleFunction<? extends Tuple3DReadOnly> limitABFunction, DoubleFunction<? extends Tuple3DReadOnly> limitBCFunction, DoubleFunction<? extends Tuple3DReadOnly> limitCAFunction, double sphereRadius, int resolution, boolean addVerticesMesh) {
        ArrayList<Point3D32> points = new ArrayList<Point3D32>();
        ArrayList<Vector3D32> normals = new ArrayList<Vector3D32>();
        ArrayList<Point2D32> textPoints = new ArrayList<Point2D32>();
        Point3D limitAB = new Point3D();
        for (int longitude = 0; longitude < resolution - 1; ++longitude) {
            double longitudeAlpha = (double)longitude / ((double)resolution - 1.0);
            int latitudeResolution = (int)Math.round(EuclidCoreTools.interpolate((double)resolution, (double)1.0, (double)longitudeAlpha));
            Vector3D32 direction = new Vector3D32();
            direction.set(limitCAFunction.apply(1.0 - longitudeAlpha));
            direction.normalize();
            Point3D32 point = new Point3D32();
            point.scaleAdd(sphereRadius, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphereCenter);
            points.add(point);
            normals.add(direction);
            textPoints.add(new Point2D32((float)longitudeAlpha, 0.0f));
            for (int latitude = 1; latitude < latitudeResolution - 1; ++latitude) {
                double latitudeAlpha = (double)latitude / ((double)latitudeResolution - 1.0);
                limitAB.set(limitABFunction.apply(latitudeAlpha));
                Vector3D32 direction2 = new Vector3D32();
                direction2.interpolate((Tuple3DReadOnly)limitAB, limitCAFunction.apply(0.0), longitudeAlpha);
                direction2.normalize();
                Point3D32 point2 = new Point3D32();
                point2.scaleAdd(sphereRadius, (Tuple3DReadOnly)direction2, (Tuple3DReadOnly)sphereCenter);
                points.add(point2);
                normals.add(direction2);
                textPoints.add(new Point2D32((float)longitudeAlpha, (float)latitudeAlpha));
            }
            direction = new Vector3D32();
            direction.set(limitBCFunction.apply(longitudeAlpha));
            direction.normalize();
            point = new Point3D32();
            point.scaleAdd(sphereRadius, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphereCenter);
            points.add(point);
            normals.add(direction);
            textPoints.add(new Point2D32((float)longitudeAlpha, 1.0f));
        }
        Vector3D32 direction = new Vector3D32();
        direction.set(limitCAFunction.apply(0.0));
        direction.normalize();
        Point3D32 point = new Point3D32();
        point.scaleAdd(sphereRadius, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)sphereCenter);
        points.add(point);
        normals.add(direction);
        textPoints.add(new Point2D32(1.0f, 1.0f));
        TIntArrayList triangleIndices = new TIntArrayList();
        int nextLatitudeResolution = resolution;
        int longitudeStartIndex = 0;
        for (int longitude = 0; longitude < resolution - 1; ++longitude) {
            int latitudeResolution = nextLatitudeResolution;
            nextLatitudeResolution = (int)Math.round(EuclidCoreTools.interpolate((double)resolution, (double)1.0, (double)(((double)longitude + 1.0) / ((double)resolution - 1.0))));
            int nextLongitudeStartIndex = longitudeStartIndex + latitudeResolution;
            for (int latitude = 0; latitude < latitudeResolution - 1; ++latitude) {
                if (latitude < nextLatitudeResolution) {
                    triangleIndices.add(longitudeStartIndex + latitude);
                    triangleIndices.add(nextLongitudeStartIndex + latitude);
                    triangleIndices.add(longitudeStartIndex + latitude + 1);
                }
                if (latitude >= nextLatitudeResolution - 1) continue;
                triangleIndices.add(nextLongitudeStartIndex + latitude);
                triangleIndices.add(nextLongitudeStartIndex + latitude + 1);
                triangleIndices.add(longitudeStartIndex + latitude + 1);
            }
            longitudeStartIndex += latitudeResolution;
        }
        TriangleMesh3DDefinition partialSphereMesh = new TriangleMesh3DDefinition(points.toArray(new Point3D32[0]), textPoints.toArray(new Point2D32[0]), normals.toArray(new Vector3D32[0]), triangleIndices.toArray());
        if (!addVerticesMesh) {
            return partialSphereMesh;
        }
        TriangleMesh3DDefinition[] meshes = new TriangleMesh3DDefinition[1 + points.size()];
        meshes[0] = partialSphereMesh;
        for (int i = 0; i < points.size(); ++i) {
            meshes[i + 1] = TriangleMesh3DFactories.translate(TriangleMesh3DFactories.Tetrahedron(0.005), (Tuple3DReadOnly)points.get(i));
        }
        return TriangleMesh3DFactories.combine(true, false, meshes);
    }

    public static TriangleMesh3DDefinition toArcPointsAndNormals(Point3DReadOnly arcPosition, double arcRadius, Vector3DReadOnly startDirection, Vector3DReadOnly endDirection, int resolution) {
        Point3D32[] points = new Point3D32[resolution];
        Vector3D32[] normals = new Vector3D32[resolution];
        for (int i = 0; i < resolution; ++i) {
            double alpha = (double)i / ((double)resolution - 1.0);
            Vector3D32 direction = new Vector3D32();
            direction.interpolate((Tuple3DReadOnly)startDirection, (Tuple3DReadOnly)endDirection, alpha);
            direction.normalize();
            Point3D32 point = new Point3D32();
            point.scaleAdd(arcRadius, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)arcPosition);
            points[i] = point;
            normals[i] = direction;
        }
        return new TriangleMesh3DDefinition(points, null, normals, null);
    }

    public static TriangleMesh3DDefinition applyRevolution(TriangleMesh3DDefinition subMesh, Point3DReadOnly rotationCenter, Vector3DReadOnly rotationAxis, double startAngle, double endAngle, int resolution, boolean addVerticesMesh) {
        int subMeshSize = subMesh.getVertices().length;
        Point3D32[] points = new Point3D32[resolution * subMeshSize];
        Vector3D32[] normals = new Vector3D32[resolution * subMeshSize];
        Point2D32[] textPoints = new Point2D32[resolution * subMeshSize];
        AxisAngle rotation = new AxisAngle();
        rotation.getAxis().set((Tuple3DReadOnly)rotationAxis);
        for (int revIndex = 0; revIndex < resolution; ++revIndex) {
            double angle = EuclidCoreTools.interpolate((double)startAngle, (double)endAngle, (double)((double)revIndex / ((double)resolution - 1.0)));
            rotation.setAngle(angle);
            for (int meshIndex = 0; meshIndex < subMeshSize; ++meshIndex) {
                Point3D32 point = new Point3D32((Tuple3DReadOnly)subMesh.getVertices()[meshIndex]);
                Vector3D32 normal = new Vector3D32((Tuple3DReadOnly)subMesh.getNormals()[meshIndex]);
                point.sub((Tuple3DReadOnly)rotationCenter);
                rotation.transform((Tuple3DBasics)point);
                rotation.transform((Tuple3DBasics)normal);
                point.add((Tuple3DReadOnly)rotationCenter);
                points[revIndex * subMeshSize + meshIndex] = point;
                normals[revIndex * subMeshSize + meshIndex] = normal;
                textPoints[revIndex * subMeshSize + meshIndex] = new Point2D32((float)revIndex / ((float)resolution - 1.0f), (float)meshIndex / ((float)subMeshSize - 1.0f));
            }
        }
        int numberOfTriangles = 2 * resolution * subMeshSize;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int revIndex = 0; revIndex < resolution - 1; ++revIndex) {
            for (int meshIndex = 0; meshIndex < subMeshSize - 1; ++meshIndex) {
                int nextRevIndex = revIndex + 1;
                int nextMeshIndex = meshIndex + 1;
                triangleIndices[index++] = nextRevIndex * subMeshSize + meshIndex;
                triangleIndices[index++] = nextRevIndex * subMeshSize + nextMeshIndex;
                triangleIndices[index++] = revIndex * subMeshSize + nextMeshIndex;
                triangleIndices[index++] = nextRevIndex * subMeshSize + meshIndex;
                triangleIndices[index++] = revIndex * subMeshSize + nextMeshIndex;
                triangleIndices[index++] = revIndex * subMeshSize + meshIndex;
            }
        }
        TriangleMesh3DDefinition partialSphereMesh = new TriangleMesh3DDefinition(points, textPoints, normals, triangleIndices);
        if (!addVerticesMesh) {
            return partialSphereMesh;
        }
        TriangleMesh3DDefinition[] meshes = new TriangleMesh3DDefinition[1 + points.length];
        meshes[0] = partialSphereMesh;
        for (int i = 0; i < points.length; ++i) {
            meshes[i + 1] = TriangleMesh3DFactories.translate(TriangleMesh3DFactories.Tetrahedron(0.005), (Tuple3DReadOnly)points[i]);
        }
        return TriangleMesh3DFactories.combine(true, false, meshes);
    }

    public static TriangleMesh3DDefinition rotate(TriangleMesh3DDefinition in, Orientation3DReadOnly rotation) {
        for (Point3D32 point3D32 : in.getVertices()) {
            rotation.transform((Tuple3DBasics)point3D32);
        }
        for (Point3D32 point3D32 : in.getNormals()) {
            rotation.transform((Tuple3DBasics)point3D32);
        }
        return in;
    }

    public static TriangleMesh3DDefinition translate(TriangleMesh3DDefinition in, Tuple3DReadOnly translation) {
        for (Point3D32 vertex : in.getVertices()) {
            vertex.add(translation);
        }
        return in;
    }

    public static TriangleMesh3DDefinition combine(boolean adjustTriangleIndices, boolean deepCopy, TriangleMesh3DDefinition ... definitions) {
        return TriangleMesh3DFactories.combine(adjustTriangleIndices, deepCopy, Arrays.asList(definitions));
    }

    public static TriangleMesh3DDefinition combine(boolean adjustTriangleIndices, boolean deepCopy, Collection<TriangleMesh3DDefinition> definitions) {
        int outVertexSize = 0;
        int outTextureSize = 0;
        int outNormalSize = 0;
        int outIndexSize = 0;
        for (TriangleMesh3DDefinition definition : definitions) {
            outVertexSize += definition.getVertices() != null ? definition.getVertices().length : 0;
            outTextureSize += definition.getTextures() != null ? definition.getTextures().length : 0;
            outNormalSize += definition.getNormals() != null ? definition.getNormals().length : 0;
            outIndexSize += definition.getTriangleIndices() != null ? definition.getTriangleIndices().length : 0;
        }
        Point3D32[] outVertices = new Point3D32[outVertexSize];
        Point2D32[] outTextures = new Point2D32[outTextureSize];
        Vector3D32[] outNormals = new Vector3D32[outNormalSize];
        int[] outIndices = new int[outIndexSize];
        int vertexIndex = 0;
        int textureIndex = 0;
        int normalIndex = 0;
        int indexIndex = 0;
        for (TriangleMesh3DDefinition definition : definitions) {
            Point3D32[] inVertices = definition.getVertices();
            Point2D32[] inTextures = definition.getTextures();
            Vector3D32[] inNormals = definition.getNormals();
            int[] inIndices = definition.getTriangleIndices();
            if (inVertices != null) {
                if (deepCopy) {
                    for (Point3D32 point3D32 : inVertices) {
                        outVertices[vertexIndex++] = new Point3D32((Tuple3DReadOnly)point3D32);
                    }
                } else {
                    System.arraycopy(inVertices, 0, outVertices, vertexIndex, inVertices.length);
                    vertexIndex += inVertices.length;
                }
            }
            if (inTextures != null) {
                if (deepCopy) {
                    for (Point3D32 point3D32 : inTextures) {
                        outTextures[textureIndex++] = new Point2D32((Tuple2DReadOnly)point3D32);
                    }
                } else {
                    System.arraycopy(inTextures, 0, outTextures, textureIndex, inTextures.length);
                    textureIndex += inTextures.length;
                }
            }
            if (inNormals != null) {
                if (deepCopy) {
                    for (Point3D32 point3D32 : inNormals) {
                        outNormals[normalIndex++] = new Vector3D32((Tuple3DReadOnly)point3D32);
                    }
                } else {
                    System.arraycopy(inNormals, 0, outNormals, normalIndex, inNormals.length);
                    normalIndex += inNormals.length;
                }
            }
            if (inIndices == null) continue;
            System.arraycopy(inIndices, 0, outIndices, indexIndex, inIndices.length);
            indexIndex += inIndices.length;
        }
        if (adjustTriangleIndices && definitions.size() > 1) {
            TriangleMesh3DDefinition definition;
            Iterator<TriangleMesh3DDefinition> iterator = definitions.iterator();
            definition = iterator.next();
            int shift = definition.getVertices().length;
            int startIndex = definition.getTriangleIndices().length;
            while (iterator.hasNext()) {
                definition = iterator.next();
                int endIndex = startIndex + definition.getTriangleIndices().length;
                int i = startIndex;
                while (i < endIndex) {
                    int n = i++;
                    outIndices[n] = outIndices[n] + shift;
                }
                shift += definition.getVertices().length;
                startIndex = endIndex;
            }
        }
        return new TriangleMesh3DDefinition(outVertices, outTextures, outNormals, outIndices);
    }

    public static Vector3D newOrthogonalVector(Vector3DReadOnly referenceVector) {
        Vector3D orthogonal = new Vector3D();
        if (Math.abs(referenceVector.getY()) > 0.1 || Math.abs(referenceVector.getZ()) > 0.1) {
            orthogonal.set(1.0, 0.0, 0.0);
        } else {
            orthogonal.set(0.0, 1.0, 0.0);
        }
        orthogonal.cross((Tuple3DReadOnly)referenceVector);
        orthogonal.normalize();
        return orthogonal;
    }

    public static Vector3D interpolateVector3D(Tuple3DReadOnly tuple0, Tuple3DReadOnly tuplef, double alpha) {
        Vector3D interpolated = new Vector3D();
        interpolated.interpolate(tuple0, tuplef, alpha);
        return interpolated;
    }

    public static void reverse(Object[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            Object oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }
}

