/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;

@XmlRootElement(name="Robot")
public class RobotDefinition {
    public static final JointCreator DEFAULT_JOINT_BUILDER = (predecessor, definition) -> definition.toJoint(predecessor);
    public static final RootBodyCreator DEFAUL_ROOT_BODY_BUILDER = (rootFrame, definition) -> definition.toRootBody(rootFrame);
    public static final RigidBodyCreator DEFAUL_RIGID_BODY_BUILDER = (parentJoint, definition) -> definition.toRigidBody(parentJoint);
    private String name;
    private RigidBodyDefinition rootBodyDefinition;
    private List<String> nameOfJointsToIgnore = new ArrayList<String>();
    private final List<ControllerDefinition> controllerDefinitions = new ArrayList<ControllerDefinition>();
    private ClassLoader resourceClassLoader;

    public RobotDefinition() {
    }

    public RobotDefinition(String name) {
        this.setName(name);
    }

    public RobotDefinition(RobotDefinition other) {
        this.name = other.name;
        this.rootBodyDefinition = other.rootBodyDefinition == null ? null : other.rootBodyDefinition.copyRecursive();
        for (JointDefinition jointDefinition : this.getAllJoints()) {
            if (!jointDefinition.isLoopClosure()) continue;
            String successorName = other.getJointDefinition(jointDefinition.getName()).getSuccessor().getName();
            RigidBodyDefinition rigidBodyDefinition = this.getRigidBodyDefinition(successorName);
            jointDefinition.setLoopClosureSuccessor(rigidBodyDefinition);
        }
        this.nameOfJointsToIgnore.addAll(other.nameOfJointsToIgnore);
        this.resourceClassLoader = other.resourceClassLoader;
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="rootBody")
    public void setRootBodyDefinition(RigidBodyDefinition rootBodyDefinition) {
        this.rootBodyDefinition = rootBodyDefinition;
    }

    public void ignoreAllJoints() {
        for (JointDefinition jointDefinition : RobotDefinition.collectSubtreeJointDefinitions(this.rootBodyDefinition)) {
            this.addJointToIgnore(jointDefinition.getName());
        }
    }

    @XmlElement(name="jointToIgnore")
    public void setNameOfJointsToIgnore(List<String> nameOfJointsToIgnore) {
        this.nameOfJointsToIgnore = nameOfJointsToIgnore;
    }

    public void addJointToIgnore(String nameOfJointToIgnore) {
        this.nameOfJointsToIgnore.add(nameOfJointToIgnore);
    }

    public void addSubtreeJointsToIgnore(String nameOfLastJointToConsider) {
        List<JointDefinition> definitionOfJointsToIgnore = RobotDefinition.collectSubtreeJointDefinitions(this.getJointDefinition(nameOfLastJointToConsider).getSuccessor());
        for (JointDefinition jointDefinition : definitionOfJointsToIgnore) {
            this.nameOfJointsToIgnore.add(jointDefinition.getName());
        }
    }

    public void addControllerDefinition(ControllerDefinition controllerDefinition) {
        this.controllerDefinitions.add(controllerDefinition);
    }

    @XmlTransient
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public String getName() {
        return this.name;
    }

    public RigidBodyDefinition getRootBodyDefinition() {
        return this.rootBodyDefinition;
    }

    public List<JointDefinition> getRootJointDefinitions() {
        return this.rootBodyDefinition.getChildrenJoints();
    }

    public List<String> getNameOfJointsToIgnore() {
        return this.nameOfJointsToIgnore;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public JointDefinition getJointDefinition(String jointName) {
        return RobotDefinition.findJointDefinition(this.rootBodyDefinition, jointName);
    }

    public OneDoFJointDefinition getOneDoFJointDefinition(String jointName) {
        JointDefinition jointDefinition = this.getJointDefinition(jointName);
        if (jointDefinition instanceof OneDoFJointDefinition) {
            return (OneDoFJointDefinition)jointDefinition;
        }
        return null;
    }

    public RigidBodyDefinition getRigidBodyDefinition(String bodyName) {
        return RobotDefinition.findRigidBodyDefinition(this.rootBodyDefinition, bodyName);
    }

    public void forEachJointDefinition(Consumer<JointDefinition> jointConsumer) {
        RobotDefinition.forEachJointDefinition(this.rootBodyDefinition, jointConsumer);
    }

    public void forEachOneDoFJointDefinition(Consumer<OneDoFJointDefinition> jointConsumer) {
        RobotDefinition.forEachJointDefinition(this.rootBodyDefinition, joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                jointConsumer.accept((OneDoFJointDefinition)joint);
            }
        });
    }

    public void forEachRigidBodyDefinition(Consumer<RigidBodyDefinition> rigidBodyConsumer) {
        RobotDefinition.forEachRigidBodyDefinition(this.rootBodyDefinition, rigidBodyConsumer);
    }

    public List<JointDefinition> getAllJoints() {
        ArrayList<JointDefinition> joints = new ArrayList<JointDefinition>();
        this.forEachJointDefinition(joints::add);
        return joints;
    }

    public List<OneDoFJointDefinition> getAllOneDoFJoints() {
        ArrayList<OneDoFJointDefinition> joints = new ArrayList<OneDoFJointDefinition>();
        this.forEachOneDoFJointDefinition(joints::add);
        return joints;
    }

    public List<RigidBodyDefinition> getAllRigidBodies() {
        return RobotDefinition.collectSubtreeRigidBodyDefinitions(this.rootBodyDefinition);
    }

    public List<ControllerDefinition> getControllerDefinitions() {
        return this.controllerDefinitions;
    }

    public RigidBodyBasics newInstance(ReferenceFrame rootFrame) {
        return this.newInstance(rootFrame, DEFAUL_ROOT_BODY_BUILDER, DEFAULT_JOINT_BUILDER, DEFAUL_RIGID_BODY_BUILDER);
    }

    public RigidBodyBasics newInstance(ReferenceFrame rootFrame, RootBodyCreator rootBodyCreator, JointCreator jointCreator, RigidBodyCreator rigidBodyCreator) {
        if (this.rootBodyDefinition == null) {
            throw new NullPointerException("The robot " + this.name + " has no definition!");
        }
        RigidBodyBasics rootBody = rootBodyCreator.newRootBody(rootFrame, this.rootBodyDefinition);
        this.instantiateRecursively(rootBody, this.rootBodyDefinition, jointCreator, rigidBodyCreator);
        RobotDefinition.closeLoops(rootBody, this.rootBodyDefinition);
        return rootBody;
    }

    private void instantiateRecursively(RigidBodyBasics predecessor, RigidBodyDefinition predecessorDefinition, JointCreator jointCreator, RigidBodyCreator rigidBodyCreator) {
        for (JointDefinition childDefinition : predecessorDefinition.getChildrenJoints()) {
            JointBasics child = jointCreator.newJoint(predecessor, childDefinition);
            if (childDefinition.isLoopClosure()) continue;
            RigidBodyDefinition successorDefinition = childDefinition.getSuccessor();
            if (successorDefinition == null) {
                throw new NullPointerException("The joint " + child.getName() + " is missing the definition for its successor, robot name: " + this.name + ".");
            }
            RigidBodyBasics successor = rigidBodyCreator.newRigidBody(child, successorDefinition);
            this.instantiateRecursively(successor, successorDefinition, jointCreator, rigidBodyCreator);
        }
    }

    public static void closeLoops(RigidBodyBasics predecessor, RigidBodyDefinition predecessorDefinition) {
        if (predecessor == null) {
            return;
        }
        for (int i = 0; i < predecessor.getChildrenJoints().size(); ++i) {
            JointBasics joint = (JointBasics)predecessor.getChildrenJoints().get(i);
            JointDefinition jointDefinition = predecessorDefinition.getChildrenJoints().get(i);
            if (jointDefinition.isLoopClosure()) {
                RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)predecessor);
                RigidBodyBasics successor = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)jointDefinition.getSuccessor().getName());
                YawPitchRollTransformDefinition transformFromSuccessorParentJoint = jointDefinition.getLoopClosureDefinition().getTransformToSuccessorParent();
                joint.setupLoopClosure(successor, (RigidBodyTransformReadOnly)transformFromSuccessorParentJoint);
            }
            RobotDefinition.closeLoops(joint.getSuccessor(), jointDefinition.getSuccessor());
        }
    }

    public static List<JointDefinition> collectSubtreeJointDefinitions(RigidBodyDefinition start) {
        ArrayList<JointDefinition> joints = new ArrayList<JointDefinition>();
        RobotDefinition.forEachJointDefinition(start, joints::add);
        return joints;
    }

    public static List<RigidBodyDefinition> collectSubtreeRigidBodyDefinitions(RigidBodyDefinition start) {
        ArrayList<RigidBodyDefinition> rigidBodies = new ArrayList<RigidBodyDefinition>();
        RobotDefinition.forEachRigidBodyDefinition(start, rigidBodies::add);
        return rigidBodies;
    }

    public static JointDefinition findJointDefinition(RigidBodyDefinition start, String jointName) {
        if (start == null) {
            return null;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = start.getChildrenJoints().get(i);
            if (jointDefinition.getName().equals(jointName)) {
                return jointDefinition;
            }
            JointDefinition result = RobotDefinition.findJointDefinition(jointDefinition.getSuccessor(), jointName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void initializeRobotState(RobotDefinition robotDefinition, RigidBodyBasics rootBody) {
        RobotDefinition.initializeRobotStateRecursive(robotDefinition.getRootBodyDefinition(), rootBody);
    }

    private static void initializeRobotStateRecursive(RigidBodyDefinition definition, RigidBodyBasics rigidBody) {
        if (definition.getChildrenJoints().size() != rigidBody.getChildrenJoints().size()) {
            throw new IllegalArgumentException("Robot mismatch at rigid-body: " + definition.getName());
        }
        for (int i = 0; i < definition.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = definition.getChildrenJoints().get(i);
            JointBasics joint = (JointBasics)rigidBody.getChildrenJoints().get(i);
            if (!jointDefinition.getName().equals(joint.getName())) {
                throw new IllegalArgumentException("Definition incompatible with robot. Expected joint: " + definition.getName() + ", was: " + joint.getName());
            }
            JointStateBasics initialJointState = jointDefinition.getInitialJointState();
            if (initialJointState != null) {
                if (initialJointState.hasOutputFor(JointStateType.CONFIGURATION)) {
                    initialJointState.getConfiguration(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.VELOCITY)) {
                    initialJointState.getVelocity(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.ACCELERATION)) {
                    initialJointState.getAcceleration(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.EFFORT)) {
                    initialJointState.getEffort(joint);
                }
            }
            RobotDefinition.initializeRobotStateRecursive(jointDefinition.getSuccessor(), joint.getSuccessor());
        }
    }

    public static RigidBodyDefinition findRigidBodyDefinition(RigidBodyDefinition start, String rigidBodyName) {
        if (start == null) {
            return null;
        }
        if (start.getName().equals(rigidBodyName)) {
            return start;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            RigidBodyDefinition result = RobotDefinition.findRigidBodyDefinition(start.getChildrenJoints().get(i).getSuccessor(), rigidBodyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void forEachJointDefinition(RigidBodyDefinition start, Consumer<JointDefinition> jointConsumer) {
        if (start == null) {
            return;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = start.getChildrenJoints().get(i);
            jointConsumer.accept(jointDefinition);
            RobotDefinition.forEachJointDefinition(jointDefinition.getSuccessor(), jointConsumer);
        }
    }

    public static void forEachRigidBodyDefinition(RigidBodyDefinition start, Consumer<RigidBodyDefinition> rigidBodyConsumer) {
        if (start == null) {
            return;
        }
        rigidBodyConsumer.accept(start);
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            RobotDefinition.forEachRigidBodyDefinition(start.getChildrenJoints().get(i).getSuccessor(), rigidBodyConsumer);
        }
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.rootBodyDefinition);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.nameOfJointsToIgnore);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.controllerDefinitions);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RobotDefinition other = (RobotDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.rootBodyDefinition, other.rootBodyDefinition)) {
            return false;
        }
        if (!Objects.equals(this.nameOfJointsToIgnore, other.nameOfJointsToIgnore)) {
            return false;
        }
        return Objects.equals(this.controllerDefinitions, other.controllerDefinitions);
    }

    public static interface RootBodyCreator {
        public RigidBodyBasics newRootBody(ReferenceFrame var1, RigidBodyDefinition var2);
    }

    public static interface JointCreator {
        public JointBasics newJoint(RigidBodyBasics var1, JointDefinition var2);
    }

    public static interface RigidBodyCreator {
        public RigidBodyBasics newRigidBody(JointBasics var1, RigidBodyDefinition var2);
    }
}

