/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.collision;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class CollisionShapeDefinition {
    private String name;
    private YawPitchRollTransformDefinition originPose = new YawPitchRollTransformDefinition();
    private GeometryDefinition geometryDefinition;
    private boolean isConcave = false;
    private long collisionMask = -1L;
    private long collisionGroup = -1L;

    public CollisionShapeDefinition() {
    }

    public CollisionShapeDefinition(GeometryDefinition geometryDefinition) {
        this.geometryDefinition = geometryDefinition;
    }

    public CollisionShapeDefinition(RigidBodyTransformReadOnly originPose, GeometryDefinition geometryDefinition) {
        this(new YawPitchRollTransformDefinition(originPose), geometryDefinition);
    }

    public CollisionShapeDefinition(YawPitchRollTransformDefinition originPose, GeometryDefinition geometryDefinition) {
        this.originPose = originPose;
        this.geometryDefinition = geometryDefinition;
    }

    public CollisionShapeDefinition(CollisionShapeDefinition other) {
        this.name = other.name;
        this.originPose.set((RigidBodyTransformReadOnly)other.originPose);
        if (other.geometryDefinition != null) {
            this.geometryDefinition = other.geometryDefinition.copy();
        }
    }

    @XmlElement
    public void setName(String name) {
        this.name = name;
    }

    public void setOriginPose(RigidBodyTransformReadOnly originPose) {
        this.originPose.set(originPose);
    }

    @XmlElement
    public void setOriginPose(YawPitchRollTransformDefinition originPose) {
        this.originPose = originPose;
    }

    @XmlElement
    public void setGeometryDefinition(GeometryDefinition geometryDefinition) {
        this.geometryDefinition = geometryDefinition;
    }

    @XmlElement
    public void setCollisionMask(long collisionMask) {
        this.collisionMask = collisionMask;
    }

    @XmlElement
    public void setCollisionGroup(long collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public String getName() {
        return this.name;
    }

    public YawPitchRollTransformDefinition getOriginPose() {
        return this.originPose;
    }

    public GeometryDefinition getGeometryDefinition() {
        return this.geometryDefinition;
    }

    public void setConcave(boolean concave) {
        this.isConcave = concave;
    }

    public boolean isConcave() {
        return this.isConcave;
    }

    public long getCollisionMask() {
        return this.collisionMask;
    }

    public long getCollisionGroup() {
        return this.collisionGroup;
    }

    public CollisionShapeDefinition copy() {
        return new CollisionShapeDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.originPose);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.geometryDefinition);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.isConcave);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (long)this.collisionMask);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (long)this.collisionGroup);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CollisionShapeDefinition other = (CollisionShapeDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.originPose, other.originPose)) {
            return false;
        }
        if (!Objects.equals(this.geometryDefinition, other.geometryDefinition)) {
            return false;
        }
        if (!this.isConcave != other.isConcave) {
            return false;
        }
        if (this.collisionMask != other.collisionMask) {
            return false;
        }
        return this.collisionGroup == other.collisionGroup;
    }

    public String toString() {
        return "CollisionShapeDefinition [name=" + this.name + ", originPose=" + this.originPose + ", geometryDefinition=" + this.geometryDefinition + ", isConcave=" + this.isConcave + ", collisionMask=" + this.collisionMask + ", collisionGroup=" + this.collisionGroup + "]";
    }
}

