/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Tetrahedron3DDefinition;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;

public class TriangleMesh3DBuilder {
    private final MutableTriangleMesh3DData triangleMesh = new MutableTriangleMesh3DData();

    public TriangleMesh3DBuilder() {
        this.clear();
    }

    public void addTriangleMesh3D(TriangleMesh3DBuilder other) {
        this.triangleMesh.add(other.triangleMesh, true);
    }

    public void addTriangleMesh3D(TriangleMesh3DBuilder other, Tuple3DReadOnly offset) {
        this.triangleMesh.add(other.triangleMesh, offset, null, true);
    }

    public void addTriangleMesh3D(TriangleMesh3DBuilder other, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.triangleMesh.add(other.triangleMesh, offset, orientation, true);
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh) {
        this.triangleMesh.add(triangleMesh, true);
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh, Tuple3DReadOnly offset) {
        this.triangleMesh.add(triangleMesh, offset, null, true);
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.triangleMesh.add(triangleMesh, offset, orientation, true);
    }

    public void addGeometry(GeometryDefinition geometry, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.triangleMesh.add(TriangleMesh3DFactories.TriangleMesh(geometry), offset, orientation, true);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ) {
        this.addBox(sizeX, sizeY, sizeZ, null, null);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ, Tuple3DReadOnly offset) {
        this.addBox(sizeX, sizeY, sizeZ, offset, null);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addGeometry(new Box3DDefinition(sizeX, sizeY, sizeZ), offset, orientation);
    }

    public void addCapsule(double length, double radius) {
        this.addCapsule(length, radius, null, null);
    }

    public void addCapsule(double length, double radius, Tuple3DReadOnly offset) {
        this.addCapsule(length, radius, offset, null);
    }

    public void addCapsule(double length, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addGeometry(new Capsule3DDefinition(length, radius), offset, orientation);
    }

    public void addCone(double height, double radius) {
        this.addCone(height, radius, null, null);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset) {
        this.addCone(height, radius, offset, null);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addGeometry(new Cone3DDefinition(height, radius), offset, orientation);
    }

    public void addCylinder(double length, double radius) {
        this.addCylinder(length, radius, null, null);
    }

    public void addCylinder(double length, double radius, Tuple3DReadOnly offset) {
        this.addCylinder(length, radius, offset, null);
    }

    public void addCylinder(double length, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addGeometry(new Cylinder3DDefinition(radius, length), offset, orientation);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.Line(x0, y0, z0, xf, yf, zf, lineWidth));
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth);
    }

    public void addMultiLine(RigidBodyTransformReadOnly transform, List<? extends Point2DReadOnly> points, double lineWidth, boolean close) {
        List<Point3D> point3Ds = points.stream().map(Point3D::new).collect(Collectors.toList());
        point3Ds.forEach(arg_0 -> ((RigidBodyTransformReadOnly)transform).transform(arg_0));
        this.addMultiLine(point3Ds, lineWidth, close);
    }

    public void addMultiLine(List<? extends Point3DReadOnly> points, double lineWidth, boolean close) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            Point3DReadOnly start = points.get(i - 1);
            Point3DReadOnly end = points.get(i);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
        if (close) {
            Point3DReadOnly start = points.get(points.size() - 1);
            Point3DReadOnly end = points.get(0);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
    }

    public void addMultiLine(Point3DReadOnly[] points, double lineWidth, boolean close) {
        if (points.length < 2) {
            return;
        }
        for (int i = 1; i < points.length; ++i) {
            Point3DReadOnly start = points[i - 1];
            Point3DReadOnly end = points[i];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
        if (close) {
            Point3DReadOnly start = points[points.length - 1];
            Point3DReadOnly end = points[0];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
    }

    public void addPolygonCounterClockwise(RigidBodyTransformReadOnly polygonPose, List<? extends Point2DReadOnly> polygon) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.PolygonCounterClockwise(polygonPose, polygon));
    }

    public void addPolygon(RigidBodyTransformReadOnly polygonPose, ConvexPolygon2DReadOnly polygon) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.Polygon(polygonPose, polygon));
    }

    public void addSphere(double radius) {
        this.addSphere(radius, null);
    }

    public void addSphere(double radius, Tuple3DReadOnly offset) {
        this.addGeometry(new Sphere3DDefinition(radius), offset, null);
    }

    public void addSpheres(float radius, Point3DReadOnly[] offsets) {
        for (Point3DReadOnly point : offsets) {
            this.addSphere(radius, (Tuple3DReadOnly)point);
        }
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset) {
        this.addTetrahedron(edgeLength, offset, null);
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addGeometry(new Tetrahedron3DDefinition(edgeLength), offset, orientation);
    }

    public void clear() {
        this.triangleMesh.clear();
    }

    public TriangleMesh3DDefinition generateTriangleMesh3D() {
        return this.triangleMesh.createTriangleMesh3DDefinition();
    }

    public static class MutableTriangleMesh3DData {
        private final RecyclingArrayList<Point3D32> vertices = new RecyclingArrayList(Point3D32.class);
        private final RecyclingArrayList<Point2D32> textures = new RecyclingArrayList(Point2D32.class);
        private final RecyclingArrayList<Vector3D32> normals = new RecyclingArrayList(Vector3D32.class);
        private final TIntArrayList triangleIndices = new TIntArrayList();

        public void clear() {
            this.vertices.clear();
            this.textures.clear();
            this.normals.clear();
            this.triangleIndices.reset();
        }

        public TriangleMesh3DDefinition createTriangleMesh3DDefinition() {
            Point3D32[] vertexArray = (Point3D32[])this.vertices.toArray((Object[])new Point3D32[0]);
            Point2D32[] texturePointArray = (Point2D32[])this.textures.toArray((Object[])new Point2D32[0]);
            Vector3D32[] vertexNormalArray = (Vector3D32[])this.normals.toArray((Object[])new Vector3D32[0]);
            int[] triangleIndexArray = this.triangleIndices.toArray();
            return new TriangleMesh3DDefinition(vertexArray, texturePointArray, vertexNormalArray, triangleIndexArray);
        }

        public void add(TriangleMesh3DDefinition triangleMesh, boolean updateTriangleIndices) {
            this.add(triangleMesh, null, null, updateTriangleIndices);
        }

        /*
         * WARNING - void declaration
         */
        public void add(TriangleMesh3DDefinition triangleMesh, Tuple3DReadOnly positionOffset, Orientation3DReadOnly orientationOffset, boolean updateTriangleIndices) {
            if (triangleMesh == null) {
                return;
            }
            Point3D32[] otherVertices = triangleMesh.getVertices();
            if (otherVertices == null || otherVertices.length < 3) {
                return;
            }
            int[] otherTriangleIndices = triangleMesh.getTriangleIndices();
            if (otherTriangleIndices == null || otherTriangleIndices.length < 3) {
                return;
            }
            if (updateTriangleIndices) {
                void var10_13;
                int shift = this.vertices.size();
                int[] nArray = otherTriangleIndices;
                int n = nArray.length;
                boolean i = false;
                while (var10_13 < n) {
                    int otherTriangleIndex = nArray[var10_13];
                    this.triangleIndices.add(otherTriangleIndex + shift);
                    ++var10_13;
                }
            } else {
                this.triangleIndices.add(otherTriangleIndices);
            }
            for (Point3D32 point3D32 : otherVertices) {
                Point3D32 vertex = (Point3D32)this.vertices.add();
                vertex.set(point3D32);
                if (orientationOffset != null) {
                    orientationOffset.transform((Tuple3DBasics)vertex);
                }
                if (positionOffset == null) continue;
                vertex.add(positionOffset);
            }
            for (Point3D32 point3D32 : triangleMesh.getTextures()) {
                ((Point2D32)this.textures.add()).set((Point2D32)point3D32);
            }
            for (Point3D32 point3D32 : triangleMesh.getNormals()) {
                Vector3D32 normal = (Vector3D32)this.normals.add();
                normal.set((Vector3D32)point3D32);
                if (orientationOffset == null) continue;
                orientationOffset.transform((Tuple3DBasics)normal);
            }
        }

        public void add(MutableTriangleMesh3DData other, boolean updateTriangleIndices) {
            this.add(other, null, null, updateTriangleIndices);
        }

        public void add(MutableTriangleMesh3DData other, Tuple3DReadOnly positionOffset, Orientation3DReadOnly orientationOffset, boolean updateTriangleIndices) {
            int i;
            if (updateTriangleIndices) {
                int shift = this.vertices.size();
                for (int i2 = 0; i2 < other.triangleIndices.size(); ++i2) {
                    this.triangleIndices.add(other.triangleIndices.get(i2) + shift);
                }
            } else {
                this.triangleIndices.addAll((TIntCollection)other.triangleIndices);
            }
            for (i = 0; i < other.vertices.size(); ++i) {
                Point3D32 vertex = (Point3D32)this.vertices.add();
                vertex.set((Point3D32)other.vertices.get(i));
                if (orientationOffset != null) {
                    orientationOffset.transform((Tuple3DBasics)vertex);
                }
                if (positionOffset == null) continue;
                vertex.add(positionOffset);
            }
            for (i = 0; i < other.textures.size(); ++i) {
                ((Point2D32)this.textures.add()).set((Point2D32)other.textures.get(i));
            }
            for (i = 0; i < other.normals.size(); ++i) {
                Vector3D32 normal = (Vector3D32)this.normals.add();
                normal.set((Vector3D32)other.normals.get(i));
                if (orientationOffset == null) continue;
                orientationOffset.transform((Tuple3DBasics)normal);
            }
        }
    }
}

