/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import javax.xml.bind.annotation.XmlElement;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.QuaternionDefinition;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateReadOnly;

public class SphericalJointState
extends JointStateBase
implements SphericalJointStateBasics {
    private final QuaternionDefinition orientation = new QuaternionDefinition();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);

    public SphericalJointState() {
    }

    public SphericalJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SphericalJointStateReadOnly) {
            SphericalJointStateBasics.super.set((SphericalJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            } else {
                this.orientation.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            } else {
                this.angularVelocity.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            } else {
                this.angularAcceleration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            } else {
                this.torque.setToNaN();
            }
        }
    }

    @XmlElement
    public void setOrientation(QuaternionDefinition orientation) {
        this.orientation.set((QuaternionReadOnly)orientation);
    }

    @XmlElement
    public void setAngularVelocity(Vector3D angularVelocity) {
        this.angularVelocity.set(angularVelocity);
    }

    @XmlElement
    public void setAngularAcceleration(Vector3D angularAcceleration) {
        this.angularAcceleration.set(angularAcceleration);
    }

    @XmlElement
    public void setTorque(Vector3D torque) {
        this.torque.set(torque);
    }

    @Override
    public QuaternionDefinition getOrientation() {
        return this.orientation;
    }

    public Vector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public Vector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public Vector3D getTorque() {
        return this.torque;
    }

    @Override
    public SphericalJointState copy() {
        return new SphericalJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.orientation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularVelocity);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularAcceleration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.torque);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SphericalJointState other = (SphericalJointState)object;
        if (this.orientation.containsNaN() ? !other.orientation.containsNaN() : !this.orientation.equals((Tuple4DReadOnly)other.orientation)) {
            return false;
        }
        if (this.angularVelocity.containsNaN() ? !other.angularVelocity.containsNaN() : !this.angularVelocity.equals((Tuple3DReadOnly)other.angularVelocity)) {
            return false;
        }
        if (this.angularAcceleration.containsNaN() ? !other.angularAcceleration.containsNaN() : !this.angularAcceleration.equals((Tuple3DReadOnly)other.angularAcceleration)) {
            return false;
        }
        return !(this.torque.containsNaN() ? !other.torque.containsNaN() : !this.torque.equals((Tuple3DReadOnly)other.torque));
    }

    public String toString() {
        Object ret = "Spherical joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + ", orientaiton: " + this.orientation.toStringAsYawPitchRoll();
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + ", angular velocity: " + this.angularVelocity;
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + ", angular acceleration: " + this.angularAcceleration;
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + ", torque: " + this.torque;
        }
        return ret;
    }
}

