/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.ExtrusionDefinition;

public class TextureDefinition {
    private URL fileURL;
    private String filename;
    private BufferedImage image;

    public TextureDefinition() {
    }

    public TextureDefinition(URL fileURL) {
        this.setFileURL(fileURL);
    }

    public TextureDefinition(String filename) {
        this.setFilename(filename);
    }

    public TextureDefinition(BufferedImage image) {
        this.setImage(image);
    }

    public TextureDefinition(TextureDefinition other) {
        this.set(other);
    }

    public void set(TextureDefinition other) {
        this.fileURL = other.fileURL;
        this.filename = other.filename;
        this.image = ExtrusionDefinition.copyImage(other.image);
    }

    public void setFileURL(URL fileURL) {
        this.fileURL = fileURL;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public String getFilename() {
        return this.filename;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public TextureDefinition copy() {
        return new TextureDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.fileURL);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.filename);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.image);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TextureDefinition other = (TextureDefinition)object;
        if (!Objects.equals(this.fileURL, other.fileURL)) {
            return false;
        }
        if (!Objects.equals(this.filename, other.filename)) {
            return false;
        }
        return Objects.equals(this.image, other.image);
    }

    public String toString() {
        return "[fileURL=" + String.valueOf(this.fileURL) + ", filename=" + this.filename + ", image=" + String.valueOf(this.image) + "]";
    }
}

