/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.List;
import us.ihmc.scs2.definition.robot.sdf.items.SDFGeometry;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public class SDFVisual
implements SDFItem {
    private String name;
    private String castShadows;
    private String laserRetro;
    private String transparency;
    private String pose;
    private SDFGeometry geometry;
    private SDFMaterial material;

    public String getName() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    public String getCastShadows() {
        return this.castShadows;
    }

    @XmlElement(name="cast_shadows")
    public void setCastShadows(String castShadows) {
        this.castShadows = castShadows;
    }

    public String getLaserRetro() {
        return this.laserRetro;
    }

    @XmlElement(name="laser_retro")
    public void setLaserRetro(String laserRetro) {
        this.laserRetro = laserRetro;
    }

    public String getTransparency() {
        return this.transparency;
    }

    @XmlElement(name="transparency")
    public void setTransparency(String transparency) {
        this.transparency = transparency;
    }

    public String getPose() {
        return this.pose;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    public SDFGeometry getGeometry() {
        return this.geometry;
    }

    @XmlElement(name="geometry")
    public void setGeometry(SDFGeometry geometry) {
        this.geometry = geometry;
    }

    public SDFMaterial getMaterial() {
        return this.material;
    }

    @XmlElement(name="material")
    public void setMaterial(SDFMaterial material) {
        this.material = material;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, castShadows: %s, laserRetro: %s, transparency: %s, pose: %s, geometry: %s, material: %s]", this.name, this.castShadows, this.laserRetro, this.transparency, this.pose, this.geometry, this.material);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemURIHolders(this.geometry, this.material);
    }

    public String toString() {
        return this.itemToString();
    }

    public static class SDFMaterial
    implements SDFItem {
        private SDFScript script;
        private String lighting;
        private String ambient;
        private String diffuse;
        private String specular;
        private String emissive;

        public SDFScript getScript() {
            return this.script;
        }

        @XmlElement(name="script")
        public void setScript(SDFScript script) {
            this.script = script;
        }

        public String getLighting() {
            return this.lighting;
        }

        public String getAmbient() {
            return this.ambient;
        }

        public String getDiffuse() {
            return this.diffuse;
        }

        public String getSpecular() {
            return this.specular;
        }

        public String getEmissive() {
            return this.emissive;
        }

        @XmlElement(name="lighting")
        public void setLighting(String lighting) {
            this.lighting = lighting;
        }

        @XmlElement(name="ambient")
        public void setAmbient(String ambient) {
            this.ambient = ambient;
        }

        @XmlElement(name="diffuse")
        public void setDiffuse(String diffuse) {
            this.diffuse = diffuse;
        }

        @XmlElement(name="specular")
        public void setSpecular(String specular) {
            this.specular = specular;
        }

        @XmlElement(name="emissive")
        public void setEmissive(String emissive) {
            this.emissive = emissive;
        }

        @Override
        public String getContentAsString() {
            return this.format("[script: %s, lighting: %s, ambient: %s, diffuse: %s, specular: %s, emissive: %s]", this.script, this.lighting, this.ambient, this.diffuse, this.specular, this.emissive);
        }

        public List<SDFURIHolder> getURIHolders() {
            return SDFItem.combineItemURIHolders(this.script);
        }

        public String toString() {
            return this.itemToString();
        }

        public static class SDFScript
        implements SDFItem {
            private String name;
            private List<SDFURIHolder.SimpleSDFURIHolder> uris;

            public String getName() {
                return this.name;
            }

            @XmlElement(name="name")
            public void setName(String name) {
                this.name = name;
            }

            public List<SDFURIHolder.SimpleSDFURIHolder> getUris() {
                return this.uris;
            }

            @XmlElement(name="uri")
            public void setUri(List<String> uri) {
                this.uris = SDFURIHolder.toSimpleSDFURIHolders(uri);
            }

            @Override
            public String getContentAsString() {
                return this.format("[name: %s, uris: %s]", this.name, this.uris);
            }

            public List<SDFURIHolder.SimpleSDFURIHolder> getURIHolders() {
                return this.uris;
            }

            public String toString() {
                return this.itemToString();
            }
        }
    }
}

