/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public class SDFSensor
implements SDFItem {
    private String name;
    private String type;
    private String updateRate;
    private String pose;
    private List<SDFCamera> camera;
    private SDFRay ray;
    private SDFIMU imu;

    public String getName() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    @XmlAttribute(name="type")
    public void setType(String type) {
        this.type = type;
    }

    public String getUpdateRate() {
        return this.updateRate;
    }

    @XmlElement(name="update_rate")
    public void setUpdateRate(String updateRate) {
        this.updateRate = updateRate;
    }

    public String getPose() {
        return this.pose;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    public List<SDFCamera> getCamera() {
        return this.camera;
    }

    @XmlElement(name="camera")
    public void setCamera(List<SDFCamera> camera) {
        this.camera = camera;
    }

    @XmlElement(name="ray")
    public void setRay(SDFRay ray) {
        this.ray = ray;
    }

    public SDFRay getRay() {
        return this.ray;
    }

    public SDFIMU getImu() {
        return this.imu;
    }

    @XmlElement(name="imu")
    public void setImu(SDFIMU imu) {
        this.imu = imu;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, type: %s, updateRate: %s, pose: %s, camera: %s, ray: %s, imu: %s]", this.name, this.type, this.updateRate, this.pose, this.camera, this.ray, this.imu);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemListsURIHolders(this.camera, Arrays.asList(this.ray, this.imu));
    }

    public String toString() {
        return this.itemToString();
    }

    public static class SDFRay
    implements SDFItem {
        private String pose;
        private SDFRange range;
        private SDFScan scan;
        private SDFNoise noise;

        @XmlElement(name="pose")
        public void setPose(String pose) {
            this.pose = pose;
        }

        @XmlElement(name="range")
        public void setRange(SDFRange range) {
            this.range = range;
        }

        @XmlElement(name="scan")
        public void setScan(SDFScan scan) {
            this.scan = scan;
        }

        public String getPose() {
            return this.pose;
        }

        public SDFRange getRange() {
            return this.range;
        }

        public SDFScan getScan() {
            return this.scan;
        }

        public SDFNoise getNoise() {
            return this.noise;
        }

        @XmlElement(name="noise")
        public void setNoise(SDFNoise noise) {
            this.noise = noise;
        }

        @Override
        public String getContentAsString() {
            return this.format("[pose: %s, range: %s, scan: %s, noise: %s]", this.pose, this.range, this.scan, this.noise);
        }

        public List<SDFURIHolder> getURIHolders() {
            return SDFItem.combineItemURIHolders(this.range, this.scan, this.noise);
        }

        public String toString() {
            return this.itemToString();
        }

        public static class SDFRange
        implements SDFItem {
            private String min;
            private String max;
            private String resolution;

            @XmlElement(name="min")
            public void setMin(String min) {
                this.min = min;
            }

            @XmlElement(name="max")
            public void setMax(String max) {
                this.max = max;
            }

            @XmlElement(name="resolution")
            public void setResolution(String resolution) {
                this.resolution = resolution;
            }

            public String getMin() {
                return this.min;
            }

            public String getMax() {
                return this.max;
            }

            public String getResolution() {
                return this.resolution;
            }

            @Override
            public String getContentAsString() {
                return this.format("[min: %s, max: %s, resolution: %s]", this.min, this.max, this.resolution);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }

        public static class SDFScan
        implements SDFItem {
            private SDFHorizontalScan horizontal;
            private SDFVerticalScan vertical;

            @XmlElement(name="horizontal")
            public void setHorizontal(SDFHorizontalScan horizontal) {
                this.horizontal = horizontal;
            }

            public SDFHorizontalScan getHorizontal() {
                return this.horizontal;
            }

            @XmlElement(name="vertical")
            public SDFVerticalScan getVertical() {
                return this.vertical;
            }

            public void setVertical(SDFVerticalScan vertical) {
                this.vertical = vertical;
            }

            @Override
            public String getContentAsString() {
                return this.format("[horizontal: %s, vertical: %s]", this.horizontal, this.vertical);
            }

            public List<SDFURIHolder> getURIHolders() {
                return SDFItem.combineItemURIHolders(this.horizontal, this.vertical);
            }

            public String toString() {
                return this.itemToString();
            }

            public static class SDFHorizontalScan
            implements SDFItem {
                private String samples;
                private String resolution;
                private String minAngle;
                private String maxAngle;

                @XmlElement(name="samples")
                public void setSamples(String samples) {
                    this.samples = samples;
                }

                @XmlElement(name="resolution")
                public void setResolution(String resolution) {
                    this.resolution = resolution;
                }

                @XmlElement(name="min_angle")
                public void setMinAngle(String minAngle) {
                    this.minAngle = minAngle;
                }

                @XmlElement(name="max_angle")
                public void setMaxAngle(String maxAngle) {
                    this.maxAngle = maxAngle;
                }

                public String getSamples() {
                    return this.samples;
                }

                public String getResolution() {
                    return this.resolution;
                }

                public String getMinAngle() {
                    return this.minAngle;
                }

                public String getMaxAngle() {
                    return this.maxAngle;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[samples: %s, resolution: %s, minAngle: %s, maxAngle: %s]", this.samples, this.resolution, this.minAngle, this.maxAngle);
                }

                public List<SDFURIHolder> getURIHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }

            public static class SDFVerticalScan
            implements SDFItem {
                private String samples;
                private String resolution;
                private String minAngle;
                private String maxAngle;

                @XmlElement(name="samples")
                public void setSamples(String samples) {
                    this.samples = samples;
                }

                @XmlElement(name="resolution")
                public void setResolution(String resolution) {
                    this.resolution = resolution;
                }

                @XmlElement(name="min_angle")
                public void setMinAngle(String minAngle) {
                    this.minAngle = minAngle;
                }

                @XmlElement(name="max_angle")
                public void setMaxAngle(String maxAngle) {
                    this.maxAngle = maxAngle;
                }

                public String getSamples() {
                    return this.samples;
                }

                public String getResolution() {
                    return this.resolution;
                }

                public String getMinAngle() {
                    return this.minAngle;
                }

                public String getMaxAngle() {
                    return this.maxAngle;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[samples: %s, resolution: %s, minAngle: %s, maxAngle: %s]", this.samples, this.resolution, this.minAngle, this.maxAngle);
                }

                public List<SDFURIHolder> getURIHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }
        }

        public static class SDFNoise
        implements SDFItem {
            private String type;
            private String mean;
            private String stddev;

            @XmlElement(name="type")
            public void setType(String type) {
                this.type = type;
            }

            @XmlElement(name="mean")
            public void setMean(String mean) {
                this.mean = mean;
            }

            @XmlElement(name="stddev")
            public void setStddev(String stddev) {
                this.stddev = stddev;
            }

            public String getType() {
                return this.type;
            }

            public String getMean() {
                return this.mean;
            }

            public String getStddev() {
                return this.stddev;
            }

            @Override
            public String getContentAsString() {
                return this.format("[type: %s, mean: %s, stddev]", this.type, this.mean, this.stddev);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }
    }

    public static class SDFIMU
    implements SDFItem {
        private SDFIMUNoise noise;

        public SDFIMUNoise getNoise() {
            return this.noise;
        }

        @XmlElement(name="noise")
        public void setNoise(SDFIMUNoise noise) {
            this.noise = noise;
        }

        @Override
        public String getContentAsString() {
            return this.format("[noise: %s]", this.noise);
        }

        public List<SDFURIHolder> getURIHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }

        public static class SDFIMUNoise
        implements SDFItem {
            private String type;
            private SDFNoiseParameters rate;
            private SDFNoiseParameters accel;

            public String getType() {
                return this.type;
            }

            public SDFNoiseParameters getRate() {
                return this.rate;
            }

            public SDFNoiseParameters getAccel() {
                return this.accel;
            }

            @XmlElement(name="type")
            public void setType(String type) {
                this.type = type;
            }

            @XmlElement(name="rate")
            public void setRate(SDFNoiseParameters rate) {
                this.rate = rate;
            }

            @XmlElement(name="accel")
            public void setAccel(SDFNoiseParameters accel) {
                this.accel = accel;
            }

            @Override
            public String getContentAsString() {
                return this.format("[type: %s, rate: %s, accel: %s]", this.type, this.rate, this.accel);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }

            public static class SDFNoiseParameters
            implements SDFItem {
                private String mean;
                private String stddev;
                private String bias_mean;
                private String bias_stddev;

                public String getMean() {
                    return this.mean;
                }

                public String getStddev() {
                    return this.stddev;
                }

                public String getBias_mean() {
                    return this.bias_mean;
                }

                public String getBias_stddev() {
                    return this.bias_stddev;
                }

                @XmlElement(name="mean")
                public void setMean(String mean) {
                    this.mean = mean;
                }

                @XmlElement(name="stddev")
                public void setStddev(String stddev) {
                    this.stddev = stddev;
                }

                @XmlElement(name="bias_mean")
                public void setBias_mean(String bias_mean) {
                    this.bias_mean = bias_mean;
                }

                @XmlElement(name="bias_stddev")
                public void setBias_stddev(String bias_stddev) {
                    this.bias_stddev = bias_stddev;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[mean: %s, stddev: %s, bias_mean: %s, bias_stddev: %s]", this.mean, this.stddev, this.bias_mean, this.bias_stddev);
                }

                public List<SDFURIHolder> getURIHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }
        }
    }

    public static class SDFCamera
    implements SDFItem {
        private String name;
        private String pose;
        private String horizontalFov;
        private SDFSensorImage image;
        private SDFClip clip;

        public String getPose() {
            return this.pose;
        }

        @XmlElement(name="pose")
        public void setPose(String pose) {
            this.pose = pose;
        }

        public String getHorizontalFov() {
            return this.horizontalFov;
        }

        @XmlElement(name="horizontal_fov")
        public void setHorizontalFov(String horizontalFov) {
            this.horizontalFov = horizontalFov;
        }

        public SDFSensorImage getImage() {
            return this.image;
        }

        @XmlElement(name="image")
        public void setImage(SDFSensorImage image) {
            this.image = image;
        }

        public SDFClip getClip() {
            return this.clip;
        }

        @XmlElement(name="clip")
        public void setClip(SDFClip clip) {
            this.clip = clip;
        }

        @XmlAttribute(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getContentAsString() {
            return this.format("[name: %s, pose: %s, horizontalFov: %s, image: %s, clip: %s]", this.name, this.pose, this.horizontalFov, this.image, this.clip);
        }

        public List<SDFURIHolder> getURIHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }

        public static class SDFSensorImage
        implements SDFItem {
            private String width;
            private String height;
            private String format;

            public String getWidth() {
                return this.width;
            }

            @XmlElement(name="width")
            public void setWidth(String width) {
                this.width = width;
            }

            public String getHeight() {
                return this.height;
            }

            @XmlElement(name="height")
            public void setHeight(String height) {
                this.height = height;
            }

            public String getFormat() {
                return this.format;
            }

            @XmlElement(name="format")
            public void setFormat(String format) {
                this.format = format;
            }

            @Override
            public String getContentAsString() {
                return this.format("[width: %s, height: %s, format: %s]", this.width, this.height, this.format);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }

        public static class SDFClip
        implements SDFItem {
            private String near;
            private String far;

            public String getNear() {
                return this.near;
            }

            @XmlElement(name="near")
            public void setNear(String near) {
                this.near = near;
            }

            public String getFar() {
                return this.far;
            }

            @XmlElement(name="far")
            public void setFar(String far) {
                this.far = far;
            }

            @Override
            public String getContentAsString() {
                return this.format("[near: %s, far: %s]", this.near, this.far);
            }

            public List<SDFURIHolder> getURIHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }
    }
}

