/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.camera;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;

public class YoLevelOrbitalCoordinateDefinition
extends YoCompositeDefinition {
    public static final String YoLevelOrbital = "YoLevelOrbitalCoordinate";
    public static final String[] YoLevelOrbitalIdentifiers = new String[]{"distance", "longitude", "height"};
    private String distance;
    private String longitude;
    private String height;
    private String referenceFrame;

    public YoLevelOrbitalCoordinateDefinition() {
    }

    public YoLevelOrbitalCoordinateDefinition(String distance, String longitude, String height) {
        this(distance, longitude, height, null);
    }

    public YoLevelOrbitalCoordinateDefinition(String distance, String longitude, String height, String referenceFrame) {
        this.distance = distance;
        this.longitude = longitude;
        this.height = height;
        this.referenceFrame = referenceFrame;
    }

    public void setDistance(double distance) {
        this.distance = Double.toString(distance);
    }

    @XmlElement
    public void setDistance(String distance) {
        this.distance = distance;
    }

    public void setLongitude(double longitude) {
        this.longitude = Double.toString(longitude);
    }

    @XmlElement
    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setHeight(double height) {
        this.height = Double.toString(height);
    }

    @XmlElement
    public void setHeight(String height) {
        this.height = height;
    }

    @Override
    @XmlElement
    public void setReferenceFrame(String referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String getDistance() {
        return this.distance;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getHeight() {
        return this.height;
    }

    @Override
    public String getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public String getType() {
        return YoLevelOrbital;
    }

    @Override
    public String[] getComponentIdentifiers() {
        return YoLevelOrbitalIdentifiers;
    }

    @Override
    public String[] getComponentValues() {
        return new String[]{this.distance, this.longitude, this.height};
    }

    public static YoLevelOrbitalCoordinateDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith(YoLevelOrbital)) {
            value = value.substring(value.indexOf("=") + 1).trim();
            String distance = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String longitude = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String height = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String frame = value.substring(0, value.length() - 1);
            if (distance.equalsIgnoreCase("null")) {
                distance = null;
            }
            if (longitude.equalsIgnoreCase("null")) {
                longitude = null;
            }
            if (height.equalsIgnoreCase("null")) {
                height = null;
            }
            if (frame.equalsIgnoreCase("null")) {
                frame = null;
            }
            return new YoLevelOrbitalCoordinateDefinition(distance, longitude, height, frame);
        }
        throw new IllegalArgumentException("Unknown format: " + value);
    }
}

