/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;

@XmlSeeAlso(value={YoOrientation3DDefinition.class, YoTuple2DDefinition.class, YoTuple3DDefinition.class})
public abstract class YoCompositeDefinition {
    public abstract String getType();

    public abstract String[] getComponentIdentifiers();

    public List<String[]> getAlternateComponentIdentifiers() {
        return Collections.emptyList();
    }

    public abstract String[] getComponentValues();

    public abstract void setReferenceFrame(String var1);

    public abstract String getReferenceFrame();

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoCompositeDefinition) {
            YoCompositeDefinition other = (YoCompositeDefinition)object;
            if (!Objects.equals(this.getType(), other.getType())) {
                return false;
            }
            if (!Arrays.equals(this.getComponentIdentifiers(), other.getComponentIdentifiers())) {
                return false;
            }
            if (!Arrays.equals(this.getComponentValues(), other.getComponentValues())) {
                return false;
            }
            return Objects.equals(this.getReferenceFrame(), other.getReferenceFrame());
        }
        return false;
    }

    public final String toString() {
        String description = this.getType() + "(";
        String[] ids = this.getComponentIdentifiers();
        String[] values = this.getComponentValues();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                description = description + ", ";
            }
            description = description + "%s=%s".formatted(ids[i], values[i]);
        }
        description = description + ", frame=" + this.getReferenceFrame() + ")";
        return description;
    }
}

