/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import jakarta.xml.bind.annotation.XmlElement;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.QuaternionDefinition;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateReadOnly;

public class SixDoFJointState
extends JointStateBase
implements SixDoFJointStateBasics {
    private final QuaternionDefinition orientation = new QuaternionDefinition();
    private final Point3D position = new Point3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D linearAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final Vector3D force = new Vector3D();
    private final DMatrixRMaj temp = new DMatrixRMaj(7, 1);

    public SixDoFJointState() {
        this.clear();
    }

    public SixDoFJointState(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this();
        this.setConfiguration(orientation, position);
    }

    public SixDoFJointState(JointStateReadOnly other) {
        this();
        this.set(other);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SixDoFJointStateReadOnly) {
            SixDoFJointStateBasics.super.set((SixDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            } else {
                this.orientation.setToNaN();
                this.position.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            } else {
                this.angularVelocity.setToNaN();
                this.linearVelocity.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            } else {
                this.angularAcceleration.setToNaN();
                this.linearAcceleration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            } else {
                this.torque.setToNaN();
                this.force.setToNaN();
            }
        }
    }

    @XmlElement
    public void setOrientation(QuaternionDefinition orientation) {
        this.orientation.set((QuaternionReadOnly)orientation);
    }

    @XmlElement
    public void setPosition(Point3D position) {
        this.position.set(position);
    }

    @XmlElement
    public void setAngularVelocity(Vector3D angularVelocity) {
        this.angularVelocity.set(angularVelocity);
    }

    @XmlElement
    public void setLinearVelocity(Vector3D linearVelocity) {
        this.linearVelocity.set(linearVelocity);
    }

    @XmlElement
    public void setAngularAcceleration(Vector3D angularAcceleration) {
        this.angularAcceleration.set(angularAcceleration);
    }

    @XmlElement
    public void setLinearAcceleration(Vector3D linearAcceleration) {
        this.linearAcceleration.set(linearAcceleration);
    }

    @XmlElement
    public void setTorque(Vector3D torque) {
        this.torque.set(torque);
    }

    @XmlElement
    public void setForce(Vector3D force) {
        this.force.set(force);
    }

    @Override
    public QuaternionDefinition getOrientation() {
        return this.orientation;
    }

    public Point3D getPosition() {
        return this.position;
    }

    public Vector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public Vector3D getLinearVelocity() {
        return this.linearVelocity;
    }

    public Vector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public Vector3D getLinearAcceleration() {
        return this.linearAcceleration;
    }

    public Vector3D getTorque() {
        return this.torque;
    }

    public Vector3D getForce() {
        return this.force;
    }

    @Override
    public SixDoFJointState copy() {
        return new SixDoFJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.orientation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.position);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularVelocity);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.linearVelocity);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularAcceleration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.linearAcceleration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.torque);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.force);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SixDoFJointState other = (SixDoFJointState)object;
        if (this.orientation.containsNaN() ? !other.orientation.containsNaN() : !this.orientation.equals((EuclidGeometry)other.orientation)) {
            return false;
        }
        if (this.position.containsNaN() ? !other.position.containsNaN() : !this.position.equals((EuclidGeometry)other.position)) {
            return false;
        }
        if (this.angularVelocity.containsNaN() ? !other.angularVelocity.containsNaN() : !this.angularVelocity.equals((EuclidGeometry)other.angularVelocity)) {
            return false;
        }
        if (this.linearVelocity.containsNaN() ? !other.linearVelocity.containsNaN() : !this.linearVelocity.equals((EuclidGeometry)other.linearVelocity)) {
            return false;
        }
        if (this.angularAcceleration.containsNaN() ? !other.angularAcceleration.containsNaN() : !this.angularAcceleration.equals((EuclidGeometry)other.angularAcceleration)) {
            return false;
        }
        if (this.linearAcceleration.containsNaN() ? !other.linearAcceleration.containsNaN() : !this.linearAcceleration.equals((EuclidGeometry)other.linearAcceleration)) {
            return false;
        }
        if (this.torque.containsNaN() ? !other.torque.containsNaN() : !this.torque.equals((EuclidGeometry)other.torque)) {
            return false;
        }
        return !(this.force.containsNaN() ? !other.force.containsNaN() : !this.force.equals((EuclidGeometry)other.force));
    }

    public String toString() {
        Object ret = "6-DoF joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + ", orientation: " + this.orientation.toStringAsYawPitchRoll() + ", position: " + this.position;
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + ", angular velocity: " + this.angularVelocity + ", linear velocity: " + this.linearVelocity;
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + ", angular acceleration: " + this.angularAcceleration + ", linear acceleration: " + this.linearAcceleration;
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + ", torqe: " + this.torque + ", force: " + this.force;
        }
        return ret;
    }
}

