/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoVariable;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.definition.yoVariable.YoVariableDefinition;

public class YoEquationDefinition {
    private String name;
    private String description;
    private String equation;
    private List<EquationAliasDefinition> aliases = new ArrayList<EquationAliasDefinition>();

    public void set(YoEquationDefinition other) {
        this.name = other.name;
        this.description = other.description;
        this.equation = other.equation;
        this.aliases.clear();
        this.aliases.addAll(other.aliases);
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    public void setEquation(String equation) {
        this.equation = equation;
    }

    @XmlElement
    public void setAliases(List<EquationAliasDefinition> aliases) {
        this.aliases = aliases;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEquation() {
        return this.equation;
    }

    public List<EquationAliasDefinition> getAliases() {
        return this.aliases;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoEquationDefinition) {
            YoEquationDefinition other = (YoEquationDefinition)object;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.description, other.description)) {
                return false;
            }
            if (!Objects.equals(this.equation, other.equation)) {
                return false;
            }
            return Objects.equals(this.aliases, other.aliases);
        }
        return false;
    }

    public String toString() {
        return "name: " + this.name + ", description: " + this.description + ", equation: " + this.equation + ", aliases: " + String.valueOf(this.aliases);
    }

    public static class EquationInputDefinition {
        private String value;
        private YoVariableDefinition yoVariableValue;
        private boolean isConstant;

        public EquationInputDefinition() {
        }

        public EquationInputDefinition(String value) {
            this(value, false);
        }

        public EquationInputDefinition(String value, boolean isConstant) {
            this.value = value;
            this.isConstant = isConstant;
        }

        public EquationInputDefinition(YoVariableDefinition yoVariableValue) {
            this.yoVariableValue = yoVariableValue;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setYoVariableValue(YoVariableDefinition yoVariableValue) {
            this.yoVariableValue = yoVariableValue;
        }

        public void setConstant(boolean constant) {
            this.isConstant = constant;
        }

        public String getValue() {
            return this.value;
        }

        public YoVariableDefinition getYoVariableValue() {
            return this.yoVariableValue;
        }

        public String computeSimpleStringValue() {
            if (this.value != null) {
                return this.value;
            }
            if (this.yoVariableValue != null) {
                return this.yoVariableValue.getFullname();
            }
            return null;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof EquationInputDefinition) {
                EquationInputDefinition other = (EquationInputDefinition)object;
                if (!Objects.equals(this.value, other.value)) {
                    return false;
                }
                if (!Objects.equals(this.yoVariableValue, other.yoVariableValue)) {
                    return false;
                }
                return this.isConstant == other.isConstant;
            }
            return false;
        }

        public String toString() {
            return "value: " + this.value + ", yoVariableValue: " + String.valueOf(this.yoVariableValue);
        }
    }

    public static class EquationAliasDefinition {
        private String name;
        private EquationInputDefinition value;

        public EquationAliasDefinition() {
        }

        public EquationAliasDefinition(String name, EquationInputDefinition value) {
            this.name = name;
            this.value = value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(EquationInputDefinition value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public EquationInputDefinition getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof EquationAliasDefinition) {
                EquationAliasDefinition other = (EquationAliasDefinition)object;
                if (!Objects.equals(this.name, other.name)) {
                    return false;
                }
                return Objects.equals(this.value, other.value);
            }
            return false;
        }

        public String toString() {
            return "name: " + this.name + ", value: " + String.valueOf(this.value);
        }
    }
}

