/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;

@XmlRootElement(name="YoGraphicCoordinateSystem3D")
public class YoGraphicCoordinateSystem3DDefinition
extends YoGraphic3DDefinition {
    private YoTuple3DDefinition position;
    private YoOrientation3DDefinition orientation;
    private String bodyLength;
    private String headLength;
    private String bodyRadius;
    private String headRadius;

    public YoGraphicCoordinateSystem3DDefinition() {
    }

    public YoGraphicCoordinateSystem3DDefinition(YoGraphicCoordinateSystem3DDefinition other) {
        super(other);
        this.position = other.position == null ? null : other.position.copy();
        this.orientation = other.orientation == null ? null : other.orientation.copy();
        this.bodyLength = other.bodyLength;
        this.headLength = other.headLength;
        this.bodyRadius = other.bodyRadius;
        this.headRadius = other.headRadius;
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerTuple3DField("position", this::getPosition, this::setPosition);
        this.registerOrientation3DField("orientation", this::getOrientation, this::setOrientation);
        this.registerStringField("bodyLength", this::getBodyLength, this::setBodyLength);
        this.registerStringField("headLength", this::getHeadLength, this::setHeadLength);
        this.registerStringField("bodyRadius", this::getBodyRadius, this::setBodyRadius);
        this.registerStringField("headRadius", this::getHeadRadius, this::setHeadRadius);
    }

    @XmlElement
    public void setPosition(YoTuple3DDefinition position) {
        this.position = position;
    }

    @XmlElement
    public void setOrientation(YoOrientation3DDefinition orientation) {
        this.orientation = orientation;
    }

    public void setBodyLength(double bodyLength) {
        this.bodyLength = Double.toString(bodyLength);
    }

    @XmlElement
    public void setBodyLength(String bodyLength) {
        this.bodyLength = bodyLength;
    }

    public void setHeadLength(double headLength) {
        this.headLength = Double.toString(headLength);
    }

    @XmlElement
    public void setHeadLength(String headLength) {
        this.headLength = headLength;
    }

    public void setBodyRadius(double bodyRadius) {
        this.bodyRadius = Double.toString(bodyRadius);
    }

    @XmlElement
    public void setBodyRadius(String bodyRadius) {
        this.bodyRadius = bodyRadius;
    }

    public void setHeadRadius(double headRadius) {
        this.headRadius = Double.toString(headRadius);
    }

    @XmlElement
    public void setHeadRadius(String headRadius) {
        this.headRadius = headRadius;
    }

    public YoTuple3DDefinition getPosition() {
        return this.position;
    }

    public YoOrientation3DDefinition getOrientation() {
        return this.orientation;
    }

    public String getBodyLength() {
        return this.bodyLength;
    }

    public String getHeadLength() {
        return this.headLength;
    }

    public String getBodyRadius() {
        return this.bodyRadius;
    }

    public String getHeadRadius() {
        return this.headRadius;
    }

    @Override
    public YoGraphicCoordinateSystem3DDefinition copy() {
        return new YoGraphicCoordinateSystem3DDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicCoordinateSystem3DDefinition) {
            YoGraphicCoordinateSystem3DDefinition other = (YoGraphicCoordinateSystem3DDefinition)object;
            if (!Objects.equals(this.position, other.position)) {
                return false;
            }
            if (!Objects.equals(this.orientation, other.orientation)) {
                return false;
            }
            if (!Objects.equals(this.bodyLength, other.bodyLength)) {
                return false;
            }
            if (!Objects.equals(this.headLength, other.headLength)) {
                return false;
            }
            if (!Objects.equals(this.bodyRadius, other.bodyRadius)) {
                return false;
            }
            return Objects.equals(this.headRadius, other.headRadius);
        }
        return false;
    }
}

