/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class ModelFileGeometryDefinition
extends GeometryDefinition {
    private String fileName;
    private List<SubMeshDefinition> submeshes;
    private List<String> resourceDirectories;
    private ClassLoader resourceClassLoader;
    private Vector3D scale;

    public ModelFileGeometryDefinition() {
    }

    public ModelFileGeometryDefinition(String fileName) {
        this.setFileName(fileName);
    }

    public ModelFileGeometryDefinition(ModelFileGeometryDefinition other) {
        this.setName(other.getName());
        this.fileName = other.fileName;
        if (other.submeshes != null) {
            this.submeshes = other.submeshes.stream().map(SubMeshDefinition::new).collect(Collectors.toList());
        }
        if (other.resourceDirectories != null) {
            this.resourceDirectories = new ArrayList<String>(other.resourceDirectories);
        }
        this.resourceClassLoader = other.resourceClassLoader;
        if (other.scale != null) {
            this.scale = new Vector3D((Tuple3DReadOnly)other.scale);
        }
    }

    @XmlElement
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @XmlElement(name="submesh")
    public void setSubmeshes(List<SubMeshDefinition> submeshes) {
        this.submeshes = submeshes;
    }

    @XmlElement
    public void setResourceDirectories(List<String> resourceDirectories) {
        this.resourceDirectories = resourceDirectories;
    }

    @XmlTransient
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    @XmlElement
    public void setScale(Vector3D scale) {
        this.scale = scale;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<SubMeshDefinition> getSubmeshes() {
        return this.submeshes;
    }

    public List<String> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public Vector3D getScale() {
        return this.scale;
    }

    @Override
    public ModelFileGeometryDefinition copy() {
        return new ModelFileGeometryDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.fileName);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.submeshes);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.resourceDirectories);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.scale);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ModelFileGeometryDefinition other = (ModelFileGeometryDefinition)object;
        if (!Objects.equals(this.fileName, other.fileName)) {
            return false;
        }
        if (!Objects.equals(this.submeshes, other.submeshes)) {
            return false;
        }
        if (!Objects.equals(this.resourceDirectories, other.resourceDirectories)) {
            return false;
        }
        return Objects.equals(this.scale, other.scale);
    }

    public static class SubMeshDefinition {
        private String name;
        private boolean center;

        public SubMeshDefinition() {
        }

        public SubMeshDefinition(String name, boolean center) {
            this.name = name;
            this.center = center;
        }

        public SubMeshDefinition(SubMeshDefinition other) {
            this.name = other.name;
            this.center = other.center;
        }

        @XmlElement
        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public void setCenter(boolean center) {
            this.center = center;
        }

        public String getName() {
            return this.name;
        }

        public boolean getCenter() {
            return this.center;
        }

        public SubMeshDefinition copy() {
            return new SubMeshDefinition(this);
        }

        public int hashCode() {
            long bits = 1L;
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.center);
            return EuclidHashCodeTools.toIntHashCode((long)bits);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SubMeshDefinition other = (SubMeshDefinition)object;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return this.center == other.center;
        }
    }
}

