/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;

@XmlRootElement(name="YoGraphicList")
public class YoGraphicListDefinition
extends YoGraphicDefinition {
    private List<YoGraphicDefinition> yoGraphics = new ArrayList<YoGraphicDefinition>();

    public YoGraphicListDefinition() {
    }

    public YoGraphicListDefinition(YoGraphicDefinition ... yoGraphics) {
        this(Arrays.asList(yoGraphics));
    }

    public YoGraphicListDefinition(Collection<? extends YoGraphicDefinition> yoGraphics) {
        this.setYoGraphics(new ArrayList<YoGraphicDefinition>(yoGraphics));
    }

    public YoGraphicListDefinition(YoGraphicListDefinition other) {
        super(other);
        if (other.yoGraphics != null) {
            this.yoGraphics = other.yoGraphics.stream().filter(Objects::nonNull).map(YoGraphicDefinition::copy).toList();
        }
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerListField("yoGraphics", this::getYoGraphics, this::setYoGraphics, "g", YoGraphicDefinition::toParsableString, YoGraphicDefinition::parse);
    }

    public void clear() {
        if (this.yoGraphics != null) {
            this.yoGraphics.clear();
        }
    }

    public void addYoGraphic(YoGraphicDefinition yoGraphic) {
        if (yoGraphic == null) {
            return;
        }
        if (yoGraphic instanceof YoGraphicListDefinition) {
            YoGraphicListDefinition list = (YoGraphicListDefinition)yoGraphic;
            if (list.getYoGraphics() == null) {
                return;
            }
            for (int i = 0; i < list.getYoGraphics().size(); ++i) {
                this.addYoGraphic(list.getYoGraphics().get(i));
            }
            return;
        }
        if (this.yoGraphics == null) {
            this.yoGraphics = new ArrayList<YoGraphicDefinition>();
        }
        this.yoGraphics.add(yoGraphic);
    }

    @XmlElement(name="yoGraphic")
    public void setYoGraphics(List<YoGraphicDefinition> yoGraphics) {
        this.yoGraphics = yoGraphics;
    }

    public void unwrapNestedLists() {
        if (this.yoGraphics == null) {
            return;
        }
        for (int i = this.yoGraphics.size() - 1; i >= 0; --i) {
            YoGraphicDefinition yoGraphic = this.yoGraphics.get(i);
            if (!(yoGraphic instanceof YoGraphicListDefinition)) continue;
            YoGraphicListDefinition list = (YoGraphicListDefinition)yoGraphic;
            this.yoGraphics.remove(i);
            if (list.getYoGraphics() == null) continue;
            list.unwrapNestedLists();
            this.yoGraphics.addAll(i, list.getYoGraphics());
        }
    }

    public void mergeGroupsByName() {
        if (this.yoGraphics == null) {
            return;
        }
        for (int i = this.yoGraphics.size() - 1; i >= 0; --i) {
            YoGraphicDefinition yoGraphic = this.yoGraphics.get(i);
            if (yoGraphic instanceof YoGraphicGroupDefinition) {
                YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)yoGraphic;
                subGroup.mergeNestedGroupsByName();
                for (int j = this.yoGraphics.size() - 1; j > i; --j) {
                    YoGraphicDefinition otherChild = this.yoGraphics.get(j);
                    if (!(otherChild instanceof YoGraphicGroupDefinition)) continue;
                    YoGraphicGroupDefinition otherSubGroup = (YoGraphicGroupDefinition)otherChild;
                    if (!subGroup.getName().equals(otherSubGroup.getName())) continue;
                    this.yoGraphics.remove(j);
                    if (otherSubGroup.getChildren() == null) continue;
                    subGroup.getChildren().addAll(otherSubGroup.getChildren());
                }
                continue;
            }
            if (!(yoGraphic instanceof YoGraphicListDefinition)) continue;
            YoGraphicListDefinition list = (YoGraphicListDefinition)yoGraphic;
            list.mergeGroupsByName();
        }
    }

    @Override
    public YoGraphicListDefinition copy() {
        return new YoGraphicListDefinition(this);
    }

    public List<YoGraphicDefinition> getYoGraphics() {
        return this.yoGraphics;
    }

    @Override
    public String toString(int indent) {
        String out = "%s [name=%s, visible=%b, yoGraphics=%s]";
        return out.formatted(this.getClass().getSimpleName(), this.name, this.visible, YoGraphicListDefinition.indentedListString(indent, true, this.yoGraphics, yoGraphic -> yoGraphic.toString(indent + 1)));
    }
}

