/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public class SDFWorld
implements SDFItem {
    private List<SDFModel> models;
    private List<Road> roads;

    public List<SDFModel> getModels() {
        return this.models;
    }

    @XmlElement(name="model")
    public void setModels(List<SDFModel> models) {
        this.models = models;
    }

    public List<Road> getRoads() {
        return this.roads;
    }

    @XmlElement(name="road")
    public void setRoads(List<Road> roads) {
        this.roads = roads;
    }

    @Override
    public String getContentAsString() {
        return this.format("[models: %s, roads: %s]", this.models, this.roads);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemListsURIHolders(this.models, this.roads);
    }

    public String toString() {
        return this.itemToString();
    }

    public static class Road
    implements SDFItem {
        private String name;
        private String width;
        private List<String> points;

        public String getName() {
            return this.name;
        }

        @XmlAttribute(name="name")
        public void setName(String name) {
            this.name = name;
        }

        public String getWidth() {
            return this.width;
        }

        @XmlElement(name="width")
        public void setWidth(String width) {
            this.width = width;
        }

        public List<String> getPoints() {
            return this.points;
        }

        @XmlElement(name="point")
        public void setPoints(List<String> points) {
            this.points = points;
        }

        @Override
        public String getContentAsString() {
            return this.format("[name: %s, width: %s, points: %s]", this.name, this.width, this.points);
        }

        public List<SDFURIHolder> getURIHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }
    }
}

