/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.Objects;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.state.SphericalJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public class SphericalJointDefinition
extends JointDefinition {
    private SphericalJointState initialJointState;

    public SphericalJointDefinition() {
    }

    public SphericalJointDefinition(String name) {
        super(name);
    }

    public SphericalJointDefinition(String name, Tuple3DReadOnly offsetFromParent) {
        super(name, offsetFromParent);
    }

    public SphericalJointDefinition(SphericalJointDefinition other) {
        super(other);
        this.initialJointState = other.initialJointState == null ? null : other.initialJointState.copy();
    }

    public void setInitialJointState(SphericalJointState initialJointState) {
        this.initialJointState = initialJointState;
    }

    @Override
    public void setInitialJointState(JointStateReadOnly initialJointState) {
        if (initialJointState instanceof SphericalJointState) {
            this.setInitialJointState((SphericalJointState)initialJointState);
        } else if (this.initialJointState == null) {
            this.initialJointState = new SphericalJointState(initialJointState);
        } else {
            this.initialJointState.set(initialJointState);
        }
    }

    @Override
    public SphericalJointState getInitialJointState() {
        return this.initialJointState;
    }

    public SphericalJointBasics toJoint(RigidBodyBasics predecessor) {
        return new SphericalJoint(this.getName(), predecessor, (RigidBodyTransformReadOnly)this.getTransformToParent());
    }

    @Override
    public SphericalJointDefinition copy() {
        return new SphericalJointDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.initialJointState);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SphericalJointDefinition other = (SphericalJointDefinition)object;
        return Objects.equals(this.initialJointState, other.initialJointState);
    }
}

