/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.LoopClosureDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public abstract class JointDefinition
implements Transformable {
    private String name;
    private YawPitchRollTransformDefinition transformToParent = new YawPitchRollTransformDefinition();
    private RigidBodyDefinition predecessor;
    private RigidBodyDefinition successor;
    private List<SensorDefinition> sensorDefinitions = new ArrayList<SensorDefinition>();
    private List<KinematicPointDefinition> kinematicPointDefinitions = new ArrayList<KinematicPointDefinition>();
    private List<ExternalWrenchPointDefinition> externalWrenchPointDefinitions = new ArrayList<ExternalWrenchPointDefinition>();
    private List<GroundContactPointDefinition> groundContactPointDefinitions = new ArrayList<GroundContactPointDefinition>();
    private LoopClosureDefinition loopClosureDefinition = null;

    public JointDefinition() {
    }

    public JointDefinition(String name) {
        this.setName(name);
    }

    public JointDefinition(String name, Tuple3DReadOnly offsetFromParent) {
        this(name);
        this.transformToParent.getTranslation().set(offsetFromParent);
    }

    public JointDefinition(JointDefinition other) {
        this.name = other.name;
        this.transformToParent.set((RigidBodyTransformReadOnly)other.transformToParent);
        for (SensorDefinition sensorDefinition : other.sensorDefinitions) {
            this.sensorDefinitions.add(sensorDefinition.copy());
        }
        for (KinematicPointDefinition kinematicPointDefinition : other.kinematicPointDefinitions) {
            this.kinematicPointDefinitions.add(kinematicPointDefinition.copy());
        }
        for (ExternalWrenchPointDefinition externalWrenchPointDefinition : other.externalWrenchPointDefinitions) {
            this.externalWrenchPointDefinitions.add(externalWrenchPointDefinition.copy());
        }
        for (GroundContactPointDefinition groundContactPointDefinition : other.groundContactPointDefinitions) {
            this.groundContactPointDefinitions.add(groundContactPointDefinition.copy());
        }
        this.loopClosureDefinition = other.loopClosureDefinition == null ? null : other.loopClosureDefinition.copy();
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement
    public void setTransformToParent(YawPitchRollTransformDefinition transformToParent) {
        this.transformToParent = transformToParent;
    }

    public void setTransformToParent(RigidBodyTransformReadOnly transformToParent) {
        this.transformToParent.set(transformToParent);
    }

    public YawPitchRollTransformDefinition getTransformToParent() {
        return this.transformToParent;
    }

    @XmlTransient
    public void setPredecessor(RigidBodyDefinition predecessor) {
        this.predecessor = predecessor;
    }

    public RigidBodyDefinition getPredecessor() {
        return this.predecessor;
    }

    @XmlTransient
    public void setLoopClosureSuccessor(RigidBodyDefinition successor) {
        if (this.loopClosureDefinition == null) {
            this.loopClosureDefinition = new LoopClosureDefinition();
        }
        this.successor = successor;
    }

    @XmlElement
    public void setSuccessor(RigidBodyDefinition successor) {
        if (this.successor != null) {
            this.successor.setParentJoint(null);
        }
        this.successor = successor;
        if (this.successor != null) {
            this.successor.setParentJoint(this);
        }
    }

    public RigidBodyDefinition getSuccessor() {
        return this.successor;
    }

    public JointDefinition getParentJoint() {
        if (this.predecessor == null) {
            return null;
        }
        return this.predecessor.getParentJoint();
    }

    public abstract void setInitialJointState(JointStateReadOnly var1);

    public abstract JointStateBasics getInitialJointState();

    @XmlElement(name="sensor")
    public void setSensorDefinitions(List<SensorDefinition> sensorDefinitions) {
        this.sensorDefinitions = sensorDefinitions;
    }

    public void addSensorDefinition(SensorDefinition sensorDefinition) {
        this.sensorDefinitions.add(sensorDefinition);
    }

    public List<SensorDefinition> getSensorDefinitions() {
        return this.sensorDefinitions;
    }

    public <T extends SensorDefinition> List<T> getSensorDefinitions(Class<T> sensorType) {
        return this.sensorDefinitions.stream().filter(sensorType::isInstance).map(sensorType::cast).collect(Collectors.toList());
    }

    @XmlElement(name="kinematicPoint")
    public void setKinematicPointDefinitions(List<KinematicPointDefinition> kinematicPointDefinitions) {
        this.kinematicPointDefinitions = kinematicPointDefinitions;
    }

    public void addKinematicPointDefinition(KinematicPointDefinition kinematicPointDefinition) {
        this.kinematicPointDefinitions.add(kinematicPointDefinition);
    }

    public List<KinematicPointDefinition> getKinematicPointDefinitions() {
        return this.kinematicPointDefinitions;
    }

    @XmlElement(name="externalWrenchPoint")
    public void setExternalWrenchPointDefinitions(List<ExternalWrenchPointDefinition> externalWrenchPointDefinitions) {
        this.externalWrenchPointDefinitions = externalWrenchPointDefinitions;
    }

    public void addExternalWrenchPointDefinition(ExternalWrenchPointDefinition externalWrenchPointDefinition) {
        this.externalWrenchPointDefinitions.add(externalWrenchPointDefinition);
    }

    public List<ExternalWrenchPointDefinition> getExternalWrenchPointDefinitions() {
        return this.externalWrenchPointDefinitions;
    }

    @XmlElement(name="groundContactPoint")
    public void setGroundContactPointDefinitions(List<GroundContactPointDefinition> groundContactPointDefinitions) {
        this.groundContactPointDefinitions = groundContactPointDefinitions;
    }

    public void addGroundContactPointDefinition(GroundContactPointDefinition groundContactPointDefinition) {
        this.groundContactPointDefinitions.add(groundContactPointDefinition);
    }

    public List<GroundContactPointDefinition> getGroundContactPointDefinitions() {
        return this.groundContactPointDefinitions;
    }

    public void setLoopClosureDefinition(LoopClosureDefinition loopClosureDefinition) {
        this.loopClosureDefinition = loopClosureDefinition;
    }

    public boolean isLoopClosure() {
        return this.loopClosureDefinition != null;
    }

    public LoopClosureDefinition getLoopClosureDefinition() {
        return this.loopClosureDefinition;
    }

    public abstract JointBasics toJoint(RigidBodyBasics var1);

    public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.transformToParent);
        this.kinematicPointDefinitions.forEach(kp -> kp.applyTransform(transform));
        this.externalWrenchPointDefinitions.forEach(efp -> efp.applyTransform(transform));
        this.groundContactPointDefinitions.forEach(gcp -> gcp.applyTransform(transform));
        this.sensorDefinitions.forEach(sensor -> sensor.applyTransform(transform));
    }

    public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.transformToParent);
        this.kinematicPointDefinitions.forEach(kp -> kp.applyInverseTransform(transform));
        this.externalWrenchPointDefinitions.forEach(efp -> efp.applyInverseTransform(transform));
        this.groundContactPointDefinitions.forEach(gcp -> gcp.applyInverseTransform(transform));
        this.sensorDefinitions.forEach(sensor -> sensor.applyInverseTransform(transform));
    }

    public abstract JointDefinition copy();

    public JointDefinition copyRecursive() {
        JointDefinition copy = this.copy();
        if (!this.isLoopClosure()) {
            copy.setSuccessor(this.successor.copyRecursive());
        }
        return copy;
    }

    public String toString() {
        String successorString = this.successor == null ? "null" : this.successor.getName();
        return this.name + ": origin: " + this.transformToParent + ", successor: " + successorString;
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.transformToParent);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.successor);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.sensorDefinitions);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.kinematicPointDefinitions);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.externalWrenchPointDefinitions);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.groundContactPointDefinitions);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.loopClosureDefinition);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JointDefinition other = (JointDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.transformToParent, other.transformToParent)) {
            return false;
        }
        if (!Objects.equals(this.successor, other.successor)) {
            return false;
        }
        if (!Objects.equals(this.sensorDefinitions, other.sensorDefinitions)) {
            return false;
        }
        if (!Objects.equals(this.kinematicPointDefinitions, other.kinematicPointDefinitions)) {
            return false;
        }
        if (!Objects.equals(this.externalWrenchPointDefinitions, other.externalWrenchPointDefinitions)) {
            return false;
        }
        if (!Objects.equals(this.groundContactPointDefinitions, other.groundContactPointDefinitions)) {
            return false;
        }
        return Objects.equals(this.loopClosureDefinition, other.loopClosureDefinition);
    }
}

