/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Point3DDefinition;

public class Polygon3DDefinition
extends GeometryDefinition {
    private List<Point3DDefinition> polygonVertices;
    private boolean counterClockwiseOrdered;

    public Polygon3DDefinition() {
        this.setName("polygon3D");
    }

    public Polygon3DDefinition(List<Point3DDefinition> polygonVertices, boolean counterClockwiseOrdered) {
        this();
        this.polygonVertices = polygonVertices;
        this.counterClockwiseOrdered = counterClockwiseOrdered;
    }

    public Polygon3DDefinition(Polygon3DDefinition other) {
        this.setName(other.getName());
        if (other.polygonVertices != null) {
            this.polygonVertices = other.polygonVertices.stream().map(Point3DDefinition::new).collect(Collectors.toList());
        }
        this.counterClockwiseOrdered = other.counterClockwiseOrdered;
    }

    public static List<Point3DDefinition> toPoint3DDefinitionList(Collection<? extends Tuple3DReadOnly> tuple3DCollection) {
        return tuple3DCollection.stream().map(Point3DDefinition::new).collect(Collectors.toList());
    }

    public static List<Point3DDefinition> toPoint3DDefinitionList(Tuple3DReadOnly ... tuple3Ds) {
        return Polygon3DDefinition.toPoint3DDefinitionList(Arrays.asList(tuple3Ds));
    }

    @XmlElement
    public void setPolygonVertices(List<Point3DDefinition> polygonVertices) {
        this.polygonVertices = polygonVertices;
    }

    @XmlElement
    public void setCounterClockwiseOrdered(boolean counterClockwiseOrdered) {
        this.counterClockwiseOrdered = counterClockwiseOrdered;
    }

    public List<Point3DDefinition> getPolygonVertices() {
        return this.polygonVertices;
    }

    public boolean isCounterClockwiseOrdered() {
        return this.counterClockwiseOrdered;
    }

    @Override
    public Polygon3DDefinition copy() {
        return new Polygon3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.polygonVertices);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.counterClockwiseOrdered);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Polygon3DDefinition other = (Polygon3DDefinition)object;
        if (!Objects.equals(this.polygonVertices, other.polygonVertices)) {
            return false;
        }
        return this.counterClockwiseOrdered == other.counterClockwiseOrdered;
    }

    public String toString() {
        String ordering = this.counterClockwiseOrdered ? "counter-clockwise" : "clockwise";
        return "Polygon 3D: [name: " + this.getName() + ", " + ordering + ", vertices: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", this.polygonVertices, Object::toString);
    }
}

