/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;

@XmlRootElement(name="YoQuaternion")
public class YoQuaternionDefinition
extends YoOrientation3DDefinition {
    public static final String YoQuaternion = "YoQuaternion";
    public static final String[] YoQuaternionIdentifiers = new String[]{"qx", "qy", "qz", "qs"};
    public static final List<String[]> YoQuaternionAlternateIdentifiers = Collections.singletonList(new String[]{"x, y, z, w"});
    private String x;
    private String y;
    private String z;
    private String s;
    private String referenceFrame;

    public YoQuaternionDefinition() {
    }

    public YoQuaternionDefinition(String x, String y, String z, String s) {
        this(x, y, z, s, null);
    }

    public YoQuaternionDefinition(String x, String y, String z, String s, String referenceFrame) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.s = s;
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.x = Double.toString(x);
    }

    @XmlElement
    public void setX(String x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = Double.toString(y);
    }

    @XmlElement
    public void setY(String y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = Double.toString(z);
    }

    @XmlElement
    public void setZ(String z) {
        this.z = z;
    }

    public void setS(double s) {
        this.s = Double.toString(s);
    }

    @XmlElement
    public void setS(String s) {
        this.s = s;
    }

    @Override
    @XmlElement
    public void setReferenceFrame(String referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public String getS() {
        return this.s;
    }

    @Override
    public String getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public String getType() {
        return YoQuaternion;
    }

    @Override
    public String[] getComponentIdentifiers() {
        return YoQuaternionIdentifiers;
    }

    @Override
    public List<String[]> getAlternateComponentIdentifiers() {
        return YoQuaternionAlternateIdentifiers;
    }

    @Override
    public String[] getComponentValues() {
        return new String[]{this.x, this.y, this.z, this.s};
    }

    @Override
    public YoQuaternionDefinition copy() {
        return new YoQuaternionDefinition(this.x, this.y, this.z, this.s, this.referenceFrame);
    }

    public static YoQuaternionDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith(YoQuaternion)) {
            value = value.substring(value.indexOf("=") + 1).trim();
            String x = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String y = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String z = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String s = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String frame = value.substring(0, value.length() - 1);
            if (x.equalsIgnoreCase("null")) {
                x = null;
            }
            if (y.equalsIgnoreCase("null")) {
                y = null;
            }
            if (z.equalsIgnoreCase("null")) {
                z = null;
            }
            if (s.equalsIgnoreCase("null")) {
                s = null;
            }
            if (frame.equalsIgnoreCase("null")) {
                frame = null;
            }
            return new YoQuaternionDefinition(x, y, z, s, frame);
        }
        throw new IllegalArgumentException("Unknown quaternion format: " + value);
    }
}

