/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.terrain;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

@XmlRootElement(name="Terrain")
public class TerrainObjectDefinition {
    private String name;
    private List<VisualDefinition> visualDefinitions = new ArrayList<VisualDefinition>();
    private List<CollisionShapeDefinition> collisionShapeDefinitions = new ArrayList<CollisionShapeDefinition>();
    private ClassLoader resourceClassLoader;

    public TerrainObjectDefinition() {
    }

    public TerrainObjectDefinition(VisualDefinition visualDefinition, CollisionShapeDefinition collisionShapeDefinition) {
        this.visualDefinitions.add(visualDefinition);
        this.collisionShapeDefinitions.add(collisionShapeDefinition);
    }

    public TerrainObjectDefinition(TerrainObjectDefinition other) {
        this.name = other.name;
        for (VisualDefinition visualDefinition : other.visualDefinitions) {
            this.visualDefinitions.add(visualDefinition.copy());
        }
        for (CollisionShapeDefinition collisionShapeDefinition : other.collisionShapeDefinitions) {
            this.collisionShapeDefinitions.add(collisionShapeDefinition.copy());
        }
    }

    @XmlElement
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement(name="visual")
    public void setVisualDefinitions(List<VisualDefinition> visualDefinitions) {
        this.visualDefinitions = visualDefinitions;
    }

    public void addVisualDefinition(VisualDefinition visualDefinition) {
        this.visualDefinitions.add(visualDefinition);
    }

    public List<VisualDefinition> getVisualDefinitions() {
        return this.visualDefinitions;
    }

    @XmlElement(name="collision")
    public void setCollisionShapeDefinitions(List<CollisionShapeDefinition> collisionShapeDefinitions) {
        this.collisionShapeDefinitions = collisionShapeDefinitions;
    }

    public void addCollisionShapeDefinition(CollisionShapeDefinition collisionShapeDefinition) {
        this.collisionShapeDefinitions.add(collisionShapeDefinition);
    }

    public List<CollisionShapeDefinition> getCollisionShapeDefinitions() {
        return this.collisionShapeDefinitions;
    }

    @XmlTransient
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public TerrainObjectDefinition copy() {
        return new TerrainObjectDefinition(this);
    }
}

