/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.FixedJointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.visual.VisualDefinition;

@XmlRootElement(name="Robot")
public class RobotDefinition {
    public static final JointCreator DEFAULT_JOINT_BUILDER = (predecessor, definition) -> definition.toJoint(predecessor);
    public static final RootBodyCreator DEFAULT_ROOT_BODY_BUILDER = (rootFrame, definition) -> definition.toRootBody(rootFrame);
    public static final RigidBodyCreator DEFAULT_RIGID_BODY_BUILDER = (parentJoint, definition) -> definition.toRigidBody(parentJoint);
    private String name;
    private RigidBodyDefinition rootBodyDefinition;
    private List<String> nameOfJointsToIgnore = new ArrayList<String>();
    private final List<ControllerDefinition> controllerDefinitions = new ArrayList<ControllerDefinition>();
    private ClassLoader resourceClassLoader;

    public RobotDefinition() {
    }

    public RobotDefinition(String name) {
        this.setName(name);
    }

    public RobotDefinition(RobotDefinition other) {
        this.name = other.name;
        this.rootBodyDefinition = other.rootBodyDefinition == null ? null : other.rootBodyDefinition.copyRecursive();
        for (JointDefinition jointDefinition : this.getAllJoints()) {
            if (!jointDefinition.isLoopClosure()) continue;
            String successorName = other.getJointDefinition(jointDefinition.getName()).getSuccessor().getName();
            RigidBodyDefinition rigidBodyDefinition = this.getRigidBodyDefinition(successorName);
            jointDefinition.setLoopClosureSuccessor(rigidBodyDefinition);
        }
        this.nameOfJointsToIgnore.addAll(other.nameOfJointsToIgnore);
        this.resourceClassLoader = other.resourceClassLoader;
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="rootBody")
    public void setRootBodyDefinition(RigidBodyDefinition rootBodyDefinition) {
        this.rootBodyDefinition = rootBodyDefinition;
    }

    public void ignoreAllJoints() {
        for (JointDefinition jointDefinition : RobotDefinition.collectSubtreeJointDefinitions(this.rootBodyDefinition)) {
            this.addJointToIgnore(jointDefinition.getName());
        }
    }

    @XmlElement(name="jointToIgnore")
    public void setNameOfJointsToIgnore(List<String> nameOfJointsToIgnore) {
        this.nameOfJointsToIgnore = nameOfJointsToIgnore;
    }

    public void addJointToIgnore(String nameOfJointToIgnore) {
        this.nameOfJointsToIgnore.add(nameOfJointToIgnore);
    }

    public void addSubtreeJointsToIgnore(String nameOfLastJointToConsider) {
        List<JointDefinition> definitionOfJointsToIgnore = RobotDefinition.collectSubtreeJointDefinitions(this.getJointDefinition(nameOfLastJointToConsider).getSuccessor());
        for (JointDefinition jointDefinition : definitionOfJointsToIgnore) {
            this.nameOfJointsToIgnore.add(jointDefinition.getName());
        }
    }

    public void addControllerDefinition(ControllerDefinition controllerDefinition) {
        this.controllerDefinitions.add(controllerDefinition);
    }

    public void simplifyKinematics() {
        this.simplifyKinematics(null);
    }

    public void simplifyKinematics(Predicate<FixedJointDefinition> simplifyKinematicsFilter) {
        for (int i = 0; i < this.rootBodyDefinition.getChildrenJoints().size(); ++i) {
            RobotDefinition.simplifyKinematics(this.rootBodyDefinition.getChildrenJoints().get(i), simplifyKinematicsFilter);
        }
    }

    public void transformAllFramesToZUp() {
        for (int i = 0; i < this.rootBodyDefinition.getChildrenJoints().size(); ++i) {
            RobotDefinition.transformAllFramesToZUp(this.rootBodyDefinition.getChildrenJoints().get(i));
        }
    }

    public void sanitizeNames() {
        this.forEachJointDefinition(jointDefinition -> {
            String sanitizedName = jointDefinition.getName();
            sanitizedName = sanitizedName.replace('.', '_');
            jointDefinition.setName(sanitizedName);
        });
        this.forEachRigidBodyDefinition(rigidBodyDefinition -> {
            String sanitizedName = rigidBodyDefinition.getName();
            sanitizedName = sanitizedName.replace('.', '_');
            rigidBodyDefinition.setName(sanitizedName);
        });
    }

    @XmlTransient
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public String getName() {
        return this.name;
    }

    public RigidBodyDefinition getRootBodyDefinition() {
        return this.rootBodyDefinition;
    }

    public SixDoFJointDefinition getFloatingRootJointDefinition() {
        if (this.rootBodyDefinition == null) {
            return null;
        }
        if (this.rootBodyDefinition.getChildrenJoints().size() != 1) {
            return null;
        }
        JointDefinition jointDefinition = this.getRootJointDefinitions().get(0);
        if (jointDefinition instanceof SixDoFJointDefinition) {
            return (SixDoFJointDefinition)jointDefinition;
        }
        return null;
    }

    public List<JointDefinition> getRootJointDefinitions() {
        return this.rootBodyDefinition.getChildrenJoints();
    }

    public List<String> getNameOfJointsToIgnore() {
        return this.nameOfJointsToIgnore;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public JointDefinition getJointDefinition(String jointName) {
        return RobotDefinition.findJointDefinition(this.rootBodyDefinition, jointName);
    }

    public OneDoFJointDefinition getOneDoFJointDefinition(String jointName) {
        JointDefinition jointDefinition = this.getJointDefinition(jointName);
        if (jointDefinition instanceof OneDoFJointDefinition) {
            return (OneDoFJointDefinition)jointDefinition;
        }
        return null;
    }

    public RigidBodyDefinition getRigidBodyDefinition(String bodyName) {
        return RobotDefinition.findRigidBodyDefinition(this.rootBodyDefinition, bodyName);
    }

    public void forEachJointDefinition(Consumer<JointDefinition> jointConsumer) {
        RobotDefinition.forEachJointDefinition(this.rootBodyDefinition, jointConsumer);
    }

    public void forEachOneDoFJointDefinition(Consumer<OneDoFJointDefinition> jointConsumer) {
        RobotDefinition.forEachJointDefinition(this.rootBodyDefinition, joint -> {
            if (joint instanceof OneDoFJointDefinition) {
                jointConsumer.accept((OneDoFJointDefinition)joint);
            }
        });
    }

    public void forEachRigidBodyDefinition(Consumer<RigidBodyDefinition> rigidBodyConsumer) {
        RobotDefinition.forEachRigidBodyDefinition(this.rootBodyDefinition, rigidBodyConsumer);
    }

    public List<JointDefinition> getAllJoints() {
        ArrayList<JointDefinition> joints = new ArrayList<JointDefinition>();
        this.forEachJointDefinition(joints::add);
        return joints;
    }

    public List<OneDoFJointDefinition> getAllOneDoFJoints() {
        ArrayList<OneDoFJointDefinition> joints = new ArrayList<OneDoFJointDefinition>();
        this.forEachOneDoFJointDefinition(joints::add);
        return joints;
    }

    public List<RigidBodyDefinition> getAllRigidBodies() {
        return RobotDefinition.collectSubtreeRigidBodyDefinitions(this.rootBodyDefinition);
    }

    public List<ControllerDefinition> getControllerDefinitions() {
        return this.controllerDefinitions;
    }

    public RigidBodyBasics newInstance(ReferenceFrame rootFrame) {
        return this.newInstance(rootFrame, DEFAULT_ROOT_BODY_BUILDER, DEFAULT_JOINT_BUILDER, DEFAULT_RIGID_BODY_BUILDER);
    }

    public RigidBodyBasics newInstance(ReferenceFrame rootFrame, RootBodyCreator rootBodyCreator, JointCreator jointCreator, RigidBodyCreator rigidBodyCreator) {
        if (this.rootBodyDefinition == null) {
            throw new NullPointerException("The robot " + this.name + " has no definition!");
        }
        RigidBodyBasics rootBody = rootBodyCreator.newRootBody(rootFrame, this.rootBodyDefinition);
        this.instantiateRecursively(rootBody, this.rootBodyDefinition, jointCreator, rigidBodyCreator);
        RobotDefinition.closeLoops(rootBody, this.rootBodyDefinition);
        return rootBody;
    }

    private void instantiateRecursively(RigidBodyBasics predecessor, RigidBodyDefinition predecessorDefinition, JointCreator jointCreator, RigidBodyCreator rigidBodyCreator) {
        for (JointDefinition childDefinition : predecessorDefinition.getChildrenJoints()) {
            JointBasics child = jointCreator.newJoint(predecessor, childDefinition);
            if (childDefinition.isLoopClosure()) continue;
            RigidBodyDefinition successorDefinition = childDefinition.getSuccessor();
            if (successorDefinition == null) {
                throw new NullPointerException("The joint " + child.getName() + " is missing the definition for its successor, robot name: " + this.name + ".");
            }
            RigidBodyBasics successor = rigidBodyCreator.newRigidBody(child, successorDefinition);
            this.instantiateRecursively(successor, successorDefinition, jointCreator, rigidBodyCreator);
        }
    }

    public static void closeLoops(RigidBodyBasics predecessor, RigidBodyDefinition predecessorDefinition) {
        if (predecessor == null) {
            return;
        }
        for (int i = 0; i < predecessor.getChildrenJoints().size(); ++i) {
            JointBasics joint = (JointBasics)predecessor.getChildrenJoints().get(i);
            JointDefinition jointDefinition = predecessorDefinition.getChildrenJoints().get(i);
            if (jointDefinition.isLoopClosure()) {
                RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)predecessor);
                RigidBodyBasics successor = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)jointDefinition.getSuccessor().getName());
                YawPitchRollTransformDefinition transformFromSuccessorParentJoint = jointDefinition.getLoopClosureDefinition().getTransformToSuccessorParent();
                joint.setupLoopClosure(successor, (RigidBodyTransformReadOnly)transformFromSuccessorParentJoint);
            }
            RobotDefinition.closeLoops(joint.getSuccessor(), jointDefinition.getSuccessor());
        }
    }

    public static List<JointDefinition> collectSubtreeJointDefinitions(RigidBodyDefinition start) {
        ArrayList<JointDefinition> joints = new ArrayList<JointDefinition>();
        RobotDefinition.forEachJointDefinition(start, joints::add);
        return joints;
    }

    public static List<RigidBodyDefinition> collectSubtreeRigidBodyDefinitions(RigidBodyDefinition start) {
        ArrayList<RigidBodyDefinition> rigidBodies = new ArrayList<RigidBodyDefinition>();
        RobotDefinition.forEachRigidBodyDefinition(start, rigidBodies::add);
        return rigidBodies;
    }

    public static JointDefinition findJointDefinition(RigidBodyDefinition start, String jointName) {
        if (start == null) {
            return null;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = start.getChildrenJoints().get(i);
            if (jointDefinition.getName().equals(jointName)) {
                return jointDefinition;
            }
            JointDefinition result = RobotDefinition.findJointDefinition(jointDefinition.getSuccessor(), jointName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void initializeRobotState(RobotDefinition robotDefinition, RigidBodyBasics rootBody) {
        RobotDefinition.initializeRobotStateRecursive(robotDefinition.getRootBodyDefinition(), rootBody);
    }

    private static void initializeRobotStateRecursive(RigidBodyDefinition definition, RigidBodyBasics rigidBody) {
        if (definition.getChildrenJoints().size() != rigidBody.getChildrenJoints().size()) {
            throw new IllegalArgumentException("Robot mismatch at rigid-body: " + definition.getName());
        }
        for (int i = 0; i < definition.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = definition.getChildrenJoints().get(i);
            JointBasics joint = (JointBasics)rigidBody.getChildrenJoints().get(i);
            if (!jointDefinition.getName().equals(joint.getName())) {
                throw new IllegalArgumentException("Definition incompatible with robot. Expected joint: " + definition.getName() + ", was: " + joint.getName());
            }
            JointStateBasics initialJointState = jointDefinition.getInitialJointState();
            if (initialJointState != null) {
                if (initialJointState.hasOutputFor(JointStateType.CONFIGURATION)) {
                    initialJointState.getConfiguration(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.VELOCITY)) {
                    initialJointState.getVelocity(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.ACCELERATION)) {
                    initialJointState.getAcceleration(joint);
                }
                if (initialJointState.hasOutputFor(JointStateType.EFFORT)) {
                    initialJointState.getEffort(joint);
                }
            }
            RobotDefinition.initializeRobotStateRecursive(jointDefinition.getSuccessor(), joint.getSuccessor());
        }
    }

    public static RigidBodyDefinition findRigidBodyDefinition(RigidBodyDefinition start, String rigidBodyName) {
        if (start == null) {
            return null;
        }
        if (start.getName().equals(rigidBodyName)) {
            return start;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            RigidBodyDefinition result = RobotDefinition.findRigidBodyDefinition(start.getChildrenJoints().get(i).getSuccessor(), rigidBodyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void forEachJointDefinition(RigidBodyDefinition start, Consumer<JointDefinition> jointConsumer) {
        if (start == null) {
            return;
        }
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            JointDefinition jointDefinition = start.getChildrenJoints().get(i);
            jointConsumer.accept(jointDefinition);
            RobotDefinition.forEachJointDefinition(jointDefinition.getSuccessor(), jointConsumer);
        }
    }

    public static void forEachRigidBodyDefinition(RigidBodyDefinition start, Consumer<RigidBodyDefinition> rigidBodyConsumer) {
        if (start == null) {
            return;
        }
        rigidBodyConsumer.accept(start);
        for (int i = 0; i < start.getChildrenJoints().size(); ++i) {
            RobotDefinition.forEachRigidBodyDefinition(start.getChildrenJoints().get(i).getSuccessor(), rigidBodyConsumer);
        }
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.rootBodyDefinition);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.nameOfJointsToIgnore);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.controllerDefinitions);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RobotDefinition other = (RobotDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.rootBodyDefinition, other.rootBodyDefinition)) {
            return false;
        }
        if (!Objects.equals(this.nameOfJointsToIgnore, other.nameOfJointsToIgnore)) {
            return false;
        }
        return Objects.equals(this.controllerDefinitions, other.controllerDefinitions);
    }

    public static void transformAllFramesToZUp(JointDefinition jointDefinition) {
        RobotDefinition.transformAllFramesToZUp(jointDefinition, (RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)jointDefinition.getTransformToParent()));
    }

    private static void transformAllFramesToZUp(JointDefinition jointDefinition, RigidBodyTransformReadOnly jointTransform) {
        Orientation3DReadOnly jointRotation = jointTransform.getRotation();
        if (jointDefinition instanceof OneDoFJointDefinition) {
            jointRotation.transform((Tuple3DBasics)((OneDoFJointDefinition)jointDefinition).getAxis());
        }
        RigidBodyDefinition linkDefinition = jointDefinition.getSuccessor();
        RigidBodyTransform inertiaPose = new RigidBodyTransform((RigidBodyTransformReadOnly)linkDefinition.getInertiaPose());
        inertiaPose.prependOrientation(jointRotation);
        Matrix3D momentOfInertia = new Matrix3D((Matrix3DReadOnly)linkDefinition.getMomentOfInertia());
        inertiaPose.transform((Matrix3DBasics)momentOfInertia);
        linkDefinition.getMomentOfInertia().set((Matrix3DReadOnly)momentOfInertia);
        linkDefinition.getInertiaPose().getRotation().setToZero();
        linkDefinition.getInertiaPose().getTranslation().set((Tuple3DReadOnly)inertiaPose.getTranslation());
        for (KinematicPointDefinition kinematicPointDefinition : jointDefinition.getKinematicPointDefinitions()) {
            kinematicPointDefinition.getTransformToParent().prependOrientation(jointRotation);
        }
        for (ExternalWrenchPointDefinition externalWrenchPointDefinition : jointDefinition.getExternalWrenchPointDefinitions()) {
            externalWrenchPointDefinition.getTransformToParent().prependOrientation(jointRotation);
        }
        for (GroundContactPointDefinition groundContactPointDefinition : jointDefinition.getGroundContactPointDefinitions()) {
            groundContactPointDefinition.getTransformToParent().prependOrientation(jointRotation);
        }
        for (SensorDefinition sensorDefinition : jointDefinition.getSensorDefinitions()) {
            sensorDefinition.getTransformToJoint().prependOrientation(jointRotation);
        }
        for (VisualDefinition visualDefinition : linkDefinition.getVisualDefinitions()) {
            visualDefinition.getOriginPose().prependOrientation(jointRotation);
        }
        for (CollisionShapeDefinition collisionShapeDefinition : linkDefinition.getCollisionShapeDefinitions()) {
            collisionShapeDefinition.getOriginPose().prependOrientation(jointRotation);
        }
        for (JointDefinition childDefinition : jointDefinition.getSuccessor().getChildrenJoints()) {
            RigidBodyTransform childTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)childDefinition.getTransformToParent());
            childTransform.prependOrientation(jointRotation);
            childDefinition.getTransformToParent().set((RigidBodyTransformReadOnly)childTransform);
            RobotDefinition.transformAllFramesToZUp(childDefinition, (RigidBodyTransformReadOnly)childTransform);
        }
        jointDefinition.getTransformToParent().getRotation().setToZero();
    }

    public static void simplifyKinematics(JointDefinition joint, Predicate<FixedJointDefinition> filter) {
        int i = 0;
        while (i < joint.getSuccessor().getChildrenJoints().size()) {
            List<JointDefinition> children = joint.getSuccessor().getChildrenJoints();
            JointDefinition child2 = children.get(i);
            if (!(child2 instanceof FixedJointDefinition)) {
                ++i;
            }
            RobotDefinition.simplifyKinematics(child2, filter);
        }
        JointDefinition parentJoint = joint.getParentJoint();
        if (parentJoint == null) {
            return;
        }
        if (joint instanceof FixedJointDefinition) {
            FixedJointDefinition fixedJoint = (FixedJointDefinition)joint;
            if (filter == null || filter.test(fixedJoint)) {
                RigidBodyDefinition rigidBody = joint.getSuccessor();
                YawPitchRollTransformDefinition transformToParentJoint = joint.getTransformToParent();
                rigidBody.applyTransform((Transform)transformToParentJoint);
                RigidBodyDefinition oldParentRigidBody = parentJoint.getSuccessor();
                parentJoint.setSuccessor(RobotDefinition.merge(oldParentRigidBody.getName(), oldParentRigidBody, rigidBody));
                parentJoint.getSuccessor().addChildJoints(oldParentRigidBody.getChildrenJoints());
                joint.getKinematicPointDefinitions().removeIf(kp -> {
                    kp.applyTransform((Transform)transformToParentJoint);
                    parentJoint.addKinematicPointDefinition((KinematicPointDefinition)kp);
                    return true;
                });
                joint.getExternalWrenchPointDefinitions().removeIf(efp -> {
                    efp.applyTransform((Transform)transformToParentJoint);
                    parentJoint.addExternalWrenchPointDefinition((ExternalWrenchPointDefinition)efp);
                    return true;
                });
                joint.getGroundContactPointDefinitions().removeIf(gcp -> {
                    gcp.applyTransform((Transform)transformToParentJoint);
                    parentJoint.addGroundContactPointDefinition((GroundContactPointDefinition)gcp);
                    return true;
                });
                joint.getSensorDefinitions().removeIf(sensor -> {
                    sensor.applyTransform((Transform)transformToParentJoint);
                    parentJoint.addSensorDefinition((SensorDefinition)sensor);
                    return true;
                });
                joint.getSuccessor().getChildrenJoints().removeIf(child -> {
                    child.getTransformToParent().preMultiply((RigidBodyTransformReadOnly)transformToParentJoint);
                    parentJoint.getSuccessor().addChildJoint((JointDefinition)child);
                    return true;
                });
                parentJoint.getSuccessor().removeChildJoint(joint);
            }
        }
    }

    public static RigidBodyDefinition merge(String name, RigidBodyDefinition rigidBodyA, RigidBodyDefinition rigidBodyB) {
        double mergedMass = rigidBodyA.getMass() + rigidBodyB.getMass();
        Vector3D mergedCoM = new Vector3D();
        mergedCoM.setAndScale(rigidBodyA.getMass(), (Tuple3DReadOnly)rigidBodyA.getCenterOfMassOffset());
        mergedCoM.scaleAdd(rigidBodyB.getMass(), (Tuple3DReadOnly)rigidBodyB.getCenterOfMassOffset(), (Tuple3DReadOnly)mergedCoM);
        mergedCoM.scale(1.0 / mergedMass);
        Vector3D translationInertiaA = new Vector3D();
        translationInertiaA.sub((Tuple3DReadOnly)mergedCoM, (Tuple3DReadOnly)rigidBodyA.getCenterOfMassOffset());
        Matrix3D inertiaA = new Matrix3D((Matrix3DReadOnly)rigidBodyA.getMomentOfInertia());
        MecanoTools.translateMomentOfInertia((double)rigidBodyA.getMass(), null, (boolean)false, (Tuple3DReadOnly)translationInertiaA, (Matrix3DBasics)inertiaA);
        Vector3D translationInertiaB = new Vector3D();
        translationInertiaB.sub((Tuple3DReadOnly)mergedCoM, (Tuple3DReadOnly)rigidBodyB.getCenterOfMassOffset());
        Matrix3D inertiaB = new Matrix3D((Matrix3DReadOnly)rigidBodyB.getMomentOfInertia());
        MecanoTools.translateMomentOfInertia((double)rigidBodyB.getMass(), null, (boolean)false, (Tuple3DReadOnly)translationInertiaB, (Matrix3DBasics)inertiaB);
        Matrix3D mergedInertia = new Matrix3D();
        mergedInertia.add((Matrix3DReadOnly)inertiaA);
        mergedInertia.add((Matrix3DReadOnly)inertiaB);
        RigidBodyDefinition merged = new RigidBodyDefinition(name);
        merged.setMass(mergedMass);
        merged.getInertiaPose().getTranslation().set(mergedCoM);
        merged.getMomentOfInertia().set((Matrix3DReadOnly)mergedInertia);
        ArrayList<VisualDefinition> mergedGraphics = new ArrayList<VisualDefinition>();
        mergedGraphics.addAll(rigidBodyA.getVisualDefinitions());
        mergedGraphics.addAll(rigidBodyB.getVisualDefinitions());
        merged.addVisualDefinitions(mergedGraphics);
        ArrayList<CollisionShapeDefinition> mergedCollisions = new ArrayList<CollisionShapeDefinition>();
        mergedCollisions.addAll(rigidBodyA.getCollisionShapeDefinitions());
        mergedCollisions.addAll(rigidBodyB.getCollisionShapeDefinitions());
        merged.addCollisionShapeDefinitions(mergedCollisions);
        return merged;
    }

    public static interface RootBodyCreator {
        public RigidBodyBasics newRootBody(ReferenceFrame var1, RigidBodyDefinition var2);
    }

    public static interface JointCreator {
        public JointBasics newJoint(RigidBodyBasics var1, JointDefinition var2);
    }

    public static interface RigidBodyCreator {
        public RigidBodyBasics newRigidBody(JointBasics var1, RigidBodyDefinition var2);
    }
}

