/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Capsule3DDefinition
extends GeometryDefinition {
    private double length;
    private double radiusX;
    private double radiusY;
    private double radiusZ;
    private int resolution = 64;

    public Capsule3DDefinition() {
        this.setName("capsule");
    }

    public Capsule3DDefinition(double length, double radius) {
        this(length, radius, radius, radius);
    }

    public Capsule3DDefinition(double length, double radiusX, double radiusY, double radiusZ) {
        this();
        this.length = length;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    public Capsule3DDefinition(double length, double radius, int resolution) {
        this(length, radius, radius, radius, resolution);
    }

    public Capsule3DDefinition(double length, double radiusX, double radiusY, double radiusZ, int resolution) {
        this();
        this.length = length;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.resolution = resolution;
    }

    public Capsule3DDefinition(Capsule3DDefinition other) {
        this.setName(other.getName());
        this.length = other.length;
        this.radiusX = other.radiusX;
        this.radiusY = other.radiusY;
        this.radiusZ = other.radiusZ;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setLength(double length) {
        this.length = length;
    }

    public boolean isRegular() {
        return this.radiusX == this.radiusY && this.radiusX == this.radiusZ;
    }

    @XmlElement
    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    @XmlElement
    public void setRadiusY(double radiusY) {
        this.radiusY = radiusY;
    }

    @XmlElement
    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public void setRadius(double radius) {
        this.setRadii(radius, radius, radius);
    }

    public void setRadii(double radiusX, double radiusY, double radiusZ) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getLength() {
        return this.length;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Capsule3DDefinition copy() {
        return new Capsule3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.length);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.resolution);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Capsule3DDefinition other = (Capsule3DDefinition)object;
        if (!EuclidCoreTools.equals((double)this.length, (double)other.length)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.radiusX, (double)other.radiusX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.radiusY, (double)other.radiusY)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.radiusZ, (double)other.radiusZ)) {
            return false;
        }
        return this.resolution == other.resolution;
    }

    public String toString() {
        return "Capsule: [name: " + this.getName() + ", length: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.length) + EuclidCoreIOTools.getStringOf((String)", radii: (", (String)")", (String)", ", (double[])new double[]{this.radiusX, this.radiusY, this.radiusZ}) + ", resolution: " + this.resolution + "]";
    }
}

