/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.camera;

import jakarta.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;

public class YoOrbitalCoordinateDefinition
extends YoCompositeDefinition {
    public static final String YoOrbital = "YoOrbitalCoordinate";
    public static final String[] YoOrbitalIdentifiers = new String[]{"distance", "longitude", "latitude"};
    private String distance;
    private String longitude;
    private String latitude;
    private String referenceFrame;

    public YoOrbitalCoordinateDefinition() {
    }

    public YoOrbitalCoordinateDefinition(String distance, String longitude, String latitude) {
        this(distance, longitude, latitude, null);
    }

    public YoOrbitalCoordinateDefinition(String distance, String longitude, String latitude, String referenceFrame) {
        this.distance = distance;
        this.longitude = longitude;
        this.latitude = latitude;
        this.referenceFrame = referenceFrame;
    }

    public void setDistance(double distance) {
        this.distance = Double.toString(distance);
    }

    @XmlElement
    public void setDistance(String distance) {
        this.distance = distance;
    }

    public void setLongitude(double longitude) {
        this.longitude = Double.toString(longitude);
    }

    @XmlElement
    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = Double.toString(latitude);
    }

    @XmlElement
    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @Override
    @XmlElement
    public void setReferenceFrame(String referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String getDistance() {
        return this.distance;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    @Override
    public String getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public String getType() {
        return YoOrbital;
    }

    @Override
    public String[] getComponentIdentifiers() {
        return YoOrbitalIdentifiers;
    }

    @Override
    public String[] getComponentValues() {
        return new String[]{this.distance, this.longitude, this.latitude};
    }

    public static YoOrbitalCoordinateDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith(YoOrbital)) {
            value = value.substring(value.indexOf("=") + 1).trim();
            String distance = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String longitude = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String latitude = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String frame = value.substring(0, value.length() - 1);
            if (distance.equalsIgnoreCase("null")) {
                distance = null;
            }
            if (longitude.equalsIgnoreCase("null")) {
                longitude = null;
            }
            if (latitude.equalsIgnoreCase("null")) {
                latitude = null;
            }
            if (frame.equalsIgnoreCase("null")) {
                frame = null;
            }
            return new YoOrbitalCoordinateDefinition(distance, longitude, latitude, frame);
        }
        throw new IllegalArgumentException("Unknown format: " + value);
    }
}

