/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;

@XmlRootElement(name="YoTuple3D")
public class YoTuple3DDefinition
extends YoCompositeDefinition {
    public static final String YoTuple3D = "YoTuple3D";
    public static final String[] YoTuple3DIdentifiers = new String[]{"x", "y", "z"};
    private String x;
    private String y;
    private String z;
    private String referenceFrame;

    public YoTuple3DDefinition() {
    }

    public YoTuple3DDefinition(String x, String y, String z) {
        this(x, y, z, null);
    }

    public YoTuple3DDefinition(String x, String y, String z, String referenceFrame) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.x = Double.toString(x);
    }

    @XmlElement
    public void setX(String x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = Double.toString(y);
    }

    @XmlElement
    public void setY(String y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = Double.toString(z);
    }

    @XmlElement
    public void setZ(String z) {
        this.z = z;
    }

    @Override
    @XmlElement
    public void setReferenceFrame(String referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    @Override
    public String getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public String getType() {
        return YoTuple3D;
    }

    @Override
    public String[] getComponentIdentifiers() {
        return YoTuple3DIdentifiers;
    }

    @Override
    public String[] getComponentValues() {
        return new String[]{this.x, this.y, this.z};
    }

    public YoTuple3DDefinition copy() {
        return new YoTuple3DDefinition(this.x, this.y, this.z, this.referenceFrame);
    }

    public static YoTuple3DDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith(YoTuple3D)) {
            value = value.substring(value.indexOf("=") + 1).trim();
            String x = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String y = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String z = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String frame = value.substring(0, value.length() - 1);
            if (x.equalsIgnoreCase("null")) {
                x = null;
            }
            if (y.equalsIgnoreCase("null")) {
                y = null;
            }
            if (z.equalsIgnoreCase("null")) {
                z = null;
            }
            if (frame.equalsIgnoreCase("null")) {
                frame = null;
            }
            return new YoTuple3DDefinition(x, y, z, frame);
        }
        throw new IllegalArgumentException("Unknown tuple 3D format: " + value);
    }
}

