/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;

@XmlRootElement(name="YoGraphicPointcloud3D")
public class YoGraphicPointcloud2DDefinition
extends YoGraphic2DDefinition {
    private List<YoTuple2DDefinition> points;
    private String numberOfPoints;
    private String size;
    private String graphicName;

    public YoGraphicPointcloud2DDefinition() {
    }

    public YoGraphicPointcloud2DDefinition(YoGraphicPointcloud2DDefinition other) {
        super(other);
        this.points = other.points != null ? other.points.stream().map(YoTuple2DDefinition::copy).toList() : null;
        this.numberOfPoints = other.numberOfPoints;
        this.size = other.size;
        this.graphicName = other.graphicName;
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerListField("points", this::getPoints, this::setPoints, "p", Object::toString, YoTuple2DDefinition::parse);
        this.registerStringField("numberOfPoints", this::getNumberOfPoints, this::setNumberOfPoints);
        this.registerStringField("size", this::getSize, this::setSize);
        this.registerStringField("graphicName", this::getGraphicName, this::setGraphicName);
    }

    @XmlElement
    public void setPoints(List<YoTuple2DDefinition> points) {
        this.points = points;
    }

    @XmlElement
    public void setNumberOfPoints(String numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public void setSize(double size) {
        this.setSize(Double.toString(size));
    }

    @XmlElement
    public void setSize(String size) {
        this.size = size;
    }

    @XmlElement
    public void setGraphicName(String graphicName) {
        this.graphicName = graphicName;
    }

    public List<YoTuple2DDefinition> getPoints() {
        return this.points;
    }

    public String getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public String getSize() {
        return this.size;
    }

    public String getGraphicName() {
        return this.graphicName;
    }

    @Override
    public YoGraphicPointcloud2DDefinition copy() {
        return new YoGraphicPointcloud2DDefinition(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphicPointcloud2DDefinition) {
            YoGraphicPointcloud2DDefinition other = (YoGraphicPointcloud2DDefinition)object;
            if (!Objects.equals(this.points, other.points)) {
                return false;
            }
            if (!Objects.equals(this.numberOfPoints, other.numberOfPoints)) {
                return false;
            }
            if (!Objects.equals(this.size, other.size)) {
                return false;
            }
            return Objects.equals(this.graphicName, other.graphicName);
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        String out = "%s [name=%s, visible=%b, fillColor=%s, strokeColor=%s, strokeWidth=%s, points=%s, numberOfPoints=%s, size=%s, graphicName=%s]";
        return out.formatted(this.getClass().getSimpleName(), this.name, this.visible, this.fillColor, this.strokeColor, this.strokeWidth, YoGraphicPointcloud2DDefinition.indentedListString(indent, true, this.points, Object::toString), this.numberOfPoints, this.size, this.graphicName);
    }
}

