/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;

public abstract class YoGraphic2DDefinition
extends YoGraphicDefinition {
    protected PaintDefinition fillColor;
    protected PaintDefinition strokeColor;
    protected String strokeWidth;

    public YoGraphic2DDefinition() {
    }

    public YoGraphic2DDefinition(YoGraphic2DDefinition other) {
        super(other);
        this.fillColor = other.fillColor == null ? null : other.fillColor.copy();
        this.strokeColor = other.strokeColor == null ? null : other.strokeColor.copy();
        this.strokeWidth = other.strokeWidth;
    }

    @Override
    protected void registerFields() {
        super.registerFields();
        this.registerPaintField("fillColor", this::getFillColor, this::setFillColor);
        this.registerPaintField("strokeColor", this::getStrokeColor, this::setStrokeColor);
        this.registerStringField("strokeWidth", this::getStrokeWidth, this::setStrokeWidth);
    }

    @XmlElement(name="fillColorNew")
    public final void setFillColor(PaintDefinition fillColor) {
        this.fillColor = fillColor;
    }

    @XmlElement(name="strokeColorNew")
    public final void setStrokeColor(PaintDefinition strokeColor) {
        this.strokeColor = strokeColor;
    }

    public final void setStrokeWidth(double strokeWidth) {
        this.strokeWidth = Double.toString(strokeWidth);
    }

    @XmlElement
    public final void setStrokeWidth(String strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public final PaintDefinition getFillColor() {
        return this.fillColor;
    }

    public final PaintDefinition getStrokeColor() {
        return this.strokeColor;
    }

    public final String getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof YoGraphic2DDefinition) {
            YoGraphic2DDefinition other = (YoGraphic2DDefinition)object;
            if (!Objects.equals(this.fillColor, other.fillColor)) {
                return false;
            }
            if (!Objects.equals(this.strokeColor, other.strokeColor)) {
                return false;
            }
            return Objects.equals(this.strokeWidth, other.strokeWidth);
        }
        return false;
    }

    @Deprecated
    @XmlElement(name="fillColor")
    public final void setFillColorOld(ColorDefinition fillColor) {
        this.fillColor = fillColor;
    }

    @Deprecated
    public ColorDefinition getFillColorOld() {
        return null;
    }

    @Deprecated
    @XmlElement(name="strokeColor")
    public final void setStrokeColorOld(ColorDefinition strokeColor) {
        this.strokeColor = strokeColor;
    }

    @Deprecated
    public ColorDefinition getStrokeColorOld() {
        return null;
    }
}

