/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.scs2.definition.visual.PaintDefinition;

@XmlType(propOrder={"red", "green", "blue", "alpha"})
public class YoColorRGBADoubleDefinition
extends PaintDefinition {
    private String red;
    private String green;
    private String blue;
    private String alpha;

    public YoColorRGBADoubleDefinition() {
    }

    public YoColorRGBADoubleDefinition(String red, String green, String blue) {
        this(red, green, blue, null);
    }

    public YoColorRGBADoubleDefinition(String red, String green, String blue, String alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public YoColorRGBADoubleDefinition(YoColorRGBADoubleDefinition other) {
        this.red = other.red;
        this.green = other.green;
        this.blue = other.blue;
        this.alpha = other.alpha;
    }

    public void setRed(double red) {
        this.setRed(Double.toString(red));
    }

    public void setRed(int red) {
        this.setRed(Double.toString((double)red / 255.0));
    }

    @XmlAttribute
    public void setRed(String red) {
        this.red = red;
    }

    public void setGreen(double green) {
        this.setGreen(Double.toString(green));
    }

    public void setGreen(int green) {
        this.setGreen(Double.toString((double)green / 255.0));
    }

    @XmlAttribute
    public void setGreen(String green) {
        this.green = green;
    }

    public void setBlue(double blue) {
        this.setBlue(Double.toString(blue));
    }

    public void setBlue(int blue) {
        this.setBlue(Double.toString((double)blue / 255.0));
    }

    @XmlAttribute
    public void setBlue(String blue) {
        this.blue = blue;
    }

    public void setAlpha(double alpha) {
        this.setAlpha(Double.toString(alpha));
    }

    public void setAlpha(int alpha) {
        this.setAlpha(Double.toString((double)alpha / 255.0));
    }

    @XmlAttribute
    public void setAlpha(String alpha) {
        this.alpha = alpha;
    }

    public String getRed() {
        return this.red;
    }

    public String getGreen() {
        return this.green;
    }

    public String getBlue() {
        return this.blue;
    }

    public String getAlpha() {
        return this.alpha;
    }

    @Override
    public YoColorRGBADoubleDefinition copy() {
        return new YoColorRGBADoubleDefinition(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoColorRGBADoubleDefinition) {
            YoColorRGBADoubleDefinition other = (YoColorRGBADoubleDefinition)object;
            if (!Objects.equals(this.red, other.red)) {
                return false;
            }
            if (!Objects.equals(this.green, other.green)) {
                return false;
            }
            if (!Objects.equals(this.blue, other.blue)) {
                return false;
            }
            return Objects.equals(this.alpha, other.alpha);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.alpha == null) {
            return "YoDoubleRGB(red=%s, green=%s, blue=%s)".formatted(this.red, this.green, this.blue);
        }
        return "YoDoubleRGBA(red=%s, green=%s, blue=%s, alpha=%s)".formatted(this.red, this.green, this.blue, this.alpha);
    }

    public static YoColorRGBADoubleDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("YoDoubleRGB")) {
            String alpha;
            String blue;
            boolean parseAlpha = (value = value.substring(11, value.length() - 1)).charAt(0) == 'A';
            value = value.substring(value.indexOf("=") + 1);
            String red = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1);
            String green = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1);
            if (parseAlpha) {
                blue = value.substring(0, value.indexOf(","));
                alpha = value.substring(value.indexOf("=") + 1);
            } else {
                blue = value;
                alpha = null;
            }
            if (red.equalsIgnoreCase("null")) {
                red = null;
            }
            if (green.equalsIgnoreCase("null")) {
                green = null;
            }
            if (blue.equalsIgnoreCase("null")) {
                blue = null;
            }
            if (parseAlpha && alpha.equalsIgnoreCase("null")) {
                alpha = null;
            }
            return new YoColorRGBADoubleDefinition(red, green, blue, alpha);
        }
        throw new IllegalArgumentException("Unknown color format: " + value);
    }
}

