/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Ramp3DDefinition
extends GeometryDefinition {
    private double sizeX;
    private double sizeY;
    private double sizeZ;

    public Ramp3DDefinition() {
        this.setName("ramp");
    }

    public Ramp3DDefinition(double sizeX, double sizeY, double sizeZ) {
        this();
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public Ramp3DDefinition(Tuple3DReadOnly size) {
        this(size.getX(), size.getY(), size.getZ());
    }

    public Ramp3DDefinition(Ramp3DDefinition other) {
        this.setName(other.getName());
        this.sizeX = other.sizeX;
        this.sizeY = other.sizeY;
        this.sizeZ = other.sizeZ;
    }

    @XmlElement
    public void setSizeX(double sizeX) {
        this.sizeX = sizeX;
    }

    @XmlElement
    public void setSizeY(double sizeY) {
        this.sizeY = sizeY;
    }

    @XmlElement
    public void setSizeZ(double sizeZ) {
        this.sizeZ = sizeZ;
    }

    public void setSize(double sizeX, double sizeY, double sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public double getSizeZ() {
        return this.sizeZ;
    }

    @Override
    public Ramp3DDefinition copy() {
        return new Ramp3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeZ);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Ramp3DDefinition other = (Ramp3DDefinition)object;
        if (!EuclidCoreTools.equals((double)this.sizeX, (double)other.sizeX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.sizeY, (double)other.sizeY)) {
            return false;
        }
        return EuclidCoreTools.equals((double)this.sizeZ, (double)other.sizeZ);
    }

    public String toString() {
        return EuclidCoreIOTools.getStringOf((String)("Ramp: [name: " + this.getName() + ", size: ("), (String)")]", (String)", ", (double[])new double[]{this.sizeX, this.sizeY, this.sizeZ});
    }
}

