/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.geometry.ArcTorus3DDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrudedPolygon2DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Polygon2DDefinition;
import us.ihmc.scs2.definition.geometry.Polygon3DDefinition;
import us.ihmc.scs2.definition.geometry.PyramidBox3DDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Torus3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class VisualDefinitionFactory {
    private static final MaterialDefinition DEFAULT_MATERIAL = new MaterialDefinition(ColorDefinitions.Black());
    private final AffineTransform currentTransform = new AffineTransform();
    private final AffineTransform previousTransform = new AffineTransform();
    private final List<VisualDefinition> visualDefinitions = new ArrayList<VisualDefinition>();
    private MaterialDefinition defaultMaterial = new MaterialDefinition(DEFAULT_MATERIAL);

    public List<VisualDefinition> getVisualDefinitions() {
        return this.visualDefinitions;
    }

    public MaterialDefinition getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public void setDefaultMaterial(ColorDefinition diffuseColor) {
        this.setDefaultMaterial(new MaterialDefinition(diffuseColor));
    }

    public void setDefaultMaterial(MaterialDefinition defaultMaterial) {
        this.defaultMaterial = defaultMaterial;
    }

    public AffineTransform getCurrentTransform() {
        return this.currentTransform;
    }

    public void identity() {
        this.identity(false);
    }

    public void identity(boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().setIdentity();
            }
        }
        this.currentTransform.setIdentity();
    }

    public void appendTransform(RigidBodyTransformReadOnly transform) {
        this.appendTransform(transform, false);
    }

    public void appendTransform(RigidBodyTransformReadOnly transform, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().multiply(transform);
            }
        }
        this.currentTransform.multiply(transform);
    }

    public void appendTranslation(double x, double y, double z) {
        this.appendTranslation(x, y, z, false);
    }

    public void appendTranslation(double x, double y, double z, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().appendTranslation(x, y, z);
            }
        }
        this.currentTransform.appendTranslation(x, y, z);
    }

    public void appendTranslation(Tuple3DReadOnly translation) {
        this.appendTranslation(translation, false);
    }

    public void appendTranslation(Tuple3DReadOnly translation, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().appendTranslation(translation);
            }
        }
        this.currentTransform.appendTranslation(translation);
    }

    public void appendRotation(double rotationAngle, Vector3DReadOnly rotationAxis) {
        this.appendRotation(rotationAngle, rotationAxis, false);
    }

    public void appendRotation(double rotationAngle, Vector3DReadOnly rotationAxis, boolean applyToAllVisuals) {
        this.appendRotation((Orientation3DReadOnly)new AxisAngle(rotationAxis, rotationAngle), applyToAllVisuals);
    }

    public void appendRotation(Orientation3DReadOnly orientation) {
        this.appendRotation(orientation, false);
    }

    public void appendRotation(Orientation3DReadOnly orientation, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().appendOrientation(orientation);
            }
        }
        this.currentTransform.appendOrientation(orientation);
    }

    public void appendScale(double scaleFactor) {
        this.appendScale(scaleFactor, false);
    }

    public void appendScale(double scaleFactor, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().appendScale(scaleFactor);
            }
        }
        this.currentTransform.appendScale(scaleFactor);
    }

    public void appendScale(Tuple3DReadOnly scaleFactors) {
        this.currentTransform.appendScale(scaleFactors);
    }

    public void appendScale(Tuple3DReadOnly scaleFactors, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().appendScale(scaleFactors);
            }
        }
        this.currentTransform.appendScale(scaleFactors);
    }

    public void prependTransform(RigidBodyTransformReadOnly transform) {
        this.prependTransform(transform, false);
    }

    public void prependTransform(RigidBodyTransformReadOnly transform, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().preMultiply(transform);
            }
        }
        this.currentTransform.preMultiply(transform);
    }

    public void prependTranslation(double x, double y, double z) {
        this.prependTranslation(x, y, z, false);
    }

    public void prependTranslation(double x, double y, double z, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().prependTranslation(x, y, z);
            }
        }
        this.currentTransform.prependTranslation(x, y, z);
    }

    public void prependTranslation(Tuple3DReadOnly translation) {
        this.prependTranslation(translation, false);
    }

    public void prependTranslation(Tuple3DReadOnly translation, boolean applyToAllVisuals) {
        this.prependTranslation(translation.getX(), translation.getY(), translation.getZ(), applyToAllVisuals);
    }

    public void prependRotation(double rotationAngle, Vector3DReadOnly rotationAxis) {
        this.prependRotation(rotationAngle, rotationAxis);
    }

    public void prependRotation(double rotationAngle, Vector3DReadOnly rotationAxis, boolean applyToAllVisuals) {
        this.prependRotation((Orientation3DReadOnly)new AxisAngle(rotationAxis, rotationAngle), applyToAllVisuals);
    }

    public void prependRotation(Orientation3DReadOnly orientation) {
        this.prependRotation(orientation, false);
    }

    public void prependRotation(Orientation3DReadOnly orientation, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().prependOrientation(orientation);
            }
        }
        this.currentTransform.prependOrientation(orientation);
    }

    public void prependScale(double scaleFactor) {
        this.prependScale(scaleFactor, false);
    }

    public void prependScale(double scaleFactor, boolean applyToAllVisuals) {
        this.prependScale((Tuple3DReadOnly)new Vector3D(scaleFactor, scaleFactor, scaleFactor), applyToAllVisuals);
    }

    public void prependScale(Tuple3DReadOnly scaleFactors) {
        this.prependScale(scaleFactors, false);
    }

    public void prependScale(Tuple3DReadOnly scaleFactors, boolean applyToAllVisuals) {
        if (applyToAllVisuals) {
            for (int i = 0; i < this.visualDefinitions.size(); ++i) {
                this.visualDefinitions.get(i).getOriginPose().prependScale(scaleFactors);
            }
        }
        this.currentTransform.prependScale(scaleFactors);
    }

    public void saveCurrentTransform() {
        this.previousTransform.set(this.currentTransform);
    }

    public void resetCurrentTransform() {
        this.currentTransform.set(this.previousTransform);
    }

    public VisualDefinition addVisualDefinition(VisualDefinition visual) {
        this.visualDefinitions.add(visual);
        return visual;
    }

    public VisualDefinition addGeometryDefinition(GeometryDefinition geometry) {
        return this.addGeometryDefinition(geometry, this.defaultMaterial);
    }

    public VisualDefinition addGeometryDefinition(GeometryDefinition geometry, ColorDefinition diffuseColor) {
        return this.addGeometryDefinition(geometry, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addGeometryDefinition(GeometryDefinition geometry, MaterialDefinition material) {
        VisualDefinition visual = new VisualDefinition((AffineTransformReadOnly)new AffineTransform((AffineTransformReadOnly)this.currentTransform), geometry, material);
        return this.addVisualDefinition(visual);
    }

    public VisualDefinition addModelFile(URL fileURL) {
        return this.addModelFile(fileURL, null);
    }

    public VisualDefinition addModelFile(URL fileURL, MaterialDefinition material) {
        if (fileURL == null) {
            LogTools.error((String)"The given fileURL is null.");
            return null;
        }
        return this.addModelFile(fileURL.getFile(), material);
    }

    public VisualDefinition addModelFile(String fileName) {
        return this.addModelFile(fileName, null);
    }

    public VisualDefinition addModelFile(String fileName, List<String> resourceDirectories, ClassLoader resourceClassLoader) {
        return this.addModelFile(fileName, resourceDirectories, resourceClassLoader, null);
    }

    public VisualDefinition addModelFile(String fileName, String submesh, boolean centerSubmesh, List<String> resourceDirectories, ClassLoader resourceClassLoader) {
        return this.addModelFile(fileName, submesh, centerSubmesh, resourceDirectories, resourceClassLoader, null);
    }

    public VisualDefinition addModelFile(String fileName, MaterialDefinition material) {
        if (fileName == null || fileName.equals("")) {
            LogTools.error((String)"Error importing model file, filename is null or empty");
            return null;
        }
        ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition();
        modelFileGeometryDefinition.setFileName(fileName);
        return this.addGeometryDefinition((GeometryDefinition)modelFileGeometryDefinition, material);
    }

    public VisualDefinition addModelFile(String fileName, List<String> resourceDirectories, ClassLoader resourceClassLoader, MaterialDefinition material) {
        return this.addModelFile(fileName, null, false, resourceDirectories, resourceClassLoader, material);
    }

    public VisualDefinition addModelFile(String fileName, String submesh, boolean centerSubmesh, List<String> resourceDirectories, ClassLoader resourceClassLoader, MaterialDefinition material) {
        ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition(fileName);
        modelFileGeometryDefinition.setResourceDirectories(resourceDirectories);
        if (submesh != null) {
            modelFileGeometryDefinition.setSubmeshes(Collections.singletonList(new ModelFileGeometryDefinition.SubMeshDefinition(submesh, centerSubmesh)));
        }
        modelFileGeometryDefinition.setResourceClassLoader(resourceClassLoader);
        return this.addGeometryDefinition((GeometryDefinition)modelFileGeometryDefinition, material);
    }

    public VisualDefinition addShape(Shape3DReadOnly shape) {
        return this.addShape(shape, this.defaultMaterial);
    }

    public VisualDefinition addShape(Shape3DReadOnly shape, ColorDefinition diffuseColor) {
        return this.addShape(shape, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addShape(Shape3DReadOnly shape, MaterialDefinition material) {
        VisualDefinition visual;
        AffineTransform localSaveCurrentTransform = new AffineTransform((AffineTransformReadOnly)this.currentTransform);
        if (shape instanceof Box3DReadOnly) {
            Box3DReadOnly box = (Box3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)box.getPose());
            visual = this.addBox(box.getSizeX(), box.getSizeY(), box.getSizeZ(), true, material);
        } else if (shape instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsule = (Capsule3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)capsule.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)capsule.getAxis()));
            visual = this.addCapsule(capsule.getLength(), capsule.getRadius(), material);
        } else if (shape instanceof ConvexPolytope3DReadOnly) {
            ConvexPolytope3DReadOnly convexPolytope = (ConvexPolytope3DReadOnly)shape;
            visual = this.addGeometryDefinition((GeometryDefinition)new ConvexPolytope3DDefinition((ConvexPolytope3DReadOnly)new ConvexPolytope3D(convexPolytope)), material);
        } else if (shape instanceof Cylinder3DReadOnly) {
            Cylinder3DReadOnly cylinder = (Cylinder3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)cylinder.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)cylinder.getAxis()));
            visual = this.addCylinder(cylinder.getLength(), cylinder.getRadius(), material);
        } else if (shape instanceof Ellipsoid3DReadOnly) {
            Ellipsoid3DReadOnly ellipsoid = (Ellipsoid3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)ellipsoid.getPose());
            visual = this.addEllipsoid(ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ(), material);
        } else if (shape instanceof PointShape3DReadOnly) {
            PointShape3DReadOnly pointShape = (PointShape3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)pointShape);
            visual = this.addSphere(0.005, material);
        } else if (shape instanceof Ramp3DReadOnly) {
            Ramp3DReadOnly ramp = (Ramp3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)ramp.getPose());
            this.appendTranslation(-0.5 * ramp.getSizeX(), 0.0, 0.0);
            visual = this.addRamp(ramp.getSizeX(), ramp.getSizeY(), ramp.getSizeZ(), material);
        } else if (shape instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)sphere.getPosition());
            visual = this.addSphere(sphere.getRadius(), material);
        } else if (shape instanceof Torus3DReadOnly) {
            Torus3DReadOnly torus = (Torus3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)torus.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)torus.getAxis()));
            visual = this.addTorus(torus.getRadius(), torus.getTubeRadius(), material);
        } else {
            LogTools.error((String)"Unsupported shape: {}", (Object)shape);
            return null;
        }
        this.currentTransform.set(localSaveCurrentTransform);
        return visual;
    }

    public void addCoordinateSystem(double length) {
        this.addCoordinateSystem(length, this.defaultMaterial);
    }

    public void addCoordinateSystem(double length, ColorDefinition arrowHeadDiffuseColor) {
        this.addCoordinateSystem(length, arrowHeadDiffuseColor == null ? null : new MaterialDefinition(arrowHeadDiffuseColor));
    }

    public void addCoordinateSystem(double length, MaterialDefinition arrowHeadMaterial) {
        this.addCoordinateSystem(length, new MaterialDefinition(ColorDefinitions.Red()), new MaterialDefinition(ColorDefinitions.Lime()), new MaterialDefinition(ColorDefinitions.Blue()), arrowHeadMaterial);
    }

    public void addCoordinateSystem(double length, ColorDefinition xAxisDiffuseColor, ColorDefinition yAxisDiffuseColor, ColorDefinition zAxisDiffuseColor, ColorDefinition arrowHeadDiffuseColor) {
        this.addCoordinateSystem(length, new MaterialDefinition(xAxisDiffuseColor), new MaterialDefinition(yAxisDiffuseColor), new MaterialDefinition(zAxisDiffuseColor), arrowHeadDiffuseColor == null ? null : new MaterialDefinition(arrowHeadDiffuseColor));
    }

    public void addCoordinateSystem(double length, MaterialDefinition xAxisMaterial, MaterialDefinition yAxisMaterial, MaterialDefinition zAxisMaterial, MaterialDefinition arrowHeadMaterial) {
        this.addArrow(Axis3D.X, length, xAxisMaterial, arrowHeadMaterial == null ? xAxisMaterial : arrowHeadMaterial);
        this.addArrow(Axis3D.Y, length, yAxisMaterial, arrowHeadMaterial == null ? yAxisMaterial : arrowHeadMaterial);
        this.addArrow(Axis3D.Z, length, zAxisMaterial, arrowHeadMaterial == null ? zAxisMaterial : arrowHeadMaterial);
    }

    public void addArrow(Axis3D axis, double length) {
        this.addArrow(axis, length, this.defaultMaterial, this.defaultMaterial);
    }

    public void addArrow(Axis3D axis, double length, ColorDefinition bodyDiffuseColor, ColorDefinition headDiffuseColor) {
        this.addArrow(axis, length, new MaterialDefinition(bodyDiffuseColor), new MaterialDefinition(headDiffuseColor));
    }

    public void addArrow(Axis3D axis, double length, MaterialDefinition bodyMaterial, MaterialDefinition headMaterial) {
        double coneHeight = 0.1 * length;
        double cylinderLength = length - coneHeight;
        double radius = 0.02 * length;
        double coneRadius = 2.0 * radius;
        AffineTransform localSaveCurrentTransform = new AffineTransform((AffineTransformReadOnly)this.currentTransform);
        switch (axis) {
            case X: {
                this.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.Y);
                break;
            }
            case Y: {
                this.appendRotation(-1.5707963267948966, (Vector3DReadOnly)Axis3D.X);
                break;
            }
            case Z: {
                break;
            }
            default: {
                LogTools.error((String)"Unexpected axis value: {}", (Object)axis);
            }
        }
        this.appendTranslation(0.0, 0.0, 0.5 * cylinderLength);
        this.addCylinder(cylinderLength, radius, bodyMaterial);
        this.appendTranslation(0.0, 0.0, 0.5 * cylinderLength);
        this.addCone(coneHeight, coneRadius, headMaterial);
        this.currentTransform.set(localSaveCurrentTransform);
    }

    public VisualDefinition addBox(double sizeX, double sizeY, double sizeZ) {
        return this.addBox(sizeX, sizeY, sizeZ, this.defaultMaterial);
    }

    public VisualDefinition addBox(double sizeX, double sizeY, double sizeZ, ColorDefinition diffuseColor) {
        return this.addBox(sizeX, sizeY, sizeZ, true, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addBox(double sizeX, double sizeY, double sizeZ, MaterialDefinition material) {
        return this.addBox(sizeX, sizeY, sizeZ, true, material);
    }

    public VisualDefinition addBox(double sizeX, double sizeY, double sizeZ, boolean centeredInTheCenter, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Box3DDefinition(sizeX, sizeY, sizeZ, centeredInTheCenter), material);
    }

    public VisualDefinition addRamp(double sizeX, double sizeY, double sizeZ) {
        return this.addRamp(sizeX, sizeY, sizeZ, this.defaultMaterial);
    }

    public VisualDefinition addRamp(double sizeX, double sizeY, double sizeZ, ColorDefinition diffuseColor) {
        return this.addRamp(sizeX, sizeY, sizeZ, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addRamp(double sizeX, double sizeY, double sizeZ, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Ramp3DDefinition(sizeX, sizeY, sizeZ), material);
    }

    public VisualDefinition addSphere(double radius) {
        return this.addSphere(radius, this.defaultMaterial);
    }

    public VisualDefinition addSphere(double radius, ColorDefinition diffuseColor) {
        return this.addSphere(radius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addSphere(double radius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Sphere3DDefinition(radius), material);
    }

    public VisualDefinition addCapsule(double length, double radius) {
        return this.addCapsule(length, radius, this.defaultMaterial);
    }

    public VisualDefinition addCapsule(double length, double radius, ColorDefinition diffuseColor) {
        return this.addCapsule(length, radius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addCapsule(double length, double radius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Capsule3DDefinition(length, radius), material);
    }

    public VisualDefinition addEllipsoid(double radiusX, double radiusY, double radiusZ) {
        return this.addEllipsoid(radiusX, radiusY, radiusZ, this.defaultMaterial);
    }

    public VisualDefinition addEllipsoid(double radiusX, double radiusY, double radiusZ, ColorDefinition diffuseColor) {
        return this.addEllipsoid(radiusX, radiusY, radiusZ, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addEllipsoid(double radiusX, double radiusY, double radiusZ, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Ellipsoid3DDefinition(radiusX, radiusY, radiusZ), material);
    }

    public VisualDefinition addCylinder(double length, double radius) {
        return this.addCylinder(length, radius, this.defaultMaterial);
    }

    public VisualDefinition addCylinder(double length, double radius, ColorDefinition diffuseColor) {
        return this.addCylinder(length, radius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addCylinder(double length, double radius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Cylinder3DDefinition(length, radius, false), material);
    }

    public VisualDefinition addCone(double height, double radius) {
        return this.addCone(height, radius, this.defaultMaterial);
    }

    public VisualDefinition addCone(double height, double radius, ColorDefinition diffuseColor) {
        return this.addCone(height, radius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addCone(double height, double radius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Cone3DDefinition(height, radius), material);
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadius, double topRadius) {
        return this.addTruncatedCone(height, baseRadius, topRadius, this.defaultMaterial);
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadius, double topRadius, ColorDefinition diffuseColor) {
        return this.addTruncatedCone(height, baseRadius, topRadius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadius, double topRadius, MaterialDefinition material) {
        return this.addTruncatedCone(height, baseRadius, baseRadius, topRadius, topRadius, material);
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadiusX, double baseRadiusY, double topRadiusX, double topRadiusY) {
        return this.addTruncatedCone(height, baseRadiusX, baseRadiusY, topRadiusX, topRadiusY, this.defaultMaterial);
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadiusX, double baseRadiusY, double topRadiusX, double topRadiusY, ColorDefinition diffuseColor) {
        return this.addTruncatedCone(height, baseRadiusX, baseRadiusY, topRadiusX, topRadiusY, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addTruncatedCone(double height, double baseRadiusX, double baseRadiusY, double topRadiusX, double topRadiusY, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new TruncatedCone3DDefinition(height, topRadiusX, topRadiusY, baseRadiusX, baseRadiusY), material);
    }

    public VisualDefinition addHemiEllipsoid(double radiusX, double radiusY, double radiusZ) {
        return this.addHemiEllipsoid(radiusX, radiusY, radiusZ, this.defaultMaterial);
    }

    public VisualDefinition addHemiEllipsoid(double radiusX, double radiusY, double radiusZ, ColorDefinition diffuseColor) {
        return this.addHemiEllipsoid(radiusX, radiusY, radiusZ, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addHemiEllipsoid(double radiusX, double radiusY, double radiusZ, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new HemiEllipsoid3DDefinition(radiusX, radiusY, radiusZ), material);
    }

    public VisualDefinition addTorus(double majorRadius, double minorRadius) {
        return this.addTorus(majorRadius, minorRadius, this.defaultMaterial);
    }

    public VisualDefinition addTorus(double majorRadius, double minorRadius, ColorDefinition diffuseColor) {
        return this.addTorus(majorRadius, minorRadius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addTorus(double majorRadius, double minorRadius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Torus3DDefinition(majorRadius, minorRadius), material);
    }

    public VisualDefinition addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius) {
        return this.addArcTorus(startAngle, endAngle, majorRadius, minorRadius, this.defaultMaterial);
    }

    public VisualDefinition addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, ColorDefinition diffuseColor) {
        return this.addArcTorus(startAngle, endAngle, majorRadius, minorRadius, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new ArcTorus3DDefinition(startAngle, endAngle, majorRadius, minorRadius), material);
    }

    public VisualDefinition addPyramidBox(double boxSizeX, double boxSizeY, double boxSizeZ, double pyramidHeight) {
        return this.addPyramidBox(boxSizeX, boxSizeY, boxSizeZ, pyramidHeight, this.defaultMaterial);
    }

    public VisualDefinition addPyramidBox(double boxSizeX, double boxSizeY, double boxSizeZ, double pyramidHeight, ColorDefinition diffuseColor) {
        return this.addPyramidBox(boxSizeX, boxSizeY, boxSizeZ, pyramidHeight, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPyramidBox(double boxSizeX, double boxSizeY, double boxSizeZ, double pyramidHeight, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new PyramidBox3DDefinition(boxSizeX, boxSizeY, boxSizeZ, pyramidHeight), material);
    }

    public VisualDefinition addPolygon2D(ConvexPolygon2DReadOnly convexPolygon2D) {
        return this.addPolygon2D(convexPolygon2D, this.defaultMaterial);
    }

    public VisualDefinition addPolygon2D(ConvexPolygon2DReadOnly convexPolygon2D, ColorDefinition diffuseColor) {
        return this.addPolygon2D(convexPolygon2D, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPolygon2D(ConvexPolygon2DReadOnly convexPolygon2D, MaterialDefinition material) {
        return this.addPolygon2D((List<? extends Point2DReadOnly>)convexPolygon2D.getPolygonVerticesView(), !convexPolygon2D.isClockwiseOrdered(), material);
    }

    public VisualDefinition addPolygon2D(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered) {
        return this.addPolygon2D(polygonPoints, counterClockwiseOrdered, this.defaultMaterial);
    }

    public VisualDefinition addPolygon2D(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered, ColorDefinition diffuseColor) {
        return this.addPolygon2D(polygonPoints, counterClockwiseOrdered, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPolygon2D(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Polygon2DDefinition(Polygon2DDefinition.toPoint2DDefinitionList(polygonPoints), counterClockwiseOrdered), material);
    }

    public VisualDefinition addPolygon2D(MaterialDefinition material, boolean counterClockwiseOrdered, Point2DReadOnly ... polygonPoints) {
        return this.addPolygon2D(Arrays.asList(polygonPoints), counterClockwiseOrdered, material);
    }

    public VisualDefinition addPolygon2D(Point2DReadOnly[] polygonPoints, boolean counterClockwiseOrdered) {
        return this.addPolygon2D(Arrays.asList(polygonPoints), counterClockwiseOrdered, this.defaultMaterial);
    }

    public VisualDefinition addPolygon2D(Point2DReadOnly[] polygonPoints, boolean counterClockwiseOrdered, ColorDefinition diffuseColor) {
        return this.addPolygon2D(Arrays.asList(polygonPoints), counterClockwiseOrdered, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPolygon2D(Point2DReadOnly[] polygonPoints, boolean counterClockwiseOrdered, MaterialDefinition material) {
        return this.addPolygon2D(Arrays.asList(polygonPoints), counterClockwiseOrdered, material);
    }

    public void addPolygon2Ds(List<? extends ConvexPolygon2DReadOnly> convexPolygon2Ds) {
        this.addPolygon2Ds(convexPolygon2Ds, this.defaultMaterial);
    }

    public void addPolygon2Ds(List<? extends ConvexPolygon2DReadOnly> convexPolygon2Ds, ColorDefinition diffuseColor) {
        this.addPolygon2Ds(convexPolygon2Ds, new MaterialDefinition(diffuseColor));
    }

    public void addPolygon2Ds(List<? extends ConvexPolygon2DReadOnly> convexPolygon2Ds, MaterialDefinition material) {
        for (int i = 0; i < convexPolygon2Ds.size(); ++i) {
            this.addPolygon2D(convexPolygon2Ds.get(i), material);
        }
    }

    public VisualDefinition addPolygon3D(List<? extends Point3DReadOnly> polygonPoints, boolean counterClockwiseOrdered) {
        return this.addPolygon3D(polygonPoints, counterClockwiseOrdered, this.defaultMaterial);
    }

    public VisualDefinition addPolygon3D(List<? extends Point3DReadOnly> polygonPoints, boolean counterClockwiseOrdered, ColorDefinition diffuseColor) {
        return this.addPolygon3D(polygonPoints, counterClockwiseOrdered, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPolygon3D(List<? extends Point3DReadOnly> polygonPoints, boolean counterClockwiseOrdered, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new Polygon3DDefinition(Polygon3DDefinition.toPoint3DDefinitionList(polygonPoints), counterClockwiseOrdered), material);
    }

    public VisualDefinition addPolygon3D(MaterialDefinition material, boolean counterClockwiseOrdered, Point3DReadOnly ... polygonPoints) {
        return this.addPolygon3D(Arrays.asList(polygonPoints), counterClockwiseOrdered, material);
    }

    public VisualDefinition addPolygon3D(Point3DReadOnly[] polygonPoints, boolean counterClockwiseOrdered) {
        return this.addPolygon3D(Arrays.asList(polygonPoints), counterClockwiseOrdered, this.defaultMaterial);
    }

    public VisualDefinition addPolygon3D(Point3DReadOnly[] polygonPoints, boolean counterClockwiseOrdered, ColorDefinition diffuseColor) {
        return this.addPolygon3D(Arrays.asList(polygonPoints), counterClockwiseOrdered, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addPolygon3D(Point3DReadOnly[] polygonPoints, boolean counterClockwiseOrdered, MaterialDefinition material) {
        return this.addPolygon3D(Arrays.asList(polygonPoints), counterClockwiseOrdered, material);
    }

    public VisualDefinition addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2D, double extrusionHeight) {
        return this.addExtrudedPolygon(convexPolygon2D, extrusionHeight, this.defaultMaterial);
    }

    public VisualDefinition addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2D, double extrusionHeight, ColorDefinition diffuseColor) {
        return this.addExtrudedPolygon(convexPolygon2D, extrusionHeight, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2D, double extrusionHeight, MaterialDefinition material) {
        return this.addExtrudedPolygon((List<? extends Point2DReadOnly>)convexPolygon2D.getPolygonVerticesView(), !convexPolygon2D.isClockwiseOrdered(), extrusionHeight, material);
    }

    public VisualDefinition addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered, double extrusionHeight) {
        return this.addExtrudedPolygon(polygonPoints, counterClockwiseOrdered, extrusionHeight, this.defaultMaterial);
    }

    public VisualDefinition addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered, double extrusionHeight, ColorDefinition diffuseColor) {
        return this.addExtrudedPolygon(polygonPoints, counterClockwiseOrdered, extrusionHeight, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, boolean counterClockwiseOrdered, double extrusionHeight, MaterialDefinition material) {
        return this.addGeometryDefinition((GeometryDefinition)new ExtrudedPolygon2DDefinition(ExtrudedPolygon2DDefinition.toPoint2DDefinitionList(polygonPoints), counterClockwiseOrdered, extrusionHeight), material);
    }
}

