/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateReadOnly;

public interface OneDoFJointStateBasics
extends JointStateBasics,
OneDoFJointStateReadOnly {
    public void setConfiguration(double var1);

    public void setVelocity(double var1);

    public void setAcceleration(double var1);

    public void setEffort(double var1);

    @Override
    default public void clear() {
        this.setConfiguration(Double.NaN);
        this.setVelocity(Double.NaN);
        this.setAcceleration(Double.NaN);
        this.setEffort(Double.NaN);
    }

    default public void addConfiguration(double q) {
        if (!this.hasOutputFor(JointStateType.CONFIGURATION)) {
            this.setConfiguration(q);
        } else {
            this.setConfiguration(this.getConfiguration() + q);
        }
    }

    default public void addVelocity(double qd) {
        if (!this.hasOutputFor(JointStateType.VELOCITY)) {
            this.setVelocity(qd);
        } else {
            this.setVelocity(this.getVelocity() + qd);
        }
    }

    default public void addAcceleration(double qdd) {
        if (!this.hasOutputFor(JointStateType.ACCELERATION)) {
            this.setAcceleration(qdd);
        } else {
            this.setAcceleration(this.getAcceleration() + qdd);
        }
    }

    default public void addEffort(double tau) {
        if (!this.hasOutputFor(JointStateType.EFFORT)) {
            this.setEffort(tau);
        } else {
            this.setEffort(this.getEffort() + tau);
        }
    }

    default public void set(OneDoFJointStateReadOnly other) {
        this.setConfiguration(other.getConfiguration());
        this.setVelocity(other.getVelocity());
        this.setAcceleration(other.getAcceleration());
        this.setEffort(other.getEffort());
    }

    @Override
    default public void setConfiguration(JointReadOnly joint) {
        this.setConfiguration(((OneDoFJointReadOnly)joint).getQ());
    }

    @Override
    default public int setConfiguration(int startRow, DMatrix configuration) {
        this.setConfiguration(configuration.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setVelocity(JointReadOnly joint) {
        this.setVelocity(((OneDoFJointReadOnly)joint).getQd());
    }

    @Override
    default public int setVelocity(int startRow, DMatrix velocity) {
        this.setVelocity(velocity.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setAcceleration(JointReadOnly joint) {
        this.setAcceleration(((OneDoFJointReadOnly)joint).getQdd());
    }

    @Override
    default public int setAcceleration(int startRow, DMatrix acceleration) {
        this.setAcceleration(acceleration.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setEffort(JointReadOnly joint) {
        this.setEffort(((OneDoFJointReadOnly)joint).getTau());
    }

    @Override
    default public int setEffort(int startRow, DMatrix effort) {
        this.setEffort(effort.get(startRow++, 0));
        return startRow;
    }
}

