/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateReadOnly;

@XmlType(propOrder={"configuration", "velocity", "acceleration", "effort"})
public class OneDoFJointState
extends JointStateBase
implements OneDoFJointStateBasics {
    private double configuration;
    private double velocity;
    private double acceleration;
    private double effort;
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);

    public OneDoFJointState() {
        this.clear();
    }

    public OneDoFJointState(double q) {
        this();
        this.setConfiguration(q);
    }

    public OneDoFJointState(double q, double qd) {
        this();
        this.setConfiguration(q);
        this.setVelocity(qd);
    }

    public OneDoFJointState(double q, double qd, double tau) {
        this();
        this.setConfiguration(q);
        this.setVelocity(qd);
        this.setEffort(tau);
    }

    public OneDoFJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof OneDoFJointStateReadOnly) {
            OneDoFJointStateBasics.super.set((OneDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    @XmlAttribute
    public void setConfiguration(double q) {
        this.configuration = q;
    }

    @Override
    @XmlAttribute
    public void setVelocity(double qd) {
        this.velocity = qd;
    }

    @Override
    @XmlAttribute
    public void setAcceleration(double qdd) {
        this.acceleration = qdd;
    }

    @Override
    @XmlAttribute
    public void setEffort(double tau) {
        this.effort = tau;
    }

    @Override
    public double getConfiguration() {
        return this.configuration;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public double getAcceleration() {
        return this.acceleration;
    }

    @Override
    public double getEffort() {
        return this.effort;
    }

    @Override
    public OneDoFJointState copy() {
        return new OneDoFJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.configuration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.velocity);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.acceleration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.effort);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OneDoFJointState other = (OneDoFJointState)object;
        if (!EuclidCoreTools.equals((double)this.configuration, (double)other.configuration)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.velocity, (double)other.velocity)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.acceleration, (double)other.acceleration)) {
            return false;
        }
        return EuclidCoreTools.equals((double)this.effort, (double)other.effort);
    }

    public String toString() {
        Object ret = "1-DoF joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + ", q: " + this.configuration;
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + ", qd: " + this.velocity;
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + ", qdd: " + this.acceleration;
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + ", tau: " + this.effort;
        }
        return ret;
    }
}

