/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.urdf.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.robot.urdf.items.URDFFilenameHolder;
import us.ihmc.scs2.definition.robot.urdf.items.URDFItem;

public class URDFSensor
implements URDFItem {
    private String name;
    private String type;
    private String pose;
    private String visualize;
    private String updateRate;
    private List<URDFCamera> camera;
    private URDFRay ray;
    private URDFIMU imu;

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    @XmlAttribute(name="type")
    public void setType(String type) {
        this.type = type;
    }

    public void setType(URDFSensorType type) {
        this.setType(type.name());
    }

    @XmlElement(name="visualize")
    public void setVisualize(String visualize) {
        this.visualize = visualize;
    }

    @XmlElement(name="update_rate")
    public void setUpdateRate(String updateRate) {
        this.updateRate = updateRate;
    }

    @XmlElement(name="ray")
    public void setRay(URDFRay ray) {
        this.ray = ray;
    }

    @XmlElement(name="camera")
    public void setCamera(List<URDFCamera> camera) {
        this.camera = camera;
    }

    @XmlElement(name="imu")
    public void setImu(URDFIMU imu) {
        this.imu = imu;
    }

    public String getName() {
        return this.name;
    }

    public String getPose() {
        return this.pose;
    }

    public String getType() {
        return this.type;
    }

    public String getVisualize() {
        return this.visualize;
    }

    public String getUpdateRate() {
        return this.updateRate;
    }

    public URDFRay getRay() {
        return this.ray;
    }

    public List<URDFCamera> getCamera() {
        return this.camera;
    }

    public URDFIMU getImu() {
        return this.imu;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, type: %s, updateRate: %s, pose: %s, camera: %s, ray: %s, imu: %s]", this.name, this.type, this.updateRate, this.pose, this.camera, this.ray, this.imu);
    }

    @Override
    public List<URDFFilenameHolder> getFilenameHolders() {
        return URDFItem.combineItemListsFilenameHolders(this.camera, Arrays.asList(this.ray, this.imu));
    }

    public String toString() {
        return this.itemToString();
    }

    public static enum URDFSensorType {
        camera,
        multicamera,
        depth,
        imu,
        gpu_ray,
        ray,
        force_torque,
        contact;


        public static URDFSensorType parse(String value) {
            if (value == null) {
                return null;
            }
            for (URDFSensorType type : URDFSensorType.values()) {
                if (!type.name().equals(value)) continue;
                return type;
            }
            return null;
        }
    }

    public static class URDFRay
    implements URDFItem {
        private String pose;
        private URDFRange range;
        private URDFScan scan;
        private URDFNoise noise;

        @XmlElement(name="pose")
        public void setPose(String pose) {
            this.pose = pose;
        }

        @XmlElement(name="range")
        public void setRange(URDFRange range) {
            this.range = range;
        }

        @XmlElement(name="scan")
        public void setScan(URDFScan scan) {
            this.scan = scan;
        }

        public String getPose() {
            return this.pose;
        }

        public URDFRange getRange() {
            return this.range;
        }

        public URDFScan getScan() {
            return this.scan;
        }

        public URDFNoise getNoise() {
            return this.noise;
        }

        @XmlElement(name="noise")
        public void setNoise(URDFNoise noise) {
            this.noise = noise;
        }

        @Override
        public String getContentAsString() {
            return this.format("[pose: %s, range: %s, scan: %s, noise: %s]", this.pose, this.range, this.scan, this.noise);
        }

        @Override
        public List<URDFFilenameHolder> getFilenameHolders() {
            return URDFItem.combineItemFilenameHolders(this.range, this.scan, this.noise);
        }

        public String toString() {
            return this.itemToString();
        }

        public static class URDFRange
        implements URDFItem {
            private String min;
            private String max;
            private String resolution;

            @XmlElement(name="min")
            public void setMin(String min) {
                this.min = min;
            }

            @XmlElement(name="max")
            public void setMax(String max) {
                this.max = max;
            }

            @XmlElement(name="resolution")
            public void setResolution(String resolution) {
                this.resolution = resolution;
            }

            public String getMin() {
                return this.min;
            }

            public String getMax() {
                return this.max;
            }

            public String getResolution() {
                return this.resolution;
            }

            @Override
            public String getContentAsString() {
                return this.format("[min: %s, max: %s, resolution: %s]", this.min, this.max, this.resolution);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }

        public static class URDFScan
        implements URDFItem {
            private URDFHorizontalScan horizontal;
            private URDFVerticalScan vertical;

            @XmlElement(name="horizontal")
            public void setHorizontal(URDFHorizontalScan horizontal) {
                this.horizontal = horizontal;
            }

            @XmlElement(name="vertical")
            public void setVertical(URDFVerticalScan vertical) {
                this.vertical = vertical;
            }

            public URDFHorizontalScan getHorizontal() {
                return this.horizontal;
            }

            public URDFVerticalScan getVertical() {
                return this.vertical;
            }

            @Override
            public String getContentAsString() {
                return this.format("[horizontal: %s, vertical: %s]", this.horizontal, this.vertical);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return URDFItem.combineItemFilenameHolders(this.horizontal, this.vertical);
            }

            public String toString() {
                return this.itemToString();
            }

            public static class URDFHorizontalScan
            implements URDFItem {
                private String samples;
                private String resolution;
                private String minAngle;
                private String maxAngle;

                @XmlElement(name="samples")
                public void setSamples(String samples) {
                    this.samples = samples;
                }

                @XmlElement(name="resolution")
                public void setResolution(String resolution) {
                    this.resolution = resolution;
                }

                @XmlElement(name="min_angle")
                public void setMinAngle(String minAngle) {
                    this.minAngle = minAngle;
                }

                @XmlElement(name="max_angle")
                public void setMaxAngle(String maxAngle) {
                    this.maxAngle = maxAngle;
                }

                public String getSamples() {
                    return this.samples;
                }

                public String getResolution() {
                    return this.resolution;
                }

                public String getMinAngle() {
                    return this.minAngle;
                }

                public String getMaxAngle() {
                    return this.maxAngle;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[samples: %s, resolution: %s, minAngle: %s, maxAngle: %s]", this.samples, this.resolution, this.minAngle, this.maxAngle);
                }

                @Override
                public List<URDFFilenameHolder> getFilenameHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }

            public static class URDFVerticalScan
            implements URDFItem {
                private String samples;
                private String resolution;
                private String minAngle;
                private String maxAngle;

                @XmlElement(name="samples")
                public void setSamples(String samples) {
                    this.samples = samples;
                }

                @XmlElement(name="resolution")
                public void setResolution(String resolution) {
                    this.resolution = resolution;
                }

                @XmlElement(name="min_angle")
                public void setMinAngle(String minAngle) {
                    this.minAngle = minAngle;
                }

                @XmlElement(name="max_angle")
                public void setMaxAngle(String maxAngle) {
                    this.maxAngle = maxAngle;
                }

                public String getSamples() {
                    return this.samples;
                }

                public String getResolution() {
                    return this.resolution;
                }

                public String getMinAngle() {
                    return this.minAngle;
                }

                public String getMaxAngle() {
                    return this.maxAngle;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[samples: %s, resolution: %s, minAngle: %s, maxAngle: %s]", this.samples, this.resolution, this.minAngle, this.maxAngle);
                }

                @Override
                public List<URDFFilenameHolder> getFilenameHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }
        }

        public static class URDFNoise
        implements URDFItem {
            private String type;
            private String mean;
            private String stddev;

            @XmlElement(name="type")
            public void setType(String type) {
                this.type = type;
            }

            public void setType(URDFNoiseType type) {
                this.setType(type.name());
            }

            @XmlElement(name="mean")
            public void setMean(String mean) {
                this.mean = mean;
            }

            @XmlElement(name="stddev")
            public void setStddev(String stddev) {
                this.stddev = stddev;
            }

            public String getType() {
                return this.type;
            }

            public String getMean() {
                return this.mean;
            }

            public String getStddev() {
                return this.stddev;
            }

            @Override
            public String getContentAsString() {
                return this.format("[type: %s, mean: %s, stddev]", this.type, this.mean, this.stddev);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }

            public static enum URDFNoiseType {
                gaussian;


                public static URDFNoiseType parse(String value) {
                    if (value == null) {
                        return null;
                    }
                    for (URDFNoiseType type : URDFNoiseType.values()) {
                        if (!type.name().equals(value)) continue;
                        return type;
                    }
                    return null;
                }
            }
        }
    }

    public static class URDFIMU
    implements URDFItem {
        private URDFIMUNoise noise;

        public URDFIMUNoise getNoise() {
            return this.noise;
        }

        @XmlElement(name="noise")
        public void setNoise(URDFIMUNoise noise) {
            this.noise = noise;
        }

        @Override
        public String getContentAsString() {
            return this.format("[noise: %s]", this.noise);
        }

        @Override
        public List<URDFFilenameHolder> getFilenameHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }

        public static class URDFIMUNoise
        implements URDFItem {
            private String type;
            private URDFNoiseParameters rate;
            private URDFNoiseParameters accel;

            public String getType() {
                return this.type;
            }

            public URDFNoiseParameters getRate() {
                return this.rate;
            }

            public URDFNoiseParameters getAccel() {
                return this.accel;
            }

            @XmlElement(name="type")
            public void setType(String type) {
                this.type = type;
            }

            public void setType(URDFIMUNoiseType type) {
                this.setType(type.name());
            }

            @XmlElement(name="rate")
            public void setRate(URDFNoiseParameters rate) {
                this.rate = rate;
            }

            @XmlElement(name="accel")
            public void setAccel(URDFNoiseParameters accel) {
                this.accel = accel;
            }

            @Override
            public String getContentAsString() {
                return this.format("[type: %s, rate: %s, accel: %s]", this.type, this.rate, this.accel);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }

            public static class URDFNoiseParameters
            implements URDFItem {
                private String mean;
                private String stddev;
                private String bias_mean;
                private String bias_stddev;

                public String getMean() {
                    return this.mean;
                }

                public String getStddev() {
                    return this.stddev;
                }

                public String getBias_mean() {
                    return this.bias_mean;
                }

                public String getBias_stddev() {
                    return this.bias_stddev;
                }

                @XmlElement(name="mean")
                public void setMean(String mean) {
                    this.mean = mean;
                }

                @XmlElement(name="stddev")
                public void setStddev(String stddev) {
                    this.stddev = stddev;
                }

                @XmlElement(name="bias_mean")
                public void setBias_mean(String bias_mean) {
                    this.bias_mean = bias_mean;
                }

                @XmlElement(name="bias_stddev")
                public void setBias_stddev(String bias_stddev) {
                    this.bias_stddev = bias_stddev;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[mean: %s, stddev: %s, bias_mean: %s, bias_stddev: %s]", this.mean, this.stddev, this.bias_mean, this.bias_stddev);
                }

                @Override
                public List<URDFFilenameHolder> getFilenameHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }

            public static enum URDFIMUNoiseType {
                gaussian;


                public static URDFIMUNoiseType parse(String value) {
                    if (value == null) {
                        return null;
                    }
                    for (URDFIMUNoiseType type : URDFIMUNoiseType.values()) {
                        if (!type.name().equals(value)) continue;
                        return type;
                    }
                    return null;
                }
            }
        }
    }

    public static class URDFCamera
    implements URDFItem {
        private String name;
        private String pose;
        private String horizontalFov;
        private URDFSensorImage image;
        private URDFClip clip;

        public String getPose() {
            return this.pose;
        }

        @XmlElement(name="pose")
        public void setPose(String pose) {
            this.pose = pose;
        }

        public String getHorizontalFov() {
            return this.horizontalFov;
        }

        @XmlElement(name="horizontal_fov")
        public void setHorizontalFov(String horizontalFov) {
            this.horizontalFov = horizontalFov;
        }

        public URDFSensorImage getImage() {
            return this.image;
        }

        @XmlElement(name="image")
        public void setImage(URDFSensorImage image) {
            this.image = image;
        }

        public URDFClip getClip() {
            return this.clip;
        }

        @XmlElement(name="clip")
        public void setClip(URDFClip clip) {
            this.clip = clip;
        }

        @XmlAttribute(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getContentAsString() {
            return this.format("[name: %s, pose: %s, horizontalFov: %s, image: %s, clip: %s]", this.name, this.pose, this.horizontalFov, this.image, this.clip);
        }

        @Override
        public List<URDFFilenameHolder> getFilenameHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }

        public static class URDFSensorImage
        implements URDFItem {
            private String width;
            private String height;
            private String format;

            public String getWidth() {
                return this.width;
            }

            @XmlElement(name="width")
            public void setWidth(String width) {
                this.width = width;
            }

            public String getHeight() {
                return this.height;
            }

            @XmlElement(name="height")
            public void setHeight(String height) {
                this.height = height;
            }

            public String getFormat() {
                return this.format;
            }

            @XmlElement(name="format")
            public void setFormat(String format) {
                this.format = format;
            }

            @Override
            public String getContentAsString() {
                return this.format("[width: %s, height: %s, format: %s]", this.width, this.height, this.format);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }

        public static class URDFClip
        implements URDFItem {
            private String near;
            private String far;

            public String getNear() {
                return this.near;
            }

            @XmlElement(name="near")
            public void setNear(String near) {
                this.near = near;
            }

            public String getFar() {
                return this.far;
            }

            @XmlElement(name="far")
            public void setFar(String far) {
                this.far = far;
            }

            @Override
            public String getContentAsString() {
                return this.format("[near: %s, far: %s]", this.near, this.far);
            }

            @Override
            public List<URDFFilenameHolder> getFilenameHolders() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.itemToString();
            }
        }
    }
}

