/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.urdf.items;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.scs2.definition.robot.urdf.items.URDFAxis;
import us.ihmc.scs2.definition.robot.urdf.items.URDFCalibration;
import us.ihmc.scs2.definition.robot.urdf.items.URDFDynamics;
import us.ihmc.scs2.definition.robot.urdf.items.URDFFilenameHolder;
import us.ihmc.scs2.definition.robot.urdf.items.URDFItem;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLimit;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLink;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLinkReference;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMimic;
import us.ihmc.scs2.definition.robot.urdf.items.URDFOrigin;
import us.ihmc.scs2.definition.robot.urdf.items.URDFSafetyController;

@XmlType(propOrder={"name", "type", "origin", "axis", "parent", "child", "calibration", "dynamics", "limit", "mimic", "safetyController", "actuatedJointIndex", "subJoints", "subLinks"})
public class URDFJoint
implements URDFItem {
    private String name;
    private String type;
    private URDFOrigin origin;
    private URDFLinkReference parent;
    private URDFLinkReference child;
    private URDFAxis axis;
    private URDFCalibration calibration;
    private URDFDynamics dynamics;
    private URDFLimit limit;
    private URDFMimic mimic;
    private URDFSafetyController safetyController;
    private List<URDFJoint> subJoints;
    private List<URDFLink> subLinks;
    private String actuatedJointIndex;

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="type")
    public void setType(String type) {
        this.type = type;
    }

    public void setType(URDFJointType type) {
        this.setType(type.name());
    }

    @XmlElement(name="origin")
    public void setOrigin(URDFOrigin origin) {
        this.origin = origin;
    }

    @XmlElement(name="parent")
    public void setParent(URDFLinkReference parent) {
        this.parent = parent;
    }

    @XmlElement(name="child")
    public void setChild(URDFLinkReference child) {
        this.child = child;
    }

    @XmlElement(name="axis")
    public void setAxis(URDFAxis axis) {
        this.axis = axis;
    }

    @XmlElement(name="calibration")
    public void setCalibration(URDFCalibration calibration) {
        this.calibration = calibration;
    }

    @XmlElement(name="dynamics")
    public void setDynamics(URDFDynamics dynamics) {
        this.dynamics = dynamics;
    }

    @XmlElement(name="limit")
    public void setLimit(URDFLimit limit) {
        this.limit = limit;
    }

    @XmlElement(name="mimic")
    public void setMimic(URDFMimic mimic) {
        this.mimic = mimic;
    }

    @XmlElement(name="safety_controller")
    public void setSafetyController(URDFSafetyController safetyController) {
        this.safetyController = safetyController;
    }

    @XmlElement(name="sub_joint")
    public void setSubJoints(List<URDFJoint> subJoints) {
        this.subJoints = subJoints;
    }

    @XmlElement(name="sub_link")
    public void setSubLinks(List<URDFLink> subLinks) {
        this.subLinks = subLinks;
    }

    @XmlElement(name="actuated_joint_index")
    public void setActuatedJointIndex(String actuatedJointIndex) {
        this.actuatedJointIndex = actuatedJointIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public URDFOrigin getOrigin() {
        return this.origin;
    }

    public URDFLinkReference getParent() {
        return this.parent;
    }

    public URDFLinkReference getChild() {
        return this.child;
    }

    public URDFAxis getAxis() {
        return this.axis;
    }

    public URDFCalibration getCalibration() {
        return this.calibration;
    }

    public URDFDynamics getDynamics() {
        return this.dynamics;
    }

    public URDFLimit getLimit() {
        return this.limit;
    }

    public URDFMimic getMimic() {
        return this.mimic;
    }

    public URDFSafetyController getSafetyController() {
        return this.safetyController;
    }

    public List<URDFJoint> getSubJoints() {
        return this.subJoints;
    }

    public List<URDFLink> getSubLinks() {
        return this.subLinks;
    }

    public String getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, type: %s, origin: %s, parent: %s, child: %s, axis: %s, calibration: %s, dynamics: %s, limit: %s, mimic: %s, safetyController: %s]", this.name, this.type, this.origin, this.parent, this.child, this.axis, this.calibration, this.dynamics, this.limit, this.mimic, this.safetyController, this.subJoints, this.subLinks);
    }

    public String toString() {
        return this.itemToString();
    }

    @Override
    public List<URDFFilenameHolder> getFilenameHolders() {
        List<URDFFilenameHolder> filenameHolders = URDFItem.combineItemFilenameHolders(this.origin, this.parent, this.child, this.axis, this.calibration, this.dynamics, this.limit, this.mimic, this.safetyController);
        filenameHolders.addAll(URDFItem.combineItemListsFilenameHolders(this.subJoints, this.subLinks));
        return filenameHolders;
    }

    public static enum URDFJointType {
        continuous,
        revolute,
        prismatic,
        fixed,
        floating,
        planar,
        cross_four_bar,
        revolute_twins;


        public static URDFJointType parse(String value) {
            if (value == null) {
                return null;
            }
            for (URDFJointType type : URDFJointType.values()) {
                if (!type.name().equals(value)) continue;
                return type;
            }
            return null;
        }
    }
}

