/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.robot.sdf.items.SDFCollision;
import us.ihmc.scs2.definition.robot.sdf.items.SDFInertia;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFSensor;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;
import us.ihmc.scs2.definition.robot.sdf.items.SDFVisual;

public class SDFLink
implements SDFItem {
    private String name;
    private String pose;
    private SDFInertial inertial;
    private List<SDFVisual> visuals;
    private List<SDFSensor> sensors;
    private List<SDFCollision> collisions;

    public String getName() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    public String getPose() {
        return this.pose;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    public SDFInertial getInertial() {
        return this.inertial;
    }

    @XmlElement(name="inertial")
    public void setInertial(SDFInertial inertial) {
        this.inertial = inertial;
    }

    public List<SDFVisual> getVisuals() {
        return this.visuals;
    }

    @XmlElement(name="visual")
    public void setVisuals(List<SDFVisual> visual) {
        this.visuals = visual;
    }

    public List<SDFCollision> getCollisions() {
        return this.collisions;
    }

    @XmlElement(name="collision")
    public void setCollisions(List<SDFCollision> collision) {
        this.collisions = collision;
    }

    public List<SDFSensor> getSensors() {
        return this.sensors;
    }

    @XmlElement(name="sensor")
    public void setSensors(List<SDFSensor> sensors) {
        this.sensors = sensors;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, pose: %s, inertial: %s, visuals: %s, sensors: %s, collisions: %s]", this.name, this.pose, this.inertial, this.visuals, this.sensors, this.collisions);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemListsURIHolders(Arrays.asList(this.inertial), this.visuals, this.sensors, this.collisions);
    }

    public String toString() {
        return this.itemToString();
    }

    public static class SDFInertial
    implements SDFItem {
        private String mass;
        private String pose;
        private SDFInertia inertia;

        public String getMass() {
            return this.mass;
        }

        @XmlElement(name="mass")
        public void setMass(String mass) {
            this.mass = mass;
        }

        public String getPose() {
            return this.pose;
        }

        @XmlElement(name="pose")
        public void setPose(String pose) {
            this.pose = pose;
        }

        public SDFInertia getInertia() {
            return this.inertia;
        }

        @XmlElement(name="inertia")
        public void setInertia(SDFInertia inertia) {
            this.inertia = inertia;
        }

        @Override
        public String getContentAsString() {
            return this.format("[mass: %s, pose: %s, inertia: %s]", this.mass, this.pose, this.inertia);
        }

        public List<SDFURIHolder> getURIHolders() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.itemToString();
        }
    }
}

