/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;

public interface JointStateReadOnly {
    public int getConfigurationSize();

    public int getDegreesOfFreedom();

    public boolean hasOutputFor(JointStateType var1);

    public void getConfiguration(JointBasics var1);

    public int getConfiguration(int var1, DMatrix var2);

    public void getVelocity(JointBasics var1);

    public int getVelocity(int var1, DMatrix var2);

    public void getAcceleration(JointBasics var1);

    public int getAcceleration(int var1, DMatrix var2);

    public void getEffort(JointBasics var1);

    public int getEffort(int var1, DMatrix var2);

    default public void getAllStates(JointBasics jointToUpdate) {
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            this.getConfiguration(jointToUpdate);
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            this.getVelocity(jointToUpdate);
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            this.getAcceleration(jointToUpdate);
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            this.getEffort(jointToUpdate);
        }
    }

    default public void checkConfigurationSize(JointReadOnly joint) {
        if (joint.getConfigurationMatrixSize() != this.getConfigurationSize()) {
            throw new IllegalArgumentException("Bad configuration size: expected = " + this.getConfigurationSize() + ", was = " + joint.getConfigurationMatrixSize());
        }
    }

    default public void checkConfigurationSize(int startRow, DMatrix configurationMatrix) {
        if (configurationMatrix.getNumRows() - startRow < this.getConfigurationSize()) {
            throw new IllegalArgumentException("Bad configuration size: expected >= " + this.getConfigurationSize() + ", was = " + configurationMatrix.getNumRows());
        }
    }

    default public void checkDegreesOfFreedom(JointReadOnly joint) {
        if (joint.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
            throw new IllegalArgumentException("Bad number of DoFs: expected = " + this.getDegreesOfFreedom() + ", was = " + joint.getDegreesOfFreedom());
        }
    }

    default public void checkDegreesOfFreedom(int startRow, DMatrix degreesOfFreedomMatrix) {
        if (degreesOfFreedomMatrix.getNumRows() - startRow < this.getDegreesOfFreedom()) {
            throw new IllegalArgumentException("Bad number of DoFs: expected >= " + this.getDegreesOfFreedom() + ", was = " + degreesOfFreedomMatrix.getNumRows());
        }
    }
}

