/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.PlanarJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.PlanarJointStateReadOnly;

public class PlanarJointState
extends JointStateBase
implements PlanarJointStateBasics {
    private double pitch = Double.NaN;
    private double positionX = Double.NaN;
    private double positionZ = Double.NaN;
    private double pitchVelocity = Double.NaN;
    private double linearVelocityX = Double.NaN;
    private double linearVelocityZ = Double.NaN;
    private double pitchAcceleration = Double.NaN;
    private double linearAccelerationX = Double.NaN;
    private double linearAccelerationZ = Double.NaN;
    private double torqueY = Double.NaN;
    private double forceX = Double.NaN;
    private double forceZ = Double.NaN;
    private final DMatrixRMaj temp = new DMatrixRMaj(3, 1);

    public PlanarJointState() {
        this.clear();
    }

    public PlanarJointState(JointStateReadOnly other) {
        this.clear();
        this.set(other);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof PlanarJointStateReadOnly) {
            PlanarJointStateBasics.super.set((PlanarJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    public void setConfiguration(double pitch, double positionX, double positionZ) {
        this.pitch = pitch;
        this.positionX = positionX;
        this.positionZ = positionZ;
    }

    @Override
    public void setVelocity(double pitchVelocity, double linearVelocityX, double linearVelocityZ) {
        this.pitchVelocity = pitchVelocity;
        this.linearVelocityX = linearVelocityX;
        this.linearVelocityZ = linearVelocityZ;
    }

    @Override
    public void setAcceleration(double pitchAcceleration, double linearAccelerationX, double linearAccelerationZ) {
        this.pitchAcceleration = pitchAcceleration;
        this.linearAccelerationX = linearAccelerationX;
        this.linearAccelerationZ = linearAccelerationZ;
    }

    @Override
    public void setEffort(double torqueY, double forceX, double forceZ) {
        this.torqueY = torqueY;
        this.forceX = forceX;
        this.forceZ = forceZ;
    }

    @Override
    public double getPitch() {
        return this.pitch;
    }

    @Override
    public double getPositionX() {
        return this.positionX;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    @Override
    public double getPitchVelocity() {
        return this.pitchVelocity;
    }

    @Override
    public double getLinearVelocityX() {
        return this.linearVelocityX;
    }

    @Override
    public double getLinearVelocityZ() {
        return this.linearVelocityZ;
    }

    @Override
    public double getPitchAcceleration() {
        return this.pitchAcceleration;
    }

    @Override
    public double getLinearAccelerationX() {
        return this.linearAccelerationX;
    }

    @Override
    public double getLinearAccelerationZ() {
        return this.linearAccelerationZ;
    }

    @Override
    public double getTorqueY() {
        return this.torqueY;
    }

    @Override
    public double getForceX() {
        return this.forceX;
    }

    @Override
    public double getForceZ() {
        return this.forceZ;
    }

    @Override
    public PlanarJointState copy() {
        return new PlanarJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.pitch);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.positionX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.positionZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.pitchVelocity);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.linearVelocityX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.linearVelocityZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.pitchAcceleration);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.linearAccelerationX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.linearAccelerationZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.torqueY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.forceX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.forceZ);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlanarJointState other = (PlanarJointState)object;
        if (!EuclidCoreTools.equals((double)this.pitch, (double)other.pitch)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.positionX, (double)other.positionX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.positionZ, (double)other.positionZ)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.pitchVelocity, (double)other.pitchVelocity)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.linearVelocityX, (double)other.linearVelocityX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.linearVelocityZ, (double)other.linearVelocityZ)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.pitchAcceleration, (double)other.pitchAcceleration)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.linearAccelerationX, (double)other.linearAccelerationX)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.linearAccelerationZ, (double)other.linearAccelerationZ)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.torqueY, (double)other.torqueY)) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.forceX, (double)other.forceX)) {
            return false;
        }
        return EuclidCoreTools.equals((double)this.forceZ, (double)other.forceZ);
    }

    public String toString() {
        Object ret = "Planar joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + EuclidCoreIOTools.getStringOf((String)", configuration: [", (String)"]", (String)", ", (double[])new double[]{this.pitch, this.positionX, this.positionZ});
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + EuclidCoreIOTools.getStringOf((String)", velocity: [", (String)"]", (String)", ", (double[])new double[]{this.pitchVelocity, this.linearVelocityX, this.linearVelocityZ});
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + EuclidCoreIOTools.getStringOf((String)", acceleration: [", (String)"]", (String)", ", (double[])new double[]{this.pitchAcceleration, this.linearAccelerationX, this.linearAccelerationZ});
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + EuclidCoreIOTools.getStringOf((String)", effort: [", (String)"]", (String)", ", (double[])new double[]{this.torqueY, this.forceX, this.forceZ});
        }
        return ret;
    }
}

