/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.Objects;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteTwinsJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;

public class RevoluteTwinsJointDefinition
extends OneDoFJointDefinition {
    private String jointNameA;
    private String jointNameB;
    private YawPitchRollTransformDefinition transformAToPredecessor = new YawPitchRollTransformDefinition();
    private YawPitchRollTransformDefinition transformBToA = new YawPitchRollTransformDefinition();
    private RigidBodyDefinition bodyAB = new RigidBodyDefinition();
    private int actuatedJointIndex;
    private double constraintRatio;
    private double constraintOffset;

    public RevoluteTwinsJointDefinition() {
    }

    public RevoluteTwinsJointDefinition(String name) {
        super(name);
        this.bodyAB.setName(name + "_AB");
    }

    public RevoluteTwinsJointDefinition(String name, Vector3DReadOnly axis) {
        this(name);
        this.setAxis(axis);
    }

    public void setJointNameA(String jointNameA) {
        this.jointNameA = jointNameA;
    }

    public void setJointNameB(String jointNameB) {
        this.jointNameB = jointNameB;
    }

    public void setJointNames(String jointNameA, String jointNameB) {
        this.jointNameA = jointNameA;
        this.jointNameB = jointNameB;
    }

    public void setTransformAToPredecessor(YawPitchRollTransformDefinition transformAToPredecessor) {
        this.transformAToPredecessor = transformAToPredecessor;
    }

    public void setTransformAToPredecessor(RigidBodyTransformReadOnly transformAToPredecessor) {
        this.transformAToPredecessor.set(transformAToPredecessor);
    }

    public void setTransformBToA(YawPitchRollTransformDefinition transformBToA) {
        this.transformBToA = transformBToA;
    }

    public void setTransformBToA(RigidBodyTransformReadOnly transformBToA) {
        this.transformBToA.set(transformBToA);
    }

    public void setJointTransforms(YawPitchRollTransformDefinition transformAToPredecessor, YawPitchRollTransformDefinition transformBToA) {
        this.transformAToPredecessor = transformAToPredecessor;
        this.transformBToA = transformBToA;
    }

    public void setJointTransforms(RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToA) {
        this.transformAToPredecessor.set(transformAToPredecessor);
        this.transformBToA.set(transformBToA);
    }

    public void setBodyAB(RigidBodyDefinition bodyAB) {
        this.bodyAB = bodyAB;
    }

    public void setActuatedJointIndex(int actuatedJointIndex) {
        this.actuatedJointIndex = actuatedJointIndex;
    }

    public void setConstraintRatio(double constraintRatio) {
        this.constraintRatio = constraintRatio;
    }

    public void setConstraintOffset(double constraintOffset) {
        this.constraintOffset = constraintOffset;
    }

    public String getJointNameA() {
        return this.jointNameA;
    }

    public String getJointNameB() {
        return this.jointNameB;
    }

    public YawPitchRollTransformDefinition getTransformAToPredecessor() {
        return this.transformAToPredecessor;
    }

    public YawPitchRollTransformDefinition getTransformBToA() {
        return this.transformBToA;
    }

    public RigidBodyDefinition getBodyAB() {
        return this.bodyAB;
    }

    public int getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    public double getConstraintRatio() {
        return this.constraintRatio;
    }

    public double getConstraintOffset() {
        return this.constraintOffset;
    }

    public RevoluteTwinsJoint toJoint(RigidBodyBasics predecessor) {
        return new RevoluteTwinsJoint(this.getName(), predecessor, this.jointNameA, this.jointNameB, this.bodyAB.getName(), (RigidBodyTransformReadOnly)this.transformAToPredecessor, (RigidBodyTransformReadOnly)this.transformBToA, (Matrix3DReadOnly)this.bodyAB.getMomentOfInertia(), this.bodyAB.getMass(), (RigidBodyTransformReadOnly)this.bodyAB.getInertiaPose(), this.actuatedJointIndex, this.constraintRatio, this.constraintOffset, (Vector3DReadOnly)this.getAxis());
    }

    @Override
    public RevoluteTwinsJointDefinition copy() {
        RevoluteTwinsJointDefinition clone = new RevoluteTwinsJointDefinition(this.getName(), (Vector3DReadOnly)this.getAxis());
        clone.jointNameA = this.jointNameA;
        clone.jointNameB = this.jointNameB;
        clone.transformAToPredecessor.set((RigidBodyTransformReadOnly)this.transformAToPredecessor);
        clone.transformBToA.set((RigidBodyTransformReadOnly)this.transformBToA);
        clone.bodyAB = this.bodyAB.copy();
        clone.actuatedJointIndex = this.actuatedJointIndex;
        clone.constraintRatio = this.constraintRatio;
        clone.constraintOffset = this.constraintOffset;
        return clone;
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.jointNameA);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.jointNameB);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.transformAToPredecessor);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.transformBToA);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.bodyAB);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.actuatedJointIndex);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.constraintRatio);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.constraintOffset);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RevoluteTwinsJointDefinition other = (RevoluteTwinsJointDefinition)object;
        if (!Objects.equals(this.jointNameA, other.jointNameA)) {
            return false;
        }
        if (!Objects.equals(this.jointNameB, other.jointNameB)) {
            return false;
        }
        if (!Objects.equals(this.transformAToPredecessor, other.transformAToPredecessor)) {
            return false;
        }
        if (!Objects.equals(this.transformBToA, other.transformBToA)) {
            return false;
        }
        if (!Objects.equals(this.bodyAB, other.bodyAB)) {
            return false;
        }
        if (this.actuatedJointIndex != other.actuatedJointIndex) {
            return false;
        }
        if (Double.doubleToLongBits(this.constraintRatio) != Double.doubleToLongBits(other.constraintRatio)) {
            return false;
        }
        return Double.doubleToLongBits(this.constraintOffset) == Double.doubleToLongBits(other.constraintOffset);
    }
}

