/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorPalette;

public class TextureDefinitionColorAdaptivePalette
implements TextureDefinitionColorPalette {
    private static final boolean PRINT_PALETTE = false;
    private static final int DEFAULT_PALETTE_SIZE = 1024;
    private BufferedImage colorPalette;
    private int paletteSize;
    private int pixelSize;
    private final List<ColorDefinition> colorList = new ArrayList<ColorDefinition>();
    private final Map<ColorDefinition, Integer> registeredColors = new HashMap<ColorDefinition, Integer>();
    private final boolean autoClear;

    public TextureDefinitionColorAdaptivePalette() {
        this(1024, 1, true);
    }

    public TextureDefinitionColorAdaptivePalette(boolean autoClear) {
        this(1024, 1, autoClear);
    }

    public TextureDefinitionColorAdaptivePalette(int paletteSize) {
        this(paletteSize, 1, true);
    }

    public TextureDefinitionColorAdaptivePalette(int paletteSize, boolean autoClear) {
        this(paletteSize, 1, autoClear);
    }

    public TextureDefinitionColorAdaptivePalette(int paletteSize, int colorPixelSize, boolean autoClear) {
        if (colorPixelSize >= paletteSize) {
            throw new RuntimeException("The size of pixels has to be smaller than the size of the palette.");
        }
        this.autoClear = autoClear;
        this.paletteSize = paletteSize;
        this.pixelSize = colorPixelSize;
    }

    public void clearPalette() {
        this.colorPalette = null;
        this.colorList.clear();
        this.registeredColors.clear();
    }

    private void initializePalette() {
        this.colorPalette = new BufferedImage(this.paletteSize, this.paletteSize, 2);
        this.colorList.clear();
        this.registeredColors.clear();
    }

    @Override
    public Point2D32 getTextureLocation(ColorDefinition color) {
        Integer pixelIndex;
        if (this.colorPalette == null) {
            this.initializePalette();
        }
        if ((pixelIndex = this.registeredColors.get(color)) != null) {
            return this.getTextureLocation(pixelIndex);
        }
        int newPixelIndex = this.colorList.size();
        if (newPixelIndex <= this.paletteSize * this.paletteSize) {
            this.colorList.add(color);
            this.registeredColors.put(color, newPixelIndex);
            this.writePixel(newPixelIndex, color);
            return this.getTextureLocation(newPixelIndex);
        }
        LogTools.error((String)"Reached maximum capacity of the palette. Next colors will be wrong.");
        return new Point2D32();
    }

    private Point2D32 getTextureLocation(int pixelIndex) {
        int scaledWidth = this.colorPalette.getWidth() / this.pixelSize;
        int scaledHeight = this.colorPalette.getHeight() / this.pixelSize;
        float x = (float)Math.floorMod(pixelIndex, scaledWidth) / (float)scaledWidth;
        float y = (float)Math.floorDiv(pixelIndex, scaledWidth) / (float)scaledHeight;
        return new Point2D32(x += 0.5f * (float)this.pixelSize / (float)this.colorPalette.getWidth(), y += 0.5f * (float)this.pixelSize / (float)this.colorPalette.getHeight());
    }

    private void writePixel(int pixelIndex, ColorDefinition color) {
        int width = this.colorPalette.getWidth();
        int xStart = Math.floorMod(pixelIndex * this.pixelSize, width);
        int yStart = Math.floorDiv(pixelIndex * this.pixelSize, width) * this.pixelSize;
        for (int x = xStart; x < xStart + this.pixelSize; ++x) {
            for (int y = yStart; y < yStart + this.pixelSize; ++y) {
                this.colorPalette.setRGB(x, y, color.toARGB());
            }
        }
    }

    @Override
    public TextureDefinition getTextureDefinition() {
        BufferedImage ret = this.colorPalette;
        if (this.autoClear) {
            this.clearPalette();
        }
        return new TextureDefinition(ret);
    }
}

