/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;

public class ColorDefinitions {
    public static final Map<String, ColorDefinition> namedColorLowerCaseMap;

    private static boolean isNamedColorMethod(Method method) {
        if (method.getReturnType() != ColorDefinition.class) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getParameterCount() == 0;
    }

    private static final ColorDefinition invokeMethod(Method method) {
        try {
            return (ColorDefinition)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Problem invoking color factory", e);
        }
    }

    public static ColorDefinition rgb(int rgb) {
        return ColorDefinitions.argb(0xFF000000 | rgb);
    }

    public static ColorDefinition argb(int argb) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setAlpha((double)(argb >> 24 & 0xFF) / 255.0);
        colorDescription.setRed((double)(argb >> 16 & 0xFF) / 255.0);
        colorDescription.setGreen((double)(argb >> 8 & 0xFF) / 255.0);
        colorDescription.setBlue((double)(argb >> 0 & 0xFF) / 255.0);
        return colorDescription;
    }

    public static ColorDefinition rgba(int rgba) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setRed((double)(rgba >> 24 & 0xFF) / 255.0);
        colorDescription.setGreen((double)(rgba >> 16 & 0xFF) / 255.0);
        colorDescription.setBlue((double)(rgba >> 8 & 0xFF) / 255.0);
        colorDescription.setAlpha((double)(rgba >> 0 & 0xFF) / 255.0);
        return colorDescription;
    }

    public static ColorDefinition rgb(int[] rgb) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setRed(rgb[0]);
        colorDescription.setGreen(rgb[1]);
        colorDescription.setBlue(rgb[2]);
        colorDescription.setAlpha(1.0);
        return colorDescription;
    }

    public static ColorDefinition rgb(double[] rgb) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setRed(rgb[0]);
        colorDescription.setGreen(rgb[1]);
        colorDescription.setBlue(rgb[2]);
        colorDescription.setAlpha(1.0);
        return colorDescription;
    }

    public static ColorDefinition rgba(int[] rgba) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setRed(rgba[0]);
        colorDescription.setGreen(rgba[1]);
        colorDescription.setBlue(rgba[2]);
        colorDescription.setAlpha(rgba[3]);
        return colorDescription;
    }

    public static ColorDefinition rgba(double[] rgba) {
        ColorDefinition colorDescription = new ColorDefinition();
        colorDescription.setRed(rgba[0]);
        colorDescription.setGreen(rgba[1]);
        colorDescription.setBlue(rgba[2]);
        colorDescription.setAlpha(rgba[3]);
        return colorDescription;
    }

    public static int toRGB(double red, double green, double blue) {
        int r = (int)Math.round(red * 255.0);
        int g = (int)Math.round(green * 255.0);
        int b = (int)Math.round(blue * 255.0);
        return ColorDefinitions.toRGB(r, g, b);
    }

    public static int toRGB(int red, int green, int blue) {
        int rgba = (red & 0xFF) << 16;
        rgba |= (green & 0xFF) << 8;
        return rgba |= (blue & 0xFF) << 0;
    }

    public static int toARGB(double red, double green, double blue, double alpha) {
        int r = (int)Math.round(red * 255.0);
        int g = (int)Math.round(green * 255.0);
        int b = (int)Math.round(blue * 255.0);
        int a = (int)Math.round(alpha * 255.0);
        return ColorDefinitions.toARGB(r, g, b, a);
    }

    public static int toARGB(int red, int green, int blue, int alpha) {
        int rgba = (alpha & 0xFF) << 24;
        rgba |= (red & 0xFF) << 16;
        rgba |= (green & 0xFF) << 8;
        return rgba |= (blue & 0xFF) << 0;
    }

    public static int toRGBA(double red, double green, double blue, double alpha) {
        int r = (int)Math.round(red * 255.0);
        int g = (int)Math.round(green * 255.0);
        int b = (int)Math.round(blue * 255.0);
        int a = (int)Math.round(alpha * 255.0);
        return ColorDefinitions.toRGBA(r, g, b, a);
    }

    public static int toRGBA(int red, int green, int blue, int alpha) {
        int rgba = (red & 0xFF) << 24;
        rgba |= (green & 0xFF) << 16;
        rgba |= (blue & 0xFF) << 8;
        return rgba |= (alpha & 0xFF) << 0;
    }

    public static ColorDefinition hsb(double[] hsb) {
        return ColorDefinitions.hsb(hsb[0], hsb[1], hsb[2]);
    }

    public static ColorDefinition hsb(double hue, double saturation, double brightness) {
        return ColorDefinitions.hsba(hue, saturation, brightness, 1.0);
    }

    public static ColorDefinition hsba(double[] hsba) {
        return ColorDefinitions.hsba(hsba[0], hsba[1], hsba[2], hsba[3]);
    }

    public static ColorDefinition hsba(double hue, double saturation, double brightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        brightness = MathTools.clamp((double)brightness, (double)0.0, (double)1.0);
        double c = brightness * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = brightness - c;
        if (hh <= 1.0) {
            return new ColorDefinition(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return new ColorDefinition(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return new ColorDefinition(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return new ColorDefinition(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return new ColorDefinition(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return new ColorDefinition(c + m, 0.0 + m, x + m, alpha);
        }
        return new ColorDefinition(m, m, m, alpha);
    }

    public static int hsbaToRGBA(double hue, double saturation, double brightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        brightness = MathTools.clamp((double)brightness, (double)0.0, (double)1.0);
        double c = brightness * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = brightness - c;
        if (hh <= 1.0) {
            return ColorDefinitions.toRGBA(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return ColorDefinitions.toRGBA(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return ColorDefinitions.toRGBA(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return ColorDefinitions.toRGBA(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return ColorDefinitions.toRGBA(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return ColorDefinitions.toRGBA(c + m, 0.0 + m, x + m, alpha);
        }
        return ColorDefinitions.toRGBA(m, m, m, alpha);
    }

    public static int hsbaToARGB(double hue, double saturation, double brightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        brightness = MathTools.clamp((double)brightness, (double)0.0, (double)1.0);
        double c = brightness * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = brightness - c;
        if (hh <= 1.0) {
            return ColorDefinitions.toARGB(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return ColorDefinitions.toARGB(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return ColorDefinitions.toARGB(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return ColorDefinitions.toARGB(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return ColorDefinitions.toARGB(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return ColorDefinitions.toARGB(c + m, 0.0 + m, x + m, alpha);
        }
        return ColorDefinitions.toARGB(m, m, m, alpha);
    }

    public static ColorDefinition hsl(double[] hsl) {
        return ColorDefinitions.hsl(hsl[0], hsl[1], hsl[2]);
    }

    public static ColorDefinition hsl(double hue, double saturation, double lightness) {
        return ColorDefinitions.hsla(hue, saturation, lightness, 1.0);
    }

    public static ColorDefinition hsla(double[] hsla) {
        return ColorDefinitions.hsla(hsla[0], hsla[1], hsla[2], hsla[3]);
    }

    public static ColorDefinition hsla(double hue, double saturation, double lightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        lightness = MathTools.clamp((double)lightness, (double)0.0, (double)1.0);
        double c = (1.0 - Math.abs(2.0 * lightness - 1.0)) * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = lightness - 0.5 * c;
        if (hh <= 1.0) {
            return new ColorDefinition(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return new ColorDefinition(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return new ColorDefinition(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return new ColorDefinition(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return new ColorDefinition(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return new ColorDefinition(c + m, 0.0 + m, x + m, alpha);
        }
        return new ColorDefinition(m, m, m, alpha);
    }

    public static int hslaToRGBA(double hue, double saturation, double lightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        lightness = MathTools.clamp((double)lightness, (double)0.0, (double)1.0);
        double c = (1.0 - Math.abs(2.0 * lightness - 1.0)) * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = lightness - 0.5 * c;
        if (hh <= 1.0) {
            return ColorDefinitions.toRGBA(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return ColorDefinitions.toRGBA(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return ColorDefinitions.toRGBA(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return ColorDefinitions.toRGBA(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return ColorDefinitions.toRGBA(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return ColorDefinitions.toRGBA(c + m, 0.0 + m, x + m, alpha);
        }
        return ColorDefinitions.toRGBA(m, m, m, alpha);
    }

    public static int hslaToARGB(double hue, double saturation, double lightness, double alpha) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        saturation = MathTools.clamp((double)saturation, (double)0.0, (double)1.0);
        lightness = MathTools.clamp((double)lightness, (double)0.0, (double)1.0);
        double c = (1.0 - Math.abs(2.0 * lightness - 1.0)) * saturation;
        double hh = hue / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = lightness - 0.5 * c;
        if (hh <= 1.0) {
            return ColorDefinitions.toARGB(c + m, x + m, 0.0 + m, alpha);
        }
        if (hh <= 2.0) {
            return ColorDefinitions.toARGB(x + m, c + m, 0.0 + m, alpha);
        }
        if (hh <= 3.0) {
            return ColorDefinitions.toARGB(0.0 + m, c + m, x + m, alpha);
        }
        if (hh <= 4.0) {
            return ColorDefinitions.toARGB(0.0 + m, x + m, c + m, alpha);
        }
        if (hh <= 5.0) {
            return ColorDefinitions.toARGB(x + m, 0.0 + m, c + m, alpha);
        }
        if (hh <= 6.0) {
            return ColorDefinitions.toARGB(c + m, 0.0 + m, x + m, alpha);
        }
        return ColorDefinitions.toARGB(m, m, m, alpha);
    }

    public static ColorDefinition parse(String webColor) {
        if (webColor == null) {
            return null;
        }
        String color = webColor.trim().toLowerCase();
        ColorDefinition namedColor = namedColorLowerCaseMap.get(color);
        if (namedColor != null) {
            return new ColorDefinition(namedColor);
        }
        if (color.startsWith("#") || color.startsWith("0x")) {
            String code = color.startsWith("#") ? color.substring(1) : color.substring(2);
            try {
                if (code.length() == 3) {
                    return new ColorDefinition((double)Integer.parseInt(code.substring(0, 1), 16) / 15.0, (double)Integer.parseInt(code.substring(1, 2), 16) / 15.0, (double)Integer.parseInt(code.substring(2, 3), 16) / 15.0);
                }
                if (code.length() == 4) {
                    return new ColorDefinition((double)Integer.parseInt(code.substring(0, 1), 16) / 15.0, (double)Integer.parseInt(code.substring(1, 2), 16) / 15.0, (double)Integer.parseInt(code.substring(2, 3), 16) / 15.0, (double)Integer.parseInt(code.substring(2, 3), 16) / 15.0);
                }
                if (code.length() == 6) {
                    return new ColorDefinition(Integer.parseInt(code.substring(0, 2), 16), Integer.parseInt(code.substring(2, 4), 16), Integer.parseInt(code.substring(4, 6), 16));
                }
                if (code.length() == 8) {
                    return new ColorDefinition(Integer.parseInt(code.substring(0, 2), 16), Integer.parseInt(code.substring(2, 4), 16), Integer.parseInt(code.substring(4, 6), 16), Integer.parseInt(code.substring(6, 8), 16));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse hex code: " + webColor);
            }
            throw new IllegalArgumentException("Unable to parse hex code: " + webColor);
        }
        if (color.startsWith("rgb")) {
            boolean parseAlpha = color.startsWith("a(", 3);
            int numberOfComponents = parseAlpha ? 4 : 3;
            color = color.substring(color.indexOf("(") + 1, color.lastIndexOf(")"));
            String[] rgbaArray = color.split(",");
            try {
                boolean parsePercent;
                for (int i = 0; i < numberOfComponents; ++i) {
                    rgbaArray[i] = rgbaArray[i].trim();
                }
                if (rgbaArray[0].contains("%")) {
                    if (!rgbaArray[1].contains("%") || !rgbaArray[2].contains("%")) {
                        throw new IllegalArgumentException("Inconsistent color formatting: " + webColor);
                    }
                    parsePercent = true;
                    for (int i = 0; i < 3; ++i) {
                        rgbaArray[i] = rgbaArray[i].substring(0, rgbaArray[i].length() - 1);
                    }
                } else {
                    if (rgbaArray[1].contains("%") || rgbaArray[2].contains("%")) {
                        throw new IllegalArgumentException("Inconsistent color formatting: " + webColor);
                    }
                    parsePercent = false;
                }
                double red = Integer.parseInt(rgbaArray[0]);
                double green = Integer.parseInt(rgbaArray[1]);
                double blue = Integer.parseInt(rgbaArray[2]);
                double alpha = 1.0;
                if (parseAlpha) {
                    try {
                        alpha = (double)Integer.parseInt(rgbaArray[3]) / 255.0;
                    }
                    catch (NumberFormatException e) {
                        alpha = Double.parseDouble(rgbaArray[3]);
                    }
                }
                if (parsePercent) {
                    red /= 100.0;
                    green /= 100.0;
                    blue /= 100.0;
                } else {
                    red /= 255.0;
                    green /= 255.0;
                    blue /= 255.0;
                }
                return new ColorDefinition(red, green, blue, alpha);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse RGBA color: " + webColor, e);
            }
        }
        if (color.startsWith("hsv") || color.startsWith("hsb") || color.startsWith("hsl")) {
            boolean parsePercent;
            boolean parseHSL = color.charAt(2) == 'l';
            boolean parseAlpha = color.startsWith("a(", 3);
            int numberOfComponents = parseAlpha ? 4 : 3;
            color = color.substring(color.indexOf("(") + 1, color.lastIndexOf(")"));
            String[] hsbArray = color.split(",");
            for (int i = 0; i < numberOfComponents; ++i) {
                hsbArray[i] = hsbArray[i].trim();
            }
            if (hsbArray[1].contains("%")) {
                if (!hsbArray[2].contains("%")) {
                    throw new IllegalArgumentException("Inconsistent color formatting: " + webColor);
                }
                parsePercent = true;
                hsbArray[1] = hsbArray[1].substring(0, hsbArray[1].length() - 1);
                hsbArray[2] = hsbArray[2].substring(0, hsbArray[2].length() - 1);
            } else {
                if (hsbArray[2].contains("%")) {
                    throw new IllegalArgumentException("Inconsistent color formatting: " + webColor);
                }
                parsePercent = false;
            }
            try {
                double alpha;
                double hue = Double.parseDouble(hsbArray[0].trim());
                double saturation = Double.parseDouble(hsbArray[1].trim());
                double brightness = Double.parseDouble(hsbArray[2].trim());
                double d = alpha = parseAlpha ? Double.parseDouble(hsbArray[3].trim()) : 1.0;
                if (parsePercent) {
                    saturation /= 100.0;
                    brightness /= 100.0;
                }
                if (parseHSL) {
                    return ColorDefinitions.hsla(hue, saturation, brightness, alpha);
                }
                return ColorDefinitions.hsba(hue, saturation, brightness, alpha);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse HSV/HSB/HSL color: " + webColor, e);
            }
        }
        throw new IllegalArgumentException("Unknown color format: " + webColor);
    }

    public static final ColorDefinition AliceBlue() {
        return new ColorDefinition(0.9411765, 0.972549, 1.0);
    }

    public static final ColorDefinition AntiqueWhite() {
        return new ColorDefinition(0.98039216, 0.92156863, 0.84313726);
    }

    public static final ColorDefinition Aqua() {
        return new ColorDefinition(0.0, 1.0, 1.0);
    }

    public static final ColorDefinition Aquamarine() {
        return new ColorDefinition(0.49803922, 1.0, 0.83137256);
    }

    public static final ColorDefinition Azure() {
        return new ColorDefinition(0.9411765, 1.0, 1.0);
    }

    public static final ColorDefinition Beige() {
        return new ColorDefinition(0.9607843, 0.9607843, 0.8627451);
    }

    public static final ColorDefinition Bisque() {
        return new ColorDefinition(1.0, 0.89411765, 0.76862746);
    }

    public static final ColorDefinition Black() {
        return new ColorDefinition(0.0, 0.0, 0.0);
    }

    public static final ColorDefinition BlanchedAlmond() {
        return new ColorDefinition(1.0, 0.92156863, 0.8039216);
    }

    public static final ColorDefinition Blue() {
        return new ColorDefinition(0.0, 0.0, 1.0);
    }

    public static final ColorDefinition BlueViolet() {
        return new ColorDefinition(0.5411765, 0.16862746, 0.8862745);
    }

    public static final ColorDefinition Brown() {
        return new ColorDefinition(0.64705884, 0.16470589, 0.16470589);
    }

    public static final ColorDefinition BurlyWood() {
        return new ColorDefinition(0.87058824, 0.72156864, 0.5294118);
    }

    public static final ColorDefinition CadetBlue() {
        return new ColorDefinition(0.37254903, 0.61960787, 0.627451);
    }

    public static final ColorDefinition Chartreuse() {
        return new ColorDefinition(0.49803922, 1.0, 0.0);
    }

    public static final ColorDefinition Chocolate() {
        return new ColorDefinition(0.8235294, 0.4117647, 0.11764706);
    }

    public static final ColorDefinition Coral() {
        return new ColorDefinition(1.0, 0.49803922, 0.3137255);
    }

    public static final ColorDefinition CornflowerBlue() {
        return new ColorDefinition(0.39215687, 0.58431375, 0.92941177);
    }

    public static final ColorDefinition Cornsilk() {
        return new ColorDefinition(1.0, 0.972549, 0.8627451);
    }

    public static final ColorDefinition Crimson() {
        return new ColorDefinition(0.8627451, 0.078431375, 0.23529412);
    }

    public static final ColorDefinition Cyan() {
        return new ColorDefinition(0.0, 1.0, 1.0);
    }

    public static final ColorDefinition DarkBlue() {
        return new ColorDefinition(0.0, 0.0, 0.54509807);
    }

    public static final ColorDefinition DarkCyan() {
        return new ColorDefinition(0.0, 0.54509807, 0.54509807);
    }

    public static final ColorDefinition DarkGoldenrod() {
        return new ColorDefinition(0.72156864, 0.5254902, 0.043137256);
    }

    public static final ColorDefinition DarkGray() {
        return new ColorDefinition(0.6627451, 0.6627451, 0.6627451);
    }

    public static final ColorDefinition DarkGreen() {
        return new ColorDefinition(0.0, 0.39215687, 0.0);
    }

    public static final ColorDefinition DarkGrey() {
        return ColorDefinitions.DarkGray();
    }

    public static final ColorDefinition DarkKhaki() {
        return new ColorDefinition(0.7411765, 0.7176471, 0.41960785);
    }

    public static final ColorDefinition DarkMagenta() {
        return new ColorDefinition(0.54509807, 0.0, 0.54509807);
    }

    public static final ColorDefinition DarkOliveGreen() {
        return new ColorDefinition(0.33333334, 0.41960785, 0.18431373);
    }

    public static final ColorDefinition DarkOrange() {
        return new ColorDefinition(1.0, 0.54901963, 0.0);
    }

    public static final ColorDefinition DarkOrchid() {
        return new ColorDefinition(0.6, 0.19607843, 0.8);
    }

    public static final ColorDefinition DarkRed() {
        return new ColorDefinition(0.54509807, 0.0, 0.0);
    }

    public static final ColorDefinition DarkSalmon() {
        return new ColorDefinition(0.9137255, 0.5882353, 0.47843137);
    }

    public static final ColorDefinition DarkSeaGreen() {
        return new ColorDefinition(0.56078434, 0.7372549, 0.56078434);
    }

    public static final ColorDefinition DarkSlateBlue() {
        return new ColorDefinition(0.28235295, 0.23921569, 0.54509807);
    }

    public static final ColorDefinition DarkSlateGray() {
        return new ColorDefinition(0.18431373, 0.30980393, 0.30980393);
    }

    public static final ColorDefinition DarkSlateGrey() {
        return ColorDefinitions.DarkSlateGray();
    }

    public static final ColorDefinition DarkTurquoise() {
        return new ColorDefinition(0.0, 0.80784315, 0.81960785);
    }

    public static final ColorDefinition DarkViolet() {
        return new ColorDefinition(0.5803922, 0.0, 0.827451);
    }

    public static final ColorDefinition DeepPink() {
        return new ColorDefinition(1.0, 0.078431375, 0.5764706);
    }

    public static final ColorDefinition DeepSkyBlue() {
        return new ColorDefinition(0.0, 0.7490196, 1.0);
    }

    public static final ColorDefinition DimGray() {
        return new ColorDefinition(0.4117647, 0.4117647, 0.4117647);
    }

    public static final ColorDefinition DimGrey() {
        return ColorDefinitions.DimGray();
    }

    public static final ColorDefinition DodgerBlue() {
        return new ColorDefinition(0.11764706, 0.5647059, 1.0);
    }

    public static final ColorDefinition FireBrick() {
        return new ColorDefinition(0.69803923, 0.13333334, 0.13333334);
    }

    public static final ColorDefinition FloralWhite() {
        return new ColorDefinition(1.0, 0.98039216, 0.9411765);
    }

    public static final ColorDefinition ForestGreen() {
        return new ColorDefinition(0.13333334, 0.54509807, 0.13333334);
    }

    public static final ColorDefinition Fuchsia() {
        return new ColorDefinition(1.0, 0.0, 1.0);
    }

    public static final ColorDefinition Gainsboro() {
        return new ColorDefinition(0.8627451, 0.8627451, 0.8627451);
    }

    public static final ColorDefinition GhostWhite() {
        return new ColorDefinition(0.972549, 0.972549, 1.0);
    }

    public static final ColorDefinition Gold() {
        return new ColorDefinition(1.0, 0.84313726, 0.0);
    }

    public static final ColorDefinition Goldenrod() {
        return new ColorDefinition(0.85490197, 0.64705884, 0.1254902);
    }

    public static final ColorDefinition Gray() {
        return new ColorDefinition(0.5019608, 0.5019608, 0.5019608);
    }

    public static final ColorDefinition Green() {
        return new ColorDefinition(0.0, 0.5019608, 0.0);
    }

    public static final ColorDefinition GreenYellow() {
        return new ColorDefinition(0.6784314, 1.0, 0.18431373);
    }

    public static final ColorDefinition Grey() {
        return ColorDefinitions.Gray();
    }

    public static final ColorDefinition Honeydew() {
        return new ColorDefinition(0.9411765, 1.0, 0.9411765);
    }

    public static final ColorDefinition HotPink() {
        return new ColorDefinition(1.0, 0.4117647, 0.7058824);
    }

    public static final ColorDefinition IndianRed() {
        return new ColorDefinition(0.8039216, 0.36078432, 0.36078432);
    }

    public static final ColorDefinition Indigo() {
        return new ColorDefinition(0.29411766, 0.0, 0.50980395);
    }

    public static final ColorDefinition Ivory() {
        return new ColorDefinition(1.0, 1.0, 0.9411765);
    }

    public static final ColorDefinition Khaki() {
        return new ColorDefinition(0.9411765, 0.9019608, 0.54901963);
    }

    public static final ColorDefinition Lavender() {
        return new ColorDefinition(0.9019608, 0.9019608, 0.98039216);
    }

    public static final ColorDefinition LavenderBlush() {
        return new ColorDefinition(1.0, 0.9411765, 0.9607843);
    }

    public static final ColorDefinition LawnGreen() {
        return new ColorDefinition(0.4862745, 0.9882353, 0.0);
    }

    public static final ColorDefinition LemonChiffon() {
        return new ColorDefinition(1.0, 0.98039216, 0.8039216);
    }

    public static final ColorDefinition LightBlue() {
        return new ColorDefinition(0.6784314, 0.84705883, 0.9019608);
    }

    public static final ColorDefinition LightCoral() {
        return new ColorDefinition(0.9411765, 0.5019608, 0.5019608);
    }

    public static final ColorDefinition LightCyan() {
        return new ColorDefinition(0.8784314, 1.0, 1.0);
    }

    public static final ColorDefinition LightGoldenrodYellow() {
        return new ColorDefinition(0.98039216, 0.98039216, 0.8235294);
    }

    public static final ColorDefinition LightGray() {
        return new ColorDefinition(0.827451, 0.827451, 0.827451);
    }

    public static final ColorDefinition LightGreen() {
        return new ColorDefinition(0.5647059, 0.93333334, 0.5647059);
    }

    public static final ColorDefinition LightGrey() {
        return ColorDefinitions.LightGray();
    }

    public static final ColorDefinition LightPink() {
        return new ColorDefinition(1.0, 0.7137255, 0.75686276);
    }

    public static final ColorDefinition LightSalmon() {
        return new ColorDefinition(1.0, 0.627451, 0.47843137);
    }

    public static final ColorDefinition LightSeaGreen() {
        return new ColorDefinition(0.1254902, 0.69803923, 0.6666667);
    }

    public static final ColorDefinition LightSkyBlue() {
        return new ColorDefinition(0.5294118, 0.80784315, 0.98039216);
    }

    public static final ColorDefinition LightSlateGray() {
        return new ColorDefinition(0.46666667, 0.53333336, 0.6);
    }

    public static final ColorDefinition LightSlateGrey() {
        return ColorDefinitions.LightSlateGray();
    }

    public static final ColorDefinition LightSteelBlue() {
        return new ColorDefinition(0.6901961, 0.76862746, 0.87058824);
    }

    public static final ColorDefinition LightYellow() {
        return new ColorDefinition(1.0, 1.0, 0.8784314);
    }

    public static final ColorDefinition Lime() {
        return new ColorDefinition(0.0, 1.0, 0.0);
    }

    public static final ColorDefinition LimeGreen() {
        return new ColorDefinition(0.19607843, 0.8039216, 0.19607843);
    }

    public static final ColorDefinition Linen() {
        return new ColorDefinition(0.98039216, 0.9411765, 0.9019608);
    }

    public static final ColorDefinition Magenta() {
        return new ColorDefinition(1.0, 0.0, 1.0);
    }

    public static final ColorDefinition Maroon() {
        return new ColorDefinition(0.5019608, 0.0, 0.0);
    }

    public static final ColorDefinition MediumAquamarine() {
        return new ColorDefinition(0.4, 0.8039216, 0.6666667);
    }

    public static final ColorDefinition MediumBlue() {
        return new ColorDefinition(0.0, 0.0, 0.8039216);
    }

    public static final ColorDefinition MediumOrchid() {
        return new ColorDefinition(0.7294118, 0.33333334, 0.827451);
    }

    public static final ColorDefinition MediumPurple() {
        return new ColorDefinition(0.5764706, 0.4392157, 0.85882354);
    }

    public static final ColorDefinition MediumSeaGreen() {
        return new ColorDefinition(0.23529412, 0.7019608, 0.44313726);
    }

    public static final ColorDefinition MediumSlateBlue() {
        return new ColorDefinition(0.48235294, 0.40784314, 0.93333334);
    }

    public static final ColorDefinition MediumSpringGreen() {
        return new ColorDefinition(0.0, 0.98039216, 0.6039216);
    }

    public static final ColorDefinition MediumTurquoise() {
        return new ColorDefinition(0.28235295, 0.81960785, 0.8);
    }

    public static final ColorDefinition MediumVioletRed() {
        return new ColorDefinition(0.78039217, 0.08235294, 0.52156866);
    }

    public static final ColorDefinition MidnightBlue() {
        return new ColorDefinition(0.09803922, 0.09803922, 0.4392157);
    }

    public static final ColorDefinition MintCream() {
        return new ColorDefinition(0.9607843, 1.0, 0.98039216);
    }

    public static final ColorDefinition MistyRose() {
        return new ColorDefinition(1.0, 0.89411765, 0.88235295);
    }

    public static final ColorDefinition Moccasin() {
        return new ColorDefinition(1.0, 0.89411765, 0.70980394);
    }

    public static final ColorDefinition NavajoWhite() {
        return new ColorDefinition(1.0, 0.87058824, 0.6784314);
    }

    public static final ColorDefinition Navy() {
        return new ColorDefinition(0.0, 0.0, 0.5019608);
    }

    public static final ColorDefinition OldLace() {
        return new ColorDefinition(0.99215686, 0.9607843, 0.9019608);
    }

    public static final ColorDefinition Olive() {
        return new ColorDefinition(0.5019608, 0.5019608, 0.0);
    }

    public static final ColorDefinition OliveDrab() {
        return new ColorDefinition(0.41960785, 0.5568628, 0.13725491);
    }

    public static final ColorDefinition Orange() {
        return new ColorDefinition(1.0, 0.64705884, 0.0);
    }

    public static final ColorDefinition OrangeRed() {
        return new ColorDefinition(1.0, 0.27058825, 0.0);
    }

    public static final ColorDefinition Orchid() {
        return new ColorDefinition(0.85490197, 0.4392157, 0.8392157);
    }

    public static final ColorDefinition PaleGoldenrod() {
        return new ColorDefinition(0.93333334, 0.9098039, 0.6666667);
    }

    public static final ColorDefinition PaleGreen() {
        return new ColorDefinition(0.59607846, 0.9843137, 0.59607846);
    }

    public static final ColorDefinition PaleTurquoise() {
        return new ColorDefinition(0.6862745, 0.93333334, 0.93333334);
    }

    public static final ColorDefinition PaleVioletRed() {
        return new ColorDefinition(0.85882354, 0.4392157, 0.5764706);
    }

    public static final ColorDefinition PapayaWhip() {
        return new ColorDefinition(1.0, 0.9372549, 0.8352941);
    }

    public static final ColorDefinition PeachPuff() {
        return new ColorDefinition(1.0, 0.85490197, 0.7254902);
    }

    public static final ColorDefinition Peru() {
        return new ColorDefinition(0.8039216, 0.52156866, 0.24705882);
    }

    public static final ColorDefinition Pink() {
        return new ColorDefinition(1.0, 0.7529412, 0.79607844);
    }

    public static final ColorDefinition Plum() {
        return new ColorDefinition(0.8666667, 0.627451, 0.8666667);
    }

    public static final ColorDefinition PowderBlue() {
        return new ColorDefinition(0.6901961, 0.8784314, 0.9019608);
    }

    public static final ColorDefinition Purple() {
        return new ColorDefinition(0.5019608, 0.0, 0.5019608);
    }

    public static final ColorDefinition Red() {
        return new ColorDefinition(1.0, 0.0, 0.0);
    }

    public static final ColorDefinition RosyBrown() {
        return new ColorDefinition(0.7372549, 0.56078434, 0.56078434);
    }

    public static final ColorDefinition RoyalBlue() {
        return new ColorDefinition(0.25490198, 0.4117647, 0.88235295);
    }

    public static final ColorDefinition SaddleBrown() {
        return new ColorDefinition(0.54509807, 0.27058825, 0.07450981);
    }

    public static final ColorDefinition Salmon() {
        return new ColorDefinition(0.98039216, 0.5019608, 0.44705883);
    }

    public static final ColorDefinition SandyBrown() {
        return new ColorDefinition(0.95686275, 0.6431373, 0.3764706);
    }

    public static final ColorDefinition SeaGreen() {
        return new ColorDefinition(0.18039216, 0.54509807, 0.34117648);
    }

    public static final ColorDefinition SeaShell() {
        return new ColorDefinition(1.0, 0.9607843, 0.93333334);
    }

    public static final ColorDefinition Sienna() {
        return new ColorDefinition(0.627451, 0.32156864, 0.1764706);
    }

    public static final ColorDefinition Silver() {
        return new ColorDefinition(0.7529412, 0.7529412, 0.7529412);
    }

    public static final ColorDefinition SkyBlue() {
        return new ColorDefinition(0.5294118, 0.80784315, 0.92156863);
    }

    public static final ColorDefinition SlateBlue() {
        return new ColorDefinition(0.41568628, 0.3529412, 0.8039216);
    }

    public static final ColorDefinition SlateGray() {
        return new ColorDefinition(0.4392157, 0.5019608, 0.5647059);
    }

    public static final ColorDefinition SlateGrey() {
        return ColorDefinitions.SlateGray();
    }

    public static final ColorDefinition Snow() {
        return new ColorDefinition(1.0, 0.98039216, 0.98039216);
    }

    public static final ColorDefinition SpringGreen() {
        return new ColorDefinition(0.0, 1.0, 0.49803922);
    }

    public static final ColorDefinition SteelBlue() {
        return new ColorDefinition(0.27450982, 0.50980395, 0.7058824);
    }

    public static final ColorDefinition Tan() {
        return new ColorDefinition(0.8235294, 0.7058824, 0.54901963);
    }

    public static final ColorDefinition Teal() {
        return new ColorDefinition(0.0, 0.5019608, 0.5019608);
    }

    public static final ColorDefinition Thistle() {
        return new ColorDefinition(0.84705883, 0.7490196, 0.84705883);
    }

    public static final ColorDefinition Tomato() {
        return new ColorDefinition(1.0, 0.3882353, 0.2784314);
    }

    public static final ColorDefinition Turquoise() {
        return new ColorDefinition(0.2509804, 0.8784314, 0.8156863);
    }

    public static final ColorDefinition Violet() {
        return new ColorDefinition(0.93333334, 0.50980395, 0.93333334);
    }

    public static final ColorDefinition Wheat() {
        return new ColorDefinition(0.9607843, 0.87058824, 0.7019608);
    }

    public static final ColorDefinition White() {
        return new ColorDefinition(1.0, 1.0, 1.0);
    }

    public static final ColorDefinition WhiteSmoke() {
        return new ColorDefinition(0.9607843, 0.9607843, 0.9607843);
    }

    public static final ColorDefinition Yellow() {
        return new ColorDefinition(1.0, 1.0, 0.0);
    }

    public static final ColorDefinition YellowGreen() {
        return new ColorDefinition(0.6039216, 0.8039216, 0.19607843);
    }

    static {
        Map<String, ColorDefinition> map = Stream.of(ColorDefinitions.class.getDeclaredMethods()).filter(ColorDefinitions::isNamedColorMethod).collect(Collectors.toMap(m -> m.getName().toLowerCase(), ColorDefinitions::invokeMethod));
        namedColorLowerCaseMap = Collections.unmodifiableMap(map);
    }
}

