/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicListDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoListDefinition;

public abstract class YoGraphicDefinition {
    public static final String SEPARATOR = ":";
    private static final boolean DEBUG_PARSING;
    protected String name;
    protected boolean visible = true;
    @XmlTransient
    private final Map<String, FieldInfoConverter> definitionFields = new LinkedHashMap<String, FieldInfoConverter>();

    public YoGraphicDefinition() {
        this.registerStringField("name", this::getName, this::setName);
        this.registerBooleanField("visible", this::isVisible, this::setVisible);
    }

    @XmlAttribute
    public final void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoGraphicDefinition) {
            YoGraphicDefinition other = (YoGraphicDefinition)object;
            return Objects.equals(this.name, other.name) && this.visible == other.visible;
        }
        return false;
    }

    public final String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + "[";
        boolean first = true;
        for (FieldInfoConverter fieldInfo : this.definitionFields.values()) {
            if (!first) {
                out = out + ", ";
            }
            out = out + fieldInfo.fieldName + "=" + fieldInfo.fieldValueSupplier.get();
            first = false;
        }
        out = out + "]";
        return out;
    }

    static <T> String indentedListString(int indent, boolean useBrace, List<T> list, Function<T, String> elementToString) {
        if (list == null) {
            return "null";
        }
        if (list.isEmpty()) {
            return useBrace ? "{}" : "[]";
        }
        String openingCharacter = useBrace ? "{" : "[";
        String closingCharacter = useBrace ? "}" : "]";
        String prefix = openingCharacter + "\n" + "\t".repeat(indent + 1);
        String suffix = "\n" + "\t".repeat(indent) + closingCharacter;
        String separator = "\n" + "\t".repeat(indent + 1);
        return EuclidCoreIOTools.getCollectionString((String)prefix, (String)suffix, (String)separator, list, elementToString);
    }

    protected final String toParsableString() {
        return this.getClass().getSimpleName() + "=" + this.name;
    }

    static YoGraphicDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("YoGraphic")) {
            int equalsIndex = value.indexOf("=");
            String className = value.substring(0, equalsIndex);
            String name = value.substring(equalsIndex + 1);
            try {
                String fullClassName = "%s.%s".formatted(YoGraphicDefinition.class.getPackageName(), className);
                Class<?> definitionClass = Class.forName(fullClassName);
                YoGraphicDefinition definition = (YoGraphicDefinition)definitionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                definition.setName(name);
                return definition;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unexpected yoGraphic definition format: " + value, e);
            }
        }
        throw new IllegalArgumentException("Unexpected yoGraphic definition format: " + value);
    }

    public static List<YoGraphicFieldsSummary> exportSubtreeYoGraphicFieldsSummaryList(Collection<YoGraphicGroupDefinition> roots) {
        ArrayList<YoGraphicFieldsSummary> output = new ArrayList<YoGraphicFieldsSummary>();
        for (YoGraphicGroupDefinition root : roots) {
            YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList(root, output);
        }
        return output;
    }

    public static List<YoGraphicFieldsSummary> exportSubtreeYoGraphicFieldsSummaryList(YoGraphicGroupDefinition root) {
        return YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList(root, null);
    }

    static List<YoGraphicFieldsSummary> exportSubtreeYoGraphicFieldsSummaryList(YoGraphicGroupDefinition root, List<YoGraphicFieldsSummary> outputToPack) {
        if (root == null) {
            return null;
        }
        root.unwrapLists();
        if (outputToPack == null) {
            outputToPack = new ArrayList<YoGraphicFieldsSummary>();
        }
        outputToPack.add(root.exportYoGraphicFieldsSummary());
        List<YoGraphicDefinition> children = root.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                YoGraphicDefinition child = children.get(i);
                if (child instanceof YoGraphicGroupDefinition) {
                    YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)child;
                    outputToPack.addAll(YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList(subGroup));
                    continue;
                }
                if (child instanceof YoGraphicListDefinition) {
                    YoGraphicListDefinition list = (YoGraphicListDefinition)child;
                    if (list.getYoGraphics() == null) continue;
                    for (int j = 0; j < list.getYoGraphics().size(); ++j) {
                        outputToPack.add(list.getYoGraphics().get(j).exportYoGraphicFieldsSummary());
                    }
                    continue;
                }
                outputToPack.add(child.exportYoGraphicFieldsSummary());
            }
        }
        return outputToPack;
    }

    public static List<YoGraphicGroupDefinition> parseTreeYoGraphicFieldsSummary(List<YoGraphicFieldsSummary> treeYoGraphicFieldsSummaryList) {
        if (treeYoGraphicFieldsSummaryList == null) {
            return null;
        }
        treeYoGraphicFieldsSummaryList = new LinkedList<YoGraphicFieldsSummary>(treeYoGraphicFieldsSummaryList);
        ArrayList<YoGraphicGroupDefinition> parsed = new ArrayList<YoGraphicGroupDefinition>();
        while (!treeYoGraphicFieldsSummaryList.isEmpty()) {
            YoGraphicGroupDefinition rootGroup = new YoGraphicGroupDefinition();
            YoGraphicDefinition.parseTreeFieldValueInfoRecursive(rootGroup, treeYoGraphicFieldsSummaryList);
            parsed.add(rootGroup);
        }
        return parsed;
    }

    private static void parseTreeFieldValueInfoRecursive(YoGraphicGroupDefinition start, List<YoGraphicFieldsSummary> treeYoGraphicFieldsSummaryList) {
        start.parseYoGraphicFieldsInfo(treeYoGraphicFieldsSummaryList.remove(0));
        List<YoGraphicDefinition> children = start.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                YoGraphicDefinition child = children.get(i);
                if (child instanceof YoGraphicGroupDefinition) {
                    YoGraphicGroupDefinition subGroup = (YoGraphicGroupDefinition)child;
                    YoGraphicDefinition.parseTreeFieldValueInfoRecursive(subGroup, treeYoGraphicFieldsSummaryList);
                    continue;
                }
                child.parseYoGraphicFieldsInfo(treeYoGraphicFieldsSummaryList.remove(0));
            }
        }
    }

    YoGraphicFieldsSummary exportYoGraphicFieldsSummary() {
        YoGraphicFieldsSummary out = new YoGraphicFieldsSummary();
        for (FieldInfoConverter definitionField : this.definitionFields.values()) {
            String value = definitionField.fieldValueSupplier.get();
            if (value == null) continue;
            out.add(new YoGraphicFieldInfo(definitionField.fieldName, value));
        }
        return out;
    }

    void parseYoGraphicFieldsInfo(YoGraphicFieldsSummary fieldsSummary) {
        for (YoGraphicFieldInfo fieldNameStringValueEntry : fieldsSummary) {
            FieldInfoConverter field = this.definitionFields.get(fieldNameStringValueEntry.getFieldName());
            if (field == null) {
                if (!DEBUG_PARSING) continue;
                LogTools.error((String)"Could not find field: {} for type: {}", (Object)fieldNameStringValueEntry.getFieldValue(), (Object)this.getClass().getSimpleName());
                continue;
            }
            try {
                field.fieldValueParser.accept(fieldNameStringValueEntry.getFieldValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Error for definition: %s, field: %s, value: %s".formatted(this.getClass().getSimpleName(), field.fieldName, fieldNameStringValueEntry.getFieldValue()), e);
            }
        }
    }

    protected final <T> void registerListField(String fieldName, Supplier<List<T>> fieldValueGetter, Consumer<List<T>> fieldValueSetter, String elementLabel, Function<T, String> elementToString, Function<String, T> elementParser) {
        this.registerStringField(fieldName, () -> {
            List value = (List)fieldValueGetter.get();
            return value == null ? null : YoGraphicDefinition.listToParsableString(value, elementLabel, elementToString);
        }, value -> fieldValueSetter.accept(YoGraphicDefinition.parseList(value, elementLabel, elementParser)));
    }

    static <T> String listToParsableString(List<T> list, String elementLabel, Function<T, String> elementToString) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("List(");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(elementLabel).append(i).append("=").append(elementToString.apply(list.get(i)));
        }
        sb.append(")");
        return sb.toString();
    }

    static <T> List<T> parseList(String value, String elementLabel, Function<String, T> elementParser) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("List")) {
            String nextElementLabel;
            int indexOfLabel;
            String elementsSustring = value.substring(5, value.length() - 1).trim();
            ArrayList<T> list = new ArrayList<T>();
            if (elementsSustring.isEmpty()) {
                return list;
            }
            elementsSustring = elementsSustring.substring(elementLabel.length() + 2).trim();
            int nextElementIndex = 1;
            while ((indexOfLabel = elementsSustring.indexOf(nextElementLabel = ", %s%d=".formatted(elementLabel, nextElementIndex))) != -1) {
                String element = elementsSustring.substring(0, indexOfLabel);
                list.add(elementParser.apply(element));
                elementsSustring = elementsSustring.substring(indexOfLabel + nextElementLabel.length());
                ++nextElementIndex;
            }
            list.add(elementParser.apply(elementsSustring));
            return list;
        }
        throw new IllegalArgumentException("Unknown list format: " + value);
    }

    protected final void registerYoListField(String fieldName, Supplier<YoListDefinition> fieldValueGetter, Consumer<YoListDefinition> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Objects.toString(fieldValueGetter.get(), null), value -> fieldValueSetter.accept(YoListDefinition.parse(value)));
    }

    protected final void registerTuple2DField(String fieldName, Supplier<YoTuple2DDefinition> fieldValueGetter, Consumer<YoTuple2DDefinition> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Objects.toString(fieldValueGetter.get(), null), value -> fieldValueSetter.accept(YoTuple2DDefinition.parse(value)));
    }

    protected final void registerTuple3DField(String fieldName, Supplier<YoTuple3DDefinition> fieldValueGetter, Consumer<YoTuple3DDefinition> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Objects.toString(fieldValueGetter.get(), null), value -> fieldValueSetter.accept(YoTuple3DDefinition.parse(value)));
    }

    protected final void registerOrientation3DField(String fieldName, Supplier<YoOrientation3DDefinition> fieldValueGetter, Consumer<YoOrientation3DDefinition> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Objects.toString(fieldValueGetter.get(), null), value -> fieldValueSetter.accept(YoOrientation3DDefinition.parse(value)));
    }

    protected final void registerPaintField(String fieldName, Supplier<PaintDefinition> fieldValueGetter, Consumer<PaintDefinition> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Objects.toString(fieldValueGetter.get(), null), value -> fieldValueSetter.accept(PaintDefinition.parse(value)));
    }

    protected final void registerDoubleField(String fieldName, DoubleSupplier fieldValueGetter, DoubleConsumer fieldValueSetter) {
        this.registerStringField(fieldName, () -> Double.toString(fieldValueGetter.getAsDouble()), string -> fieldValueSetter.accept(Double.parseDouble(string)));
    }

    protected final void registerBooleanField(String fieldName, BooleanSupplier fieldValueGetter, Consumer<Boolean> fieldValueSetter) {
        this.registerStringField(fieldName, () -> Boolean.toString(fieldValueGetter.getAsBoolean()), string -> fieldValueSetter.accept(Boolean.valueOf(string)));
    }

    protected final void registerStringField(String fieldName, Supplier<String> fieldValueGetter, Consumer<String> fieldValueSetter) {
        this.definitionFields.put(fieldName, new FieldInfoConverter(fieldName, fieldValueGetter, fieldValueSetter));
    }

    static {
        boolean debugParsingValue = false;
        String debugParsingProp = System.getProperty("scs2.definition.debugParsing");
        if (debugParsingProp != null) {
            debugParsingValue = Boolean.parseBoolean(debugParsingProp);
        }
        DEBUG_PARSING = debugParsingValue;
    }

    private static class FieldInfoConverter {
        private final String fieldName;
        private final Supplier<String> fieldValueSupplier;
        private final Consumer<String> fieldValueParser;

        public FieldInfoConverter(String fieldName, Supplier<String> fieldValueSupplier, Consumer<String> fieldValueParser) {
            this.fieldName = fieldName;
            this.fieldValueSupplier = fieldValueSupplier;
            this.fieldValueParser = fieldValueParser;
        }
    }

    public static class YoGraphicFieldsSummary
    extends ArrayList<YoGraphicFieldInfo> {
        private static final long serialVersionUID = -1654039568977911943L;
    }

    public static class YoGraphicFieldInfo {
        private final String fieldName;
        private final String fieldValue;

        public YoGraphicFieldInfo(String fieldName, String fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }
    }
}

