/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;

public class STPConvexPolytope3DDefinition
extends ConvexPolytope3DDefinition {
    private double minimumMargin;
    private double maximumMargin;

    public STPConvexPolytope3DDefinition() {
    }

    public STPConvexPolytope3DDefinition(ConvexPolytope3DDefinition other) {
        super(other);
    }

    public STPConvexPolytope3DDefinition(STPConvexPolytope3DDefinition other) {
        super(other);
        this.setMargins(other.minimumMargin, other.maximumMargin);
    }

    public STPConvexPolytope3DDefinition(ConvexPolytope3DReadOnly convexPolytope) {
        super(convexPolytope);
    }

    public void setMargins(double minimumMargin, double maximumMargin) {
        this.setMinimumMargin(minimumMargin);
        this.setMaximumMargin(maximumMargin);
    }

    public void setMinimumMargin(double minimumMargin) {
        this.minimumMargin = minimumMargin;
    }

    public void setMaximumMargin(double maximumMargin) {
        this.maximumMargin = maximumMargin;
    }

    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public STPConvexPolytope3DDefinition copy() {
        return new STPConvexPolytope3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minimumMargin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.maximumMargin);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        STPConvexPolytope3DDefinition other = (STPConvexPolytope3DDefinition)object;
        if (Double.doubleToLongBits(this.minimumMargin) != Double.doubleToLongBits(other.minimumMargin)) {
            return false;
        }
        return Double.doubleToLongBits(this.maximumMargin) == Double.doubleToLongBits(other.maximumMargin);
    }

    @Override
    public String toString() {
        return "STP" + super.toString().replace("]", "") + EuclidCoreIOTools.getStringOf((String)", margins: (", (String)")]", (String)", ", (double[])new double[]{this.minimumMargin, this.maximumMargin});
    }
}

