/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Cylinder3DDefinition
extends GeometryDefinition {
    private double length;
    private double radius;
    private boolean centered = true;
    private int resolution = 64;

    public Cylinder3DDefinition() {
        this.setName("cylinder");
    }

    public Cylinder3DDefinition(double length, double radius) {
        this();
        this.length = length;
        this.radius = radius;
    }

    public Cylinder3DDefinition(double length, double radius, int resolution) {
        this();
        this.length = length;
        this.radius = radius;
        this.resolution = resolution;
    }

    public Cylinder3DDefinition(double length, double radius, boolean centered) {
        this();
        this.length = length;
        this.radius = radius;
        this.centered = centered;
    }

    public Cylinder3DDefinition(double length, double radius, boolean centered, int resolution) {
        this();
        this.length = length;
        this.radius = radius;
        this.centered = centered;
        this.resolution = resolution;
    }

    public Cylinder3DDefinition(Cylinder3DDefinition other) {
        this.setName(other.getName());
        this.length = other.length;
        this.radius = other.radius;
        this.centered = other.centered;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setLength(double length) {
        this.length = length;
    }

    @XmlElement
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @XmlElement
    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getLength() {
        return this.length;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Cylinder3DDefinition copy() {
        return new Cylinder3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.length);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.centered);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.resolution);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Cylinder3DDefinition other = (Cylinder3DDefinition)object;
        if (Double.doubleToLongBits(this.length) != Double.doubleToLongBits(other.length)) {
            return false;
        }
        if (Double.doubleToLongBits(this.radius) != Double.doubleToLongBits(other.radius)) {
            return false;
        }
        if (this.centered != other.centered) {
            return false;
        }
        return this.resolution == other.resolution;
    }

    public String toString() {
        return "Cylinder: [name: " + this.getName() + ", length: " + this.length + ", radius: " + this.radius + ", resolution: " + this.resolution + "]";
    }
}

