/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.scs2.definition.visual.PaintDefinition;

@XmlType(propOrder={"red", "green", "blue", "alpha"})
public class YoColorRGBAIntDefinition
extends PaintDefinition {
    private String red;
    private String green;
    private String blue;
    private String alpha;

    public YoColorRGBAIntDefinition() {
    }

    public YoColorRGBAIntDefinition(String red, String green, String blue) {
        this(red, green, blue, null);
    }

    public YoColorRGBAIntDefinition(String red, String green, String blue, String alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public YoColorRGBAIntDefinition(YoColorRGBAIntDefinition other) {
        this.red = other.red;
        this.green = other.green;
        this.blue = other.blue;
        this.alpha = other.alpha;
    }

    public void setRed(double red) {
        this.setRed(Integer.toString((int)(red * 255.0)));
    }

    public void setRed(int red) {
        this.setRed(Integer.toString(red));
    }

    @XmlAttribute
    public void setRed(String red) {
        this.red = red;
    }

    public void setGreen(double green) {
        this.setGreen(Integer.toString((int)(green * 255.0)));
    }

    public void setGreen(int green) {
        this.setGreen(Integer.toString(green));
    }

    @XmlAttribute
    public void setGreen(String green) {
        this.green = green;
    }

    public void setBlue(double blue) {
        this.setBlue(Integer.toString((int)(blue * 255.0)));
    }

    public void setBlue(int blue) {
        this.setBlue(Integer.toString(blue));
    }

    @XmlAttribute
    public void setBlue(String blue) {
        this.blue = blue;
    }

    public void setAlpha(double alpha) {
        this.setAlpha(Integer.toString((int)(alpha * 255.0)));
    }

    public void setAlpha(int alpha) {
        this.setAlpha(Integer.toString(alpha));
    }

    @XmlAttribute
    public void setAlpha(String alpha) {
        this.alpha = alpha;
    }

    public String getRed() {
        return this.red;
    }

    public String getGreen() {
        return this.green;
    }

    public String getBlue() {
        return this.blue;
    }

    public String getAlpha() {
        return this.alpha;
    }

    @Override
    public YoColorRGBAIntDefinition copy() {
        return new YoColorRGBAIntDefinition(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoColorRGBAIntDefinition) {
            YoColorRGBAIntDefinition other = (YoColorRGBAIntDefinition)object;
            if (!Objects.equals(this.red, other.red)) {
                return false;
            }
            if (!Objects.equals(this.green, other.green)) {
                return false;
            }
            if (!Objects.equals(this.blue, other.blue)) {
                return false;
            }
            return Objects.equals(this.alpha, other.alpha);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.alpha == null) {
            return "YoIntRGB(red=%s, green=%s, blue=%s)".formatted(this.red, this.green, this.blue);
        }
        return "YoIntRGBA(red=%s, green=%s, blue=%s, alpha=%s)".formatted(this.red, this.green, this.blue, this.alpha);
    }

    public static YoColorRGBAIntDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("YoIntRGB")) {
            String alpha;
            String blue;
            boolean parseAlpha = (value = value.substring(8, value.length() - 1)).charAt(0) == 'A';
            value = value.substring(value.indexOf("=") + 1);
            String red = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1);
            String green = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1);
            if (parseAlpha) {
                blue = value.substring(0, value.indexOf(","));
                alpha = value.substring(value.indexOf("=") + 1);
            } else {
                blue = value;
                alpha = null;
            }
            if (red.equalsIgnoreCase("null")) {
                red = null;
            }
            if (green.equalsIgnoreCase("null")) {
                green = null;
            }
            if (blue.equalsIgnoreCase("null")) {
                blue = null;
            }
            if (parseAlpha && alpha.equalsIgnoreCase("null")) {
                alpha = null;
            }
            return new YoColorRGBAIntDefinition(red, green, blue, alpha);
        }
        throw new IllegalArgumentException("Unknown color format: " + value);
    }
}

